/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.internal.operators.CompletableOnSubscribeMerge;
import rx.internal.util.atomic.MpscLinkedAtomicQueue;
import rx.internal.util.unsafe.MpscLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeMergeDelayErrorIterable
implements Completable.OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeDelayErrorIterable(Iterable<? extends Completable> sources) {
        this.sources = sources;
    }

    @Override
    public void call(final CompletableSubscriber s) {
        Iterator<? extends Completable> iterator;
        final CompositeSubscription set2 = new CompositeSubscription();
        s.onSubscribe(set2);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e2) {
            s.onError(e2);
            return;
        }
        if (iterator == null) {
            s.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final AbstractQueue queue = UnsafeAccess.isUnsafeAvailable() ? new MpscLinkedQueue() : new MpscLinkedAtomicQueue();
        while (true) {
            Completable c;
            boolean b;
            if (set2.isUnsubscribed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e3) {
                queue.offer(e3);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onCompleted();
                    } else {
                        s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (!b) break;
            if (set2.isUnsubscribed()) {
                return;
            }
            try {
                c = iterator.next();
            }
            catch (Throwable e4) {
                queue.offer(e4);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onCompleted();
                    } else {
                        s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (set2.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                NullPointerException e5 = new NullPointerException("A completable source is null");
                queue.offer(e5);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s.onCompleted();
                    } else {
                        s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            wip.getAndIncrement();
            c.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onSubscribe(Subscription d) {
                    set2.add(d);
                }

                @Override
                public void onError(Throwable e2) {
                    queue.offer(e2);
                    this.tryTerminate();
                }

                @Override
                public void onCompleted() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (queue.isEmpty()) {
                            s.onCompleted();
                        } else {
                            s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (queue.isEmpty()) {
                s.onCompleted();
            } else {
                s.onError(CompletableOnSubscribeMerge.collectErrors(queue));
            }
        }
    }
}

