/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public final class OnSubscribeRange
implements Observable.OnSubscribe<Integer> {
    private final int startIndex;
    private final int endIndex;

    public OnSubscribeRange(int start, int end) {
        this.startIndex = start;
        this.endIndex = end;
    }

    @Override
    public void call(Subscriber<? super Integer> childSubscriber) {
        childSubscriber.setProducer(new RangeProducer(childSubscriber, this.startIndex, this.endIndex));
    }

    static final class RangeProducer
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = 4114392207069098388L;
        private final Subscriber<? super Integer> childSubscriber;
        private final int endOfRange;
        private long currentIndex;

        RangeProducer(Subscriber<? super Integer> childSubscriber, int startIndex, int endIndex) {
            this.childSubscriber = childSubscriber;
            this.currentIndex = startIndex;
            this.endOfRange = endIndex;
        }

        @Override
        public void request(long requestedAmount) {
            long c;
            if (this.get() == Long.MAX_VALUE) {
                return;
            }
            if (requestedAmount == Long.MAX_VALUE && this.compareAndSet(0L, Long.MAX_VALUE)) {
                this.fastPath();
            } else if (requestedAmount > 0L && (c = BackpressureUtils.getAndAddRequest(this, requestedAmount)) == 0L) {
                this.slowPath(requestedAmount);
            }
        }

        void slowPath(long requestedAmount) {
            long emitted = 0L;
            long endIndex = (long)this.endOfRange + 1L;
            long index2 = this.currentIndex;
            Subscriber<? super Integer> childSubscriber = this.childSubscriber;
            while (true) {
                if (emitted != requestedAmount && index2 != endIndex) {
                    if (childSubscriber.isUnsubscribed()) {
                        return;
                    }
                    childSubscriber.onNext((Integer)((int)index2));
                    ++index2;
                    ++emitted;
                    continue;
                }
                if (childSubscriber.isUnsubscribed()) {
                    return;
                }
                if (index2 == endIndex) {
                    childSubscriber.onCompleted();
                    return;
                }
                requestedAmount = this.get();
                if (requestedAmount != emitted) continue;
                this.currentIndex = index2;
                requestedAmount = this.addAndGet(-emitted);
                if (requestedAmount == 0L) break;
                emitted = 0L;
            }
        }

        void fastPath() {
            long endIndex = (long)this.endOfRange + 1L;
            Subscriber<? super Integer> childSubscriber = this.childSubscriber;
            for (long index2 = this.currentIndex; index2 != endIndex; ++index2) {
                if (childSubscriber.isUnsubscribed()) {
                    return;
                }
                childSubscriber.onNext((Integer)((int)index2));
            }
            if (!childSubscriber.isUnsubscribed()) {
                childSubscriber.onCompleted();
            }
        }
    }
}

