/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.producers.ProducerArbiter;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.SerialSubscription;

public final class OperatorOnErrorResumeNextViaFunction<T>
implements Observable.Operator<T, T> {
    final Func1<? super Throwable, ? extends Observable<? extends T>> resumeFunction;

    public static <T> OperatorOnErrorResumeNextViaFunction<T> withSingle(final Func1<? super Throwable, ? extends T> resumeFunction) {
        return new OperatorOnErrorResumeNextViaFunction<T>(new Func1<Throwable, Observable<? extends T>>(){

            @Override
            public Observable<? extends T> call(Throwable t) {
                return Observable.just(resumeFunction.call(t));
            }
        });
    }

    public static <T> OperatorOnErrorResumeNextViaFunction<T> withOther(final Observable<? extends T> other) {
        return new OperatorOnErrorResumeNextViaFunction<T>(new Func1<Throwable, Observable<? extends T>>(){

            @Override
            public Observable<? extends T> call(Throwable t) {
                return other;
            }
        });
    }

    public static <T> OperatorOnErrorResumeNextViaFunction<T> withException(final Observable<? extends T> other) {
        return new OperatorOnErrorResumeNextViaFunction<T>(new Func1<Throwable, Observable<? extends T>>(){

            @Override
            public Observable<? extends T> call(Throwable t) {
                if (t instanceof Exception) {
                    return other;
                }
                return Observable.error(t);
            }
        });
    }

    public OperatorOnErrorResumeNextViaFunction(Func1<? super Throwable, ? extends Observable<? extends T>> f) {
        this.resumeFunction = f;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final ProducerArbiter pa = new ProducerArbiter();
        final SerialSubscription serial = new SerialSubscription();
        Subscriber parent = new Subscriber<T>(){
            private boolean done;
            long produced;

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                if (this.done) {
                    Exceptions.throwIfFatal(e2);
                    RxJavaHooks.onError(e2);
                    return;
                }
                this.done = true;
                try {
                    this.unsubscribe();
                    Subscriber next2 = new Subscriber<T>(){

                        @Override
                        public void onNext(T t) {
                            child.onNext(t);
                        }

                        @Override
                        public void onError(Throwable e2) {
                            child.onError(e2);
                        }

                        @Override
                        public void onCompleted() {
                            child.onCompleted();
                        }

                        @Override
                        public void setProducer(Producer producer) {
                            pa.setProducer(producer);
                        }
                    };
                    serial.set(next2);
                    long p = this.produced;
                    if (p != 0L) {
                        pa.produced(p);
                    }
                    Observable resume = OperatorOnErrorResumeNextViaFunction.this.resumeFunction.call(e2);
                    resume.unsafeSubscribe(next2);
                }
                catch (Throwable e22) {
                    Exceptions.throwOrReport(e22, child);
                }
            }

            @Override
            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                ++this.produced;
                child.onNext(t);
            }

            @Override
            public void setProducer(Producer producer) {
                pa.setProducer(producer);
            }
        };
        serial.set(parent);
        child.add(serial);
        child.setProducer(pa);
        return parent;
    }
}

