/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.BackpressureUtils;
import rx.subjects.Subject;

public final class PublishSubject<T>
extends Subject<T, T> {
    final PublishSubjectState<T> state;

    public static <T> PublishSubject<T> create() {
        return new PublishSubject(new PublishSubjectState());
    }

    protected PublishSubject(PublishSubjectState<T> state) {
        super(state);
        this.state = state;
    }

    @Override
    public void onNext(T v) {
        this.state.onNext(v);
    }

    @Override
    public void onError(Throwable e2) {
        this.state.onError(e2);
    }

    @Override
    public void onCompleted() {
        this.state.onCompleted();
    }

    @Override
    public boolean hasObservers() {
        return ((PublishSubjectProducer[])this.state.get()).length != 0;
    }

    public boolean hasThrowable() {
        return this.state.get() == PublishSubjectState.TERMINATED && this.state.error != null;
    }

    public boolean hasCompleted() {
        return this.state.get() == PublishSubjectState.TERMINATED && this.state.error == null;
    }

    public Throwable getThrowable() {
        if (this.state.get() == PublishSubjectState.TERMINATED) {
            return this.state.error;
        }
        return null;
    }

    static final class PublishSubjectProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription,
    Observer<T> {
        private static final long serialVersionUID = 6451806817170721536L;
        final PublishSubjectState<T> parent;
        final Subscriber<? super T> actual;
        long produced;

        public PublishSubjectProducer(PublishSubjectState<T> parent, Subscriber<? super T> actual) {
            this.parent = parent;
            this.actual = actual;
        }

        @Override
        public void request(long n) {
            if (BackpressureUtils.validate(n)) {
                long u;
                long r;
                do {
                    if ((r = this.get()) != Long.MIN_VALUE) continue;
                    return;
                } while (!this.compareAndSet(r, u = BackpressureUtils.addCap(r, n)));
                return;
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void unsubscribe() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        @Override
        public void onNext(T t) {
            long r = this.get();
            if (r != Long.MIN_VALUE) {
                long p = this.produced;
                if (r != p) {
                    this.produced = p + 1L;
                    this.actual.onNext(t);
                } else {
                    this.unsubscribe();
                    this.actual.onError(new MissingBackpressureException("PublishSubject: could not emit value due to lack of requests"));
                }
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.get() != Long.MIN_VALUE) {
                this.actual.onError(e2);
            }
        }

        @Override
        public void onCompleted() {
            if (this.get() != Long.MIN_VALUE) {
                this.actual.onCompleted();
            }
        }
    }

    static final class PublishSubjectState<T>
    extends AtomicReference<PublishSubjectProducer<T>[]>
    implements Observable.OnSubscribe<T>,
    Observer<T> {
        private static final long serialVersionUID = -7568940796666027140L;
        static final PublishSubjectProducer[] EMPTY = new PublishSubjectProducer[0];
        static final PublishSubjectProducer[] TERMINATED = new PublishSubjectProducer[0];
        Throwable error;

        public PublishSubjectState() {
            this.lazySet(EMPTY);
        }

        @Override
        public void call(Subscriber<? super T> t) {
            PublishSubjectProducer<T> pp2 = new PublishSubjectProducer<T>(this, t);
            t.add(pp2);
            t.setProducer(pp2);
            if (this.add(pp2)) {
                if (pp2.isUnsubscribed()) {
                    this.remove(pp2);
                }
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    t.onError(ex);
                } else {
                    t.onCompleted();
                }
            }
        }

        boolean add(PublishSubjectProducer<T> inner) {
            PublishSubjectProducer[] next2;
            PublishSubjectProducer[] curr;
            do {
                if ((curr = (PublishSubjectProducer[])this.get()) == TERMINATED) {
                    return false;
                }
                int n = curr.length;
                next2 = new PublishSubjectProducer[n + 1];
                System.arraycopy(curr, 0, next2, 0, n);
                next2[n] = inner;
            } while (!this.compareAndSet(curr, next2));
            return true;
        }

        void remove(PublishSubjectProducer<T> inner) {
            PublishSubjectProducer[] next2;
            PublishSubjectProducer[] curr;
            do {
                if ((curr = (PublishSubjectProducer[])this.get()) == TERMINATED || curr == EMPTY) {
                    return;
                }
                int n = curr.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (curr[i] != inner) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    next2 = EMPTY;
                    continue;
                }
                next2 = new PublishSubjectProducer[n - 1];
                System.arraycopy(curr, 0, next2, 0, j);
                System.arraycopy(curr, j + 1, next2, j, n - j - 1);
            } while (!this.compareAndSet(curr, next2));
        }

        @Override
        public void onNext(T t) {
            for (PublishSubjectProducer pp2 : (PublishSubjectProducer[])this.get()) {
                pp2.onNext(t);
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.error = e2;
            ArrayList<Throwable> errors = null;
            for (PublishSubjectProducer pp2 : this.getAndSet(TERMINATED)) {
                try {
                    pp2.onError(e2);
                }
                catch (Throwable ex) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>(1);
                    }
                    errors.add(ex);
                }
            }
            Exceptions.throwIfAny(errors);
        }

        @Override
        public void onCompleted() {
            for (PublishSubjectProducer pp2 : this.getAndSet(TERMINATED)) {
                pp2.onCompleted();
            }
        }
    }
}

