/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.reactivex.mantis.remote.observable.MergeCounts;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;

public class MergedObservable<T> {
    private static final Logger logger = LoggerFactory.getLogger(MergedObservable.class);
    private Subject<Observable<T>, Observable<T>> subject;
    private MergeCounts counts;
    private Map<String, PublishSubject<Integer>> takeUntilSubjects = new HashMap<String, PublishSubject<Integer>>();

    private MergedObservable(int expectedTerminalCount, Subject<Observable<T>, Observable<T>> subject) {
        this.subject = subject;
        this.counts = new MergeCounts(expectedTerminalCount);
    }

    public static <T> MergedObservable<T> create(int expectedTerminalCount) {
        return new MergedObservable<T>(expectedTerminalCount, PublishSubject.create());
    }

    public static <T> MergedObservable<T> createWithReplay(int expectedTerminalCount) {
        return new MergedObservable<T>(expectedTerminalCount, ReplaySubject.create());
    }

    public synchronized void mergeIn(String key, Observable<T> o) {
        if (!this.takeUntilSubjects.containsKey(key)) {
            PublishSubject takeUntil = PublishSubject.create();
            this.publishWithCallbacks(key, o.takeUntil((Observable)takeUntil), null, null);
            this.takeUntilSubjects.put(key, (PublishSubject<Integer>)takeUntil);
        } else {
            logger.warn("Key alreay exists, ignoring merge request for observable with key: " + key);
        }
    }

    public synchronized void mergeIn(String key, Observable<T> o, Action1<Throwable> errorCallback, Action0 successCallback) {
        if (!this.takeUntilSubjects.containsKey(key)) {
            PublishSubject takeUntil = PublishSubject.create();
            this.publishWithCallbacks(key, o.takeUntil((Observable)takeUntil), errorCallback, successCallback);
            this.takeUntilSubjects.put(key, (PublishSubject<Integer>)takeUntil);
        } else {
            logger.warn("Key alreay exists, ignoring merge request for observable with key: " + key);
        }
    }

    synchronized void clear() {
        this.takeUntilSubjects.clear();
    }

    private synchronized void publishWithCallbacks(final String key, Observable<T> o, final Action1<Throwable> errorCallback, final Action0 successCallback) {
        this.subject.onNext((Object)o.doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable t1) {
                if (errorCallback != null) {
                    errorCallback.call((Object)t1);
                }
                logger.error("Inner observable with key: " + key + " terminated with onError, calling onError() on outer observable." + t1.getMessage(), t1);
                MergedObservable.this.takeUntilSubjects.remove(key);
                MergedObservable.this.subject.onError(t1);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                if (successCallback != null) {
                    successCallback.call();
                }
                logger.debug("Inner observable with key: " + key + " completed, incrementing terminal count.");
                MergedObservable.this.takeUntilSubjects.remove(key);
                if (MergedObservable.this.counts.incrementTerminalCountAndCheck()) {
                    logger.debug("All inner observables terminated, calling onCompleted() on outer observable.");
                    MergedObservable.this.subject.onCompleted();
                }
            }
        }));
    }

    public synchronized void forceComplete(String key) {
        PublishSubject<Integer> takeUntil = this.takeUntilSubjects.get(key);
        if (takeUntil != null) {
            takeUntil.onNext((Object)1);
        } else {
            logger.debug("Nothing to force complete, key doesn't exist: " + key);
        }
    }

    public synchronized Observable<Observable<T>> get() {
        return this.subject;
    }
}

