/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;

public class RxMetrics {
    private Metrics metrics = new Metrics.Builder().name("RemoteObservableMetrics").addCounter("onNext").addCounter("onNextFailure").addCounter("onError").addCounter("onErrorFailure").addCounter("onComplete").addCounter("onCompleteFailure").addCounter("subscribe").addCounter("unsubscribe").build();
    private Counter next = this.metrics.getCounter("onNext");
    private Counter nextFailure = this.metrics.getCounter("onNextFailure");
    private Counter error = this.metrics.getCounter("onError");
    private Counter errorFailure = this.metrics.getCounter("onErrorFailure");
    private Counter complete = this.metrics.getCounter("onComplete");
    private Counter completeFailure = this.metrics.getCounter("onCompleteFailure");
    private Counter subscribe = this.metrics.getCounter("subscribe");
    private Counter unsubscribe = this.metrics.getCounter("unsubscribe");

    public Metrics getCountersAndGauges() {
        return this.metrics;
    }

    public void incrementNextFailureCount() {
        this.nextFailure.increment();
    }

    public void incrementNextFailureCount(long numFailed) {
        this.nextFailure.increment(numFailed);
    }

    public void incrementNextCount() {
        this.next.increment();
    }

    public void incrementNextCount(long numOnNext) {
        this.next.increment(numOnNext);
    }

    public void incrementErrorCount() {
        this.error.increment();
    }

    public void incrementErrorFailureCount() {
        this.errorFailure.increment();
    }

    public void incrementCompletedCount() {
        this.complete.increment();
    }

    public void incrementCompletedFailureCount() {
        this.completeFailure.increment();
    }

    public void incrementSubscribedCount() {
        this.subscribe.increment();
    }

    public void incrementUnsubscribedCount() {
        this.unsubscribe.increment();
    }

    public long getOnNextRollingCount() {
        return this.next.rateValue();
    }

    public long getOnNextCount() {
        return this.next.value();
    }

    public long getOnNextFailureCount() {
        return this.nextFailure.value();
    }

    public long getOnNextRollingFailureCount() {
        return this.nextFailure.rateValue();
    }

    public long getOnErrorRollingCount() {
        return this.error.rateValue();
    }

    public long getOnErrorCount() {
        return this.error.value();
    }

    public long getOnErrorFailureCount() {
        return this.errorFailure.value();
    }

    public long getOnErrorRollingFailureCount() {
        return this.errorFailure.rateValue();
    }

    public long getOnCompletedRollingCount() {
        return this.complete.rateValue();
    }

    public long getOnCompletedRollingFailureCount() {
        return this.completeFailure.rateValue();
    }

    public long getOnCompletedCount() {
        return this.complete.value();
    }

    public long getOnCompletedFailureCount() {
        return this.completeFailure.value();
    }

    public long getSubscribedCount() {
        return this.subscribe.value();
    }

    public long getUnsubscribedCount() {
        return this.unsubscribe.value();
    }
}

