/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable.slotting;

import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.network.RoundRobinRouter;
import io.mantisrx.common.network.WritableEndpoint;
import io.reactivex.mantis.remote.observable.slotting.SlottingStrategy;

public class RoundRobin<T>
extends SlottingStrategy<T> {
    private RoundRobinRouter<T> router = new RoundRobinRouter();

    public Metrics getMetrics() {
        return this.router.getMetrics();
    }

    @Override
    public synchronized boolean addConnection(WritableEndpoint<T> endpoint) {
        boolean wasEmpty = this.router.isEmpty();
        boolean isRegistered = this.router.add(endpoint);
        if (wasEmpty && isRegistered) {
            this.doAfterFirstConnectionAdded.call();
        }
        return isRegistered;
    }

    @Override
    public synchronized boolean removeConnection(WritableEndpoint<T> endpoint) {
        boolean isDeregistered = this.router.remove(endpoint);
        if (isDeregistered && this.router.isEmpty()) {
            this.doAfterLastConnectionRemoved.call();
        }
        return isDeregistered;
    }

    @Override
    public void writeOnSlot(byte[] keyBytes, T data) {
        this.router.nextSlot().write(data);
    }

    @Override
    public void completeAllConnections() {
        this.router.completeAllEndpoints();
    }

    @Override
    public void errorAllConnections(Throwable e) {
        this.router.errorAllEndpoints(e);
    }
}

