/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collection;

public final class JvmUtils {
    public static Collection<ThreadInfo> createThreadDump() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        return Arrays.asList(threadMxBean.dumpAllThreads(true, true));
    }

    public static String createThreadDumpAsString() {
        StringBuilder dump = new StringBuilder();
        Collection<ThreadInfo> threadInfos = JvmUtils.createThreadDump();
        for (ThreadInfo threadInfo : threadInfos) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    private JvmUtils() {
    }
}

