/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.metrics.cgroups;

import io.mantisrx.shaded.com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class ProcFileReader
implements Closeable {
    private final InputStream mStream;
    private final byte[] mBuffer;
    private int mTail;
    private boolean mLineFinished;

    public ProcFileReader(InputStream stream) throws IOException {
        this(stream, 4096);
    }

    public ProcFileReader(InputStream stream, int bufferSize) throws IOException {
        this.mStream = stream;
        this.mBuffer = new byte[bufferSize];
        this.fillBuf();
    }

    private int fillBuf() throws IOException {
        int length = this.mBuffer.length - this.mTail;
        if (length == 0) {
            throw new IOException("attempting to fill already-full buffer");
        }
        int read = this.mStream.read(this.mBuffer, this.mTail, length);
        if (read != -1) {
            this.mTail += read;
        }
        return read;
    }

    private void consumeBuf(int count) throws IOException {
        System.arraycopy(this.mBuffer, count, this.mBuffer, 0, this.mTail - count);
        this.mTail -= count;
        if (this.mTail == 0) {
            this.fillBuf();
        }
    }

    private int nextStartIndex() throws IOException {
        for (int i = 0; i < this.mTail; ++i) {
            if (this.mBuffer[i] == 32) continue;
            return i;
        }
        return this.mTail;
    }

    private int nextTokenIndex() throws IOException {
        if (this.mLineFinished) {
            throw new IOException("no tokens remaining on current line");
        }
        int i = 0;
        boolean nonWhitespaceSeen = false;
        while (true) {
            if (i < this.mTail) {
                byte b = this.mBuffer[i];
                if (b == 10) {
                    this.mLineFinished = true;
                    return i;
                }
                if (b == 32 && nonWhitespaceSeen) {
                    return i;
                }
                if (b != 32) {
                    nonWhitespaceSeen = true;
                }
                ++i;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new IOException("end of stream while looking for token boundary");
    }

    public boolean hasMoreData() {
        return this.mTail > 0;
    }

    public void finishLine() throws IOException {
        if (this.mLineFinished) {
            this.mLineFinished = false;
            return;
        }
        int i = 0;
        while (true) {
            if (i < this.mTail) {
                if (this.mBuffer[i] == 10) {
                    this.consumeBuf(i + 1);
                    return;
                }
                ++i;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new IOException("end of stream while looking for line boundary");
    }

    public String nextString() throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == 0) {
            return "";
        }
        int startIndex = this.nextStartIndex();
        String s = new String(this.mBuffer, startIndex, tokenIndex - startIndex, Charsets.US_ASCII);
        this.consumeBuf(tokenIndex + 1);
        return s;
    }

    public long nextLong() throws IOException {
        int i;
        int tokenIndex = this.nextTokenIndex();
        int startIndex = this.nextStartIndex();
        boolean negative = this.mBuffer[startIndex] == 45;
        long result = 0L;
        int n = i = negative ? startIndex + 1 : startIndex;
        while (i < tokenIndex) {
            int digit = this.mBuffer[i] - 48;
            if (digit < 0 || digit > 9) {
                throw this.invalidLong(tokenIndex);
            }
            long next = result * 10L - (long)digit;
            if (next > result) {
                throw this.invalidLong(tokenIndex);
            }
            result = next;
            ++i;
        }
        this.consumeBuf(tokenIndex + 1);
        return negative ? result : -result;
    }

    private NumberFormatException invalidLong(int tokenIndex) {
        return new NumberFormatException("invalid long: " + new String(this.mBuffer, 0, tokenIndex, Charsets.US_ASCII));
    }

    public int nextInt() throws IOException {
        long value = this.nextLong();
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new NumberFormatException("parsed value larger than integer");
        }
        return (int)value;
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }
}

