/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class InstantiationUtil {
    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException iex) {
            InstantiationUtil.checkForInstantiation(clazz);
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' due to an unspecified exception: " + iex.getMessage(), iex);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' Most likely the constructor (or a member variable initialization) threw an exception" + (message == null ? "." : ": " + message), t);
        }
    }

    public static <T> T instantiate(String className, Class<T> targetType, ClassLoader classLoader) throws Exception {
        Class<T> clazz;
        try {
            clazz = Class.forName(className, false, classLoader).asSubclass(targetType);
        }
        catch (ClassNotFoundException e) {
            throw new Exception(String.format("Could not instantiate class '%s' of type '%s'. Please make sure that this class is on your class path.", className, targetType.getName()), e);
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static void checkForInstantiation(Class<?> clazz) {
        String errorMessage = InstantiationUtil.checkForInstantiationError(clazz);
        if (errorMessage != null) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not instantiable: " + errorMessage);
        }
    }

    public static String checkForInstantiationError(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            return "The class is not public.";
        }
        if (clazz.isArray()) {
            return "The class is an array. An array cannot be simply instantiated, as with a parameterless constructor.";
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            return "The class is not a proper class. It is either abstract, an interface, or a primitive type.";
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            return "The class is an inner class, but not statically accessible.";
        }
        if (!InstantiationUtil.hasPublicNullaryConstructor(clazz)) {
            return "The class has no (implicit) public nullary constructor, i.e. a constructor without arguments.";
        }
        return null;
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProperClass(Class<?> clazz) {
        int mods = clazz.getModifiers();
        return !Modifier.isAbstract(mods) && !Modifier.isInterface(mods) && !Modifier.isNative(mods);
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && (clazz.getDeclaringClass() == null || !Modifier.isStatic(clazz.getModifiers()));
    }

    public static boolean hasPublicNullaryConstructor(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }
}

