/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.clutch.rps;

import io.mantisrx.server.worker.jobmaster.clutch.ClutchPIDConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.beans.ConstructorProperties;

public class ClutchRpsPIDConfig
extends ClutchPIDConfig {
    public static final ClutchRpsPIDConfig DEFAULT = new ClutchRpsPIDConfig(0.0, (Tuple2<Double, Double>)Tuple.of((Object)30.0, (Object)0.0), 0.0, 0.0, (Option<Double>)Option.of((Object)75.0), (Option<Double>)Option.of((Object)0.0), (Option<Double>)Option.of((Object)0.0), (Option<Double>)Option.of((Object)1.0), (Option<Double>)Option.of((Object)1.0));
    public final double setPointPercentile;
    public final double scaleUpAbovePct;
    public final double scaleDownBelowPct;
    public final double scaleUpMultiplier;
    public final double scaleDownMultiplier;

    @ConstructorProperties(value={"setPoint", "rope", "kp", "kd", "setPointPercentile", "scaleUpAbovePct", "scaleDownBelowPct", "scaleUpMultiplier", "scaleDownMultiplier"})
    public ClutchRpsPIDConfig(double setPoint, Tuple2<Double, Double> rope, double kp, double kd, Option<Double> setPointPercentile, Option<Double> scaleUpAbovePct, Option<Double> scaleDownBelowPct, Option<Double> scaleUpMultiplier, Option<Double> scaleDownMultiplier) {
        super(setPoint, rope == null ? DEFAULT.getRope() : rope, kp, kd);
        this.setPointPercentile = (Double)setPointPercentile.getOrElse(() -> DEFAULT.getSetPointPercentile());
        this.scaleUpAbovePct = (Double)scaleUpAbovePct.getOrElse(() -> DEFAULT.getScaleUpAbovePct());
        this.scaleDownBelowPct = (Double)scaleDownBelowPct.getOrElse(() -> DEFAULT.getScaleDownBelowPct());
        this.scaleUpMultiplier = (Double)scaleUpMultiplier.getOrElse(() -> DEFAULT.getScaleUpMultiplier());
        this.scaleDownMultiplier = (Double)scaleDownMultiplier.getOrElse(() -> DEFAULT.getScaleDownMultiplier());
    }

    public double getSetPointPercentile() {
        return this.setPointPercentile;
    }

    public double getScaleUpAbovePct() {
        return this.scaleUpAbovePct;
    }

    public double getScaleDownBelowPct() {
        return this.scaleDownBelowPct;
    }

    public double getScaleUpMultiplier() {
        return this.scaleUpMultiplier;
    }

    public double getScaleDownMultiplier() {
        return this.scaleDownMultiplier;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClutchRpsPIDConfig)) {
            return false;
        }
        ClutchRpsPIDConfig other = (ClutchRpsPIDConfig)o;
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getSetPointPercentile(), other.getSetPointPercentile()) != 0) {
            return false;
        }
        if (Double.compare(this.getScaleUpAbovePct(), other.getScaleUpAbovePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getScaleDownBelowPct(), other.getScaleDownBelowPct()) != 0) {
            return false;
        }
        if (Double.compare(this.getScaleUpMultiplier(), other.getScaleUpMultiplier()) != 0) {
            return false;
        }
        return Double.compare(this.getScaleDownMultiplier(), other.getScaleDownMultiplier()) == 0;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $setPointPercentile = Double.doubleToLongBits(this.getSetPointPercentile());
        result = result * 59 + (int)($setPointPercentile >>> 32 ^ $setPointPercentile);
        long $scaleUpAbovePct = Double.doubleToLongBits(this.getScaleUpAbovePct());
        result = result * 59 + (int)($scaleUpAbovePct >>> 32 ^ $scaleUpAbovePct);
        long $scaleDownBelowPct = Double.doubleToLongBits(this.getScaleDownBelowPct());
        result = result * 59 + (int)($scaleDownBelowPct >>> 32 ^ $scaleDownBelowPct);
        long $scaleUpMultiplier = Double.doubleToLongBits(this.getScaleUpMultiplier());
        result = result * 59 + (int)($scaleUpMultiplier >>> 32 ^ $scaleUpMultiplier);
        long $scaleDownMultiplier = Double.doubleToLongBits(this.getScaleDownMultiplier());
        result = result * 59 + (int)($scaleDownMultiplier >>> 32 ^ $scaleDownMultiplier);
        return result;
    }

    @Override
    public String toString() {
        return "ClutchRPSPIDConfig(setPoint=" + this.getSetPoint() + ", rope=" + this.getRope() + ", kp=" + this.getKp() + ", kd=" + this.getKd() + ", setPointPercentile=" + this.getSetPointPercentile() + ", scaleUpAbovePct=" + this.getScaleUpAbovePct() + ", scaleDownBelowPct=" + this.getScaleDownBelowPct() + ", scaleUpMultiplier=" + this.getScaleUpMultiplier() + ", scaleDownMultiplier=" + this.getScaleDownMultiplier() + ")";
    }
}

