/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.clutch.rps;

import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.IScaleComputer;
import io.mantisrx.server.worker.jobmaster.clutch.rps.ClutchRpsPIDConfig;

public class RpsScaleComputer
implements IScaleComputer {
    private final ClutchRpsPIDConfig rpsConfig;

    public RpsScaleComputer(ClutchRpsPIDConfig rpsConfig) {
        if (rpsConfig == null) {
            rpsConfig = ClutchRpsPIDConfig.DEFAULT;
        }
        this.rpsConfig = rpsConfig;
    }

    public Double apply(ClutchConfiguration config, Long currentScale, Double delta) {
        double scaleUpPct = this.rpsConfig.getScaleUpAbovePct() / 100.0;
        double scaleDownPct = this.rpsConfig.getScaleDownBelowPct() / 100.0;
        if (delta > -scaleDownPct && delta < scaleUpPct) {
            return (double)currentScale;
        }
        if (delta >= scaleUpPct) {
            delta = delta * this.rpsConfig.getScaleUpMultiplier();
        }
        if (delta <= -scaleDownPct) {
            delta = delta * this.rpsConfig.getScaleDownMultiplier();
        }
        double scale = Math.round((double)currentScale.longValue() + (double)currentScale.longValue() * delta);
        scale = Math.min((double)config.getMaxSize(), Math.max((double)config.getMinSize(), scale));
        return scale;
    }
}

