/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.control.controllers;

import io.mantisrx.server.worker.jobmaster.control.Controller;
import io.mantisrx.shaded.com.google.common.util.concurrent.AtomicDouble;

public class PIDController
extends Controller {
    private final Double kp;
    private final Double ki;
    private final Double kd;
    private final AtomicDouble dampener;
    private final double deltaT;
    private Double previous = 0.0;
    private Double integral = 0.0;
    private Double derivative = 0.0;

    public PIDController(Double kp, Double ki, Double kd, Double deltaT, AtomicDouble dampener) {
        this.kp = kp;
        this.ki = ki;
        this.kd = kd;
        this.deltaT = deltaT;
        this.dampener = dampener;
    }

    public static PIDController of(Double kp, Double ki, Double kd, Double deltaT) {
        return new PIDController(kp, ki, kd, deltaT, new AtomicDouble(1.0));
    }

    public static PIDController of(Double kp, Double ki, Double kd) {
        return new PIDController(kp, ki, kd, 1.0, new AtomicDouble(1.0));
    }

    public static PIDController of(Double kp, Double ki, Double kd, Double deltaT, AtomicDouble dampener) {
        return new PIDController(kp, ki, kd, deltaT, dampener);
    }

    @Override
    public Double processStep(Double error) {
        PIDController pIDController = this;
        pIDController.integral = pIDController.integral + this.deltaT * error;
        this.derivative = (error - this.previous) / this.deltaT;
        this.previous = error;
        return this.dampener.get() * this.kp * error + this.dampener.get() * this.ki * this.integral + this.dampener.get() * this.kd * this.derivative;
    }
}

