/*
 * Copyright [ 2020 - 2023 ] [Matthew Buckton]
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.mapsmessaging.security.identity;

import java.util.Base64;

public class JwtHelper {

  private JwtHelper() {}

  public static boolean isJwt(String token) {
    // Check if the token has three parts (header, payload, signature)
    String[] tokenParts = token.split("\\.");
    if (tokenParts.length != 3) {
      return false;
    }

    // Decode the header and payload and check if they are valid Base64 strings
    try {
      Base64.getUrlDecoder().decode(tokenParts[0]);
      Base64.getUrlDecoder().decode(tokenParts[1]);
    } catch (IllegalArgumentException e) {
      return false;
    }
    return true;
  }
}
