/*
 * Copyright [ 2020 - 2024 ] [Matthew Buckton]
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.mapsmessaging.security.identity;

import java.security.SecureRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PasswordGenerator {

  private static final String SALT_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

  public static String generateSalt(int saltLength) {
    return generateRandom(saltLength, SALT_CHARACTERS);
  }

  private static String generateRandom(int passwordLength, String chars) {
    SecureRandom random = new SecureRandom();
    return IntStream.range(0, passwordLength)
        .map(i -> chars.charAt(random.nextInt(chars.length())))
        .mapToObj(c -> String.valueOf((char) c))
        .collect(Collectors.joining());
  }

  public static byte[] generateSaltBytes(int passwordLength) {
    SecureRandom random = new SecureRandom();
    byte[] buf = new byte[passwordLength];
    random.nextBytes(buf);
    return buf;
  }

  private PasswordGenerator(){}
}