/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.operators.Operation;

public class Identifier
extends Operation {
    private final String key;

    public Identifier(String key) {
        this.key = key;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) {
        if (resolver == null) {
            return null;
        }
        Object response = resolver.get(this.key);
        if (response != null) {
            if (response instanceof Number) {
                if (response instanceof Double) {
                    return ((Number)response).doubleValue();
                }
                if (response instanceof Float) {
                    return Float.valueOf(((Number)response).floatValue());
                }
                return ((Number)response).longValue();
            }
            return response;
        }
        return null;
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Identifier) {
            return this.key.equals(((Identifier)rhs).key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public Object compile() {
        return this;
    }

    public String toString() {
        return "<IDENTIFIER>[" + this.key + "]";
    }

    public String getKey() {
        return this.key;
    }
}

