/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector;

import io.mapsmessaging.selector.Identifier;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.SelectorParserConstants;
import io.mapsmessaging.selector.SelectorParserTokenManager;
import io.mapsmessaging.selector.SimpleCharStream;
import io.mapsmessaging.selector.Token;
import io.mapsmessaging.selector.operators.Operation;
import io.mapsmessaging.selector.operators.ParserBooleanOperation;
import io.mapsmessaging.selector.operators.ParserExecutor;
import io.mapsmessaging.selector.operators.ParserOperationExecutor;
import io.mapsmessaging.selector.operators.arithmetic.AddOperator;
import io.mapsmessaging.selector.operators.arithmetic.DivideOperator;
import io.mapsmessaging.selector.operators.arithmetic.MultiplyOperator;
import io.mapsmessaging.selector.operators.arithmetic.NegateOperator;
import io.mapsmessaging.selector.operators.arithmetic.SubtractOperator;
import io.mapsmessaging.selector.operators.comparison.DifferentOperator;
import io.mapsmessaging.selector.operators.comparison.EqualOperator;
import io.mapsmessaging.selector.operators.comparison.GreaterOrEqualOperator;
import io.mapsmessaging.selector.operators.comparison.GreaterThanOperator;
import io.mapsmessaging.selector.operators.comparison.LessOrEqualOperator;
import io.mapsmessaging.selector.operators.comparison.LessThanOperator;
import io.mapsmessaging.selector.operators.extentions.ParserFactory;
import io.mapsmessaging.selector.operators.functions.BetweenOperator;
import io.mapsmessaging.selector.operators.functions.InOperator;
import io.mapsmessaging.selector.operators.functions.IsOperator;
import io.mapsmessaging.selector.operators.functions.LikeOperator;
import io.mapsmessaging.selector.operators.logical.AndOperator;
import io.mapsmessaging.selector.operators.logical.NotOperator;
import io.mapsmessaging.selector.operators.logical.OrOperator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectorParser
implements SelectorParserConstants {
    private Map<String, Identifier> identifierMap = new LinkedHashMap<String, Identifier>();
    public SelectorParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();

    public SelectorParser() {
    }

    public Object parse(String selector, boolean trace) throws ParseException {
        if (trace) {
            this.enable_tracing();
        } else {
            this.disable_tracing();
        }
        return this.expression();
    }

    private String stripQuotes(String image) {
        return image.substring(1, image.length() - 1);
    }

    public static ParserExecutor compile(String selector) throws ParseException {
        Object parser = SelectorParser.compile(selector, false);
        if (parser instanceof Operation && (parser = ((Operation)parser).compile()) instanceof Operation) {
            return new ParserOperationExecutor((Operation)parser);
        }
        if (parser instanceof Boolean) {
            return new ParserBooleanOperation((Boolean)parser);
        }
        return new ParserBooleanOperation(false);
    }

    private static Object compile(String selector, boolean trace) throws ParseException {
        SelectorParser parser = new SelectorParser(new ByteArrayInputStream(selector.getBytes()), "UTF-8");
        return parser.parse(selector, trace);
    }

    public final Object expression() throws ParseException {
        Object exp1 = null;
        exp1 = this.logicExpression();
        this.jj_consume_token(0);
        return exp1;
    }

    public final Object logicExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.notExpression();
        while (this.jj_2_1(3)) {
            if (this.jj_2_2(3)) {
                this.jj_consume_token(8);
                exp2 = this.notExpression();
                exp1 = new AndOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_3(3)) {
                this.jj_consume_token(10);
                exp2 = this.notExpression();
                exp1 = new OrOperator(exp1, exp2);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object notExpression() throws ParseException {
        Object exp1 = null;
        if (this.jj_2_4(3)) {
            exp1 = this.relationalExpression();
            return exp1;
        }
        if (this.jj_2_5(3)) {
            this.jj_consume_token(9);
            exp1 = this.relationalExpression();
            return new NotOperator(exp1);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object relationalExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.orEqualExpression();
        while (this.jj_2_6(3)) {
            if (this.jj_2_7(3)) {
                this.jj_consume_token(28);
                exp2 = this.orEqualExpression();
                exp1 = new LessThanOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_8(3)) {
                this.jj_consume_token(26);
                exp2 = this.orEqualExpression();
                exp1 = new GreaterThanOperator(exp1, exp2);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object orEqualExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.equalExpression();
        while (this.jj_2_9(3)) {
            if (this.jj_2_10(3)) {
                this.jj_consume_token(29);
                exp2 = this.equalExpression();
                exp1 = new LessOrEqualOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_11(3)) {
                this.jj_consume_token(27);
                exp2 = this.equalExpression();
                exp1 = new GreaterOrEqualOperator(exp1, exp2);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object equalExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        Object exp3 = null;
        HashSet<String> set = null;
        exp1 = this.additiveExpression();
        while (this.jj_2_12(3)) {
            if (this.jj_2_13(3)) {
                this.jj_consume_token(30);
                exp2 = this.additiveExpression();
                exp1 = new DifferentOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_14(3)) {
                this.jj_consume_token(31);
                exp2 = this.additiveExpression();
                exp1 = new EqualOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_15(3)) {
                this.jj_consume_token(14);
                exp1 = this.nullExp(exp1);
                continue;
            }
            if (this.jj_2_16(3)) {
                this.jj_consume_token(11);
                exp2 = this.additiveExpression();
                this.jj_consume_token(8);
                exp3 = this.additiveExpression();
                exp1 = new BetweenOperator(exp1, exp2, exp3);
                continue;
            }
            if (this.jj_2_17(3)) {
                this.jj_consume_token(14);
                exp1 = this.nullExp(exp1);
                continue;
            }
            if (this.jj_2_18(3)) {
                this.jj_consume_token(9);
                this.jj_consume_token(11);
                exp2 = this.additiveExpression();
                this.jj_consume_token(8);
                exp3 = this.additiveExpression();
                exp1 = new BetweenOperator(exp1, exp2, exp3);
                exp1 = new NotOperator(exp1);
                continue;
            }
            if (this.jj_2_19(3)) {
                this.jj_consume_token(12);
                exp1 = this.likeExp(exp1);
                continue;
            }
            if (this.jj_2_20(3)) {
                this.jj_consume_token(9);
                this.jj_consume_token(12);
                exp1 = this.likeExp(exp1);
                exp1 = new NotOperator(exp1);
                continue;
            }
            if (this.jj_2_21(3)) {
                this.jj_consume_token(13);
                this.jj_consume_token(17);
                set = new HashSet<String>();
                this.stringSet(set);
                this.jj_consume_token(18);
                exp1 = new InOperator(exp1, set);
                continue;
            }
            if (this.jj_2_22(3)) {
                this.jj_consume_token(9);
                this.jj_consume_token(13);
                this.jj_consume_token(17);
                set = new HashSet();
                this.stringSet(set);
                this.jj_consume_token(18);
                exp1 = new InOperator(exp1, set);
                exp1 = new NotOperator(exp1);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object additiveExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.multiplicativeExpression();
        while (this.jj_2_23(3)) {
            if (this.jj_2_24(3)) {
                this.jj_consume_token(25);
                exp2 = this.multiplicativeExpression();
                exp1 = new AddOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_25(3)) {
                this.jj_consume_token(24);
                exp2 = this.multiplicativeExpression();
                exp1 = new SubtractOperator(exp1, exp2);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object multiplicativeExpression() throws ParseException {
        Object exp1 = null;
        Object exp2 = null;
        exp1 = this.unaryExpression();
        while (this.jj_2_26(3)) {
            if (this.jj_2_27(3)) {
                this.jj_consume_token(22);
                exp2 = this.unaryExpression();
                exp1 = new MultiplyOperator(exp1, exp2);
                continue;
            }
            if (this.jj_2_28(3)) {
                this.jj_consume_token(23);
                exp2 = this.unaryExpression();
                exp1 = new DivideOperator(exp1, exp2);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return exp1;
    }

    public final Object unaryExpression() throws ParseException {
        Object exp1 = null;
        if (this.jj_2_29(3)) {
            this.jj_consume_token(25);
            exp1 = this.unaryExpression();
            return exp1;
        }
        if (this.jj_2_30(3)) {
            this.jj_consume_token(24);
            exp1 = this.unaryExpression();
            return new NegateOperator(exp1);
        }
        if (this.jj_2_31(3)) {
            exp1 = this.unaryExpressionNotPlusMinus();
            return exp1;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object unaryExpressionNotPlusMinus() throws ParseException {
        Token t = null;
        Object exp = null;
        ArrayList<String> list = null;
        if (this.jj_2_32(3)) {
            t = this.jj_consume_token(37);
            Identifier id = this.identifierMap.get(t.image);
            if (id == null) {
                id = new Identifier(t.image);
                this.identifierMap.put(t.image, id);
            }
            return id;
        }
        if (this.jj_2_33(3)) {
            t = this.jj_consume_token(35);
            return this.stripQuotes(t.image);
        }
        if (this.jj_2_34(3)) {
            t = this.jj_consume_token(33);
            return Double.valueOf(t.image);
        }
        if (this.jj_2_35(3)) {
            t = this.jj_consume_token(32);
            return Long.valueOf(t.image);
        }
        if (this.jj_2_36(3)) {
            t = this.jj_consume_token(5);
            return Boolean.TRUE;
        }
        if (this.jj_2_37(3)) {
            t = this.jj_consume_token(6);
            return Boolean.FALSE;
        }
        if (this.jj_2_38(3)) {
            this.jj_consume_token(17);
            exp = this.logicExpression();
            this.jj_consume_token(18);
            return exp;
        }
        if (this.jj_2_39(3)) {
            this.jj_consume_token(15);
            this.jj_consume_token(17);
            exp = this.extensionName();
            this.jj_consume_token(20);
            list = new ArrayList<String>();
            this.stringList(list);
            this.jj_consume_token(18);
            return ParserFactory.getInstance().loadParser(exp, list);
        }
        if (this.jj_2_40(3)) {
            this.jj_consume_token(21);
            return System.currentTimeMillis();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object extensionName() throws ParseException {
        Token t = null;
        Object exp = null;
        if (this.jj_2_41(3)) {
            t = this.jj_consume_token(37);
            Identifier id = this.identifierMap.get(t.image);
            if (id == null) {
                id = new Identifier(t.image);
                this.identifierMap.put(t.image, id);
            }
            return id;
        }
        if (this.jj_2_42(3)) {
            t = this.jj_consume_token(35);
            return this.stripQuotes(t.image);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Operation nullExp(Object exp1) throws ParseException {
        Token not = null;
        if (this.jj_2_43(3)) {
            not = this.jj_consume_token(9);
        }
        this.jj_consume_token(7);
        return not == null ? new IsOperator(exp1, false) : new IsOperator(exp1, true);
    }

    public final Operation likeExp(Object exp1) throws ParseException {
        Object exp2 = null;
        Object exp3 = null;
        Token esc = null;
        exp2 = this.additiveExpression();
        if (this.jj_2_44(3)) {
            esc = this.jj_consume_token(16);
            exp3 = this.additiveExpression();
        }
        LikeOperator op = null;
        op = esc == null ? new LikeOperator(exp1, exp2) : new LikeOperator(exp1, exp2, exp3);
        return op;
    }

    public final void stringSet(Set<String> set) throws ParseException {
        this.stringSetToken(set);
        while (this.jj_2_45(3)) {
            this.jj_consume_token(20);
            this.stringSetToken(set);
        }
    }

    public final void stringSetToken(Set<String> set) throws ParseException {
        Token t = null;
        if (this.jj_2_46(3)) {
            t = this.jj_consume_token(35);
        }
        if (t != null) {
            set.add(this.stripQuotes(t.image));
        }
    }

    public final void stringList(List<String> list) throws ParseException {
        this.stringToken(list);
        while (this.jj_2_47(3)) {
            this.jj_consume_token(20);
            this.stringToken(list);
        }
    }

    public final void stringToken(List<String> list) throws ParseException {
        Token t = null;
        if (this.jj_2_48(3)) {
            t = this.jj_consume_token(35);
        }
        if (t != null) {
            list.add(this.stripQuotes(t.image));
        }
    }

    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_4();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_5();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_6();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_7();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_8();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_9();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_10();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_11();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_12();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_13();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_14();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_15();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_16();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_17();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_18();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_19();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_20();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_21();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_22();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_23();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_24();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_25();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_26();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_27();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_28();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_29();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_30();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_31();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_32();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_33();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_34();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_35();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_36();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_37();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_38();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_39();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_40();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_41();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_42();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_43();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_44();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_45();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_46();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_47();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            return !this.jj_3_48();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private boolean jj_3_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_28()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_27() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_22();
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_48()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_48() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_28() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3R_10() {
        Token xsp;
        if (this.jj_3R_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_6());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_47() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_31()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_11();
    }

    private boolean jj_3_30() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3_31() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_11() {
        Token xsp;
        if (this.jj_3R_12()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_9());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3_32() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_36()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_37()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_38()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_39()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_40()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3_33() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_34() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3_35() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3_36() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_38() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3_39() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_21();
    }

    private boolean jj_3_40() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_12() {
        Token xsp;
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_12());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_14()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_15()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_16()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_17()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_18()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_19()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_20()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_21()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_22()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_14() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_41() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_42() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_43()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3_43() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_21() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_15() {
        if (this.jj_3R_13()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_44()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_44() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3R_13() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_25()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_20() {
        Token xsp;
        if (this.jj_3R_9()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_16() {
        Token xsp;
        if (this.jj_3R_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_45());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_25() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_46()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_46() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_4() {
        return this.jj_3R_10();
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_17() {
        Token xsp;
        if (this.jj_3R_18()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_26());
        this.jj_scanpos = xsp;
        return false;
    }

    public SelectorParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.reInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public SelectorParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.reInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public SelectorParser(SelectorParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(SelectorParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        int ret;
        this.jj_nt = this.token.next;
        Token nt = this.jj_nt;
        if (nt == null) {
            this.token.next = this.token_source.getNextToken();
            ret = this.jj_ntk = this.token.next.kind;
        } else {
            ret = this.jj_ntk = nt.kind;
        }
        return ret;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }
}

