/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.extensions;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.extensions.ParserExtension;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonParserExtension
implements ParserExtension {
    private final String[] keyPath;

    public JsonParserExtension() {
        this.keyPath = null;
    }

    public JsonParserExtension(List<String> arguments) throws ParseException {
        if (arguments.isEmpty()) {
            throw new ParseException("Requires at least 1 argument");
        }
        String key = arguments.get(0);
        if (key.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(key, ".");
            ArrayList<String> tmp = new ArrayList<String>();
            while (stringTokenizer.hasMoreElements()) {
                tmp.add(stringTokenizer.nextElement().toString());
            }
            String[] tmpPath = new String[tmp.size()];
            this.keyPath = tmp.toArray(tmpPath);
        } else {
            this.keyPath = new String[1];
            this.keyPath[0] = key;
        }
    }

    @Override
    public ParserExtension createInstance(List<String> arguments) throws ParseException {
        return new JsonParserExtension(arguments);
    }

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public String getDescription() {
        return "Parses the byte[] as a JSON object to enable filtering via the JSON object";
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) {
        JSONObject json;
        byte[] payload = resolver.getOpaqueData();
        if (payload != null && payload.length > 0 && !(json = new JSONObject(new String(payload))).isEmpty()) {
            Object located = this.locateObject(json, this.keyPath);
            return this.parseJSON(located);
        }
        return null;
    }

    public Object locateObject(JSONObject json) {
        Object t = this.locateObject(json, this.keyPath);
        if (t != null) {
            t = this.parseJSON(t);
        }
        return t;
    }

    public Object locateObject(JSONObject json, String[] searchPath) {
        if (this.keyPath != null) {
            for (int x = 0; x < searchPath.length; ++x) {
                String path = searchPath[x];
                Object jsonObject = json.get(path);
                if (jsonObject instanceof JSONArray) {
                    String[] sub = new String[searchPath.length - (x + 1)];
                    System.arraycopy(searchPath, x + 1, sub, 0, sub.length);
                    return this.arrayLookup(json.getJSONArray(path), sub);
                }
                if (!(jsonObject instanceof JSONObject)) {
                    return jsonObject;
                }
                json = (JSONObject)jsonObject;
            }
        }
        return null;
    }

    private Object arrayLookup(JSONArray array, String[] path) {
        int idx = Integer.parseInt(path[0]);
        Object lookup = array.get(idx);
        if (lookup instanceof JSONObject) {
            String[] sub = new String[path.length - 1];
            System.arraycopy(path, 1, sub, 0, sub.length);
            return this.locateObject((JSONObject)lookup, sub);
        }
        if (lookup instanceof JSONArray) {
            String[] sub = new String[path.length - 1];
            System.arraycopy(path, 1, sub, 0, sub.length);
            return this.arrayLookup((JSONArray)lookup, sub);
        }
        return lookup;
    }

    private Object parseJSON(Object lookup) {
        if (lookup instanceof String || lookup instanceof Float || lookup instanceof Double || lookup instanceof Byte || lookup instanceof Short || lookup instanceof Integer || lookup instanceof Long) {
            return lookup;
        }
        if (lookup instanceof BigDecimal) {
            return ((BigDecimal)lookup).doubleValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JSON, '");
        for (String path : this.keyPath) {
            sb.append(path).append("' ,");
        }
        return sb.toString();
    }

    public boolean equals(Object test) {
        if (test instanceof JsonParserExtension) {
            JsonParserExtension rhs = (JsonParserExtension)test;
            if (this.keyPath.length == rhs.keyPath.length) {
                for (int x = 0; x < this.keyPath.length; ++x) {
                    if (this.keyPath[x].equals(rhs.keyPath[x])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        long largeHash = 0L;
        for (String path : this.keyPath) {
            largeHash += (long)path.hashCode();
        }
        return Math.toIntExact(largeHash);
    }
}

