/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.ComputableOperator;
import io.mapsmessaging.selector.operators.Operation;
import io.mapsmessaging.selector.validators.NumericValidator;

public abstract class ArithmeticOperator
extends ComputableOperator {
    protected Object lhs;
    protected Object rhs;

    protected ArithmeticOperator(Object lhs, Object rhs) throws ParseException {
        if (!NumericValidator.isValid(lhs)) {
            throw new ParseException("Expected numeric value, received :" + lhs.getClass());
        }
        this.lhs = lhs;
        if (!NumericValidator.isValid(rhs)) {
            throw new ParseException("Expected numeric value, received :" + rhs.getClass());
        }
        this.rhs = rhs;
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof Operation) {
            this.lhs = ((Operation)this.lhs).compile();
        }
        if (this.rhs instanceof Operation) {
            this.rhs = ((Operation)this.rhs).compile();
        }
        return this.compile(this.lhs, this.rhs);
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        Number lhsNumber = ArithmeticOperator.evaluateToNumber(this.lhs, resolver);
        Number rhsNumber = ArithmeticOperator.evaluateToNumber(this.rhs, resolver);
        if (lhsNumber == null || rhsNumber == null) {
            return false;
        }
        if (lhsNumber instanceof Double) {
            return this.processDouble((Double)lhsNumber, rhsNumber);
        }
        return this.processInteger((Long)lhsNumber, rhsNumber);
    }
}

