/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.ComputableOperator;
import io.mapsmessaging.selector.operators.Operation;

public abstract class ComparisonOperator
extends ComputableOperator {
    protected Object lhs;
    protected Object rhs;

    protected ComparisonOperator(Object lhs, Object rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Object getRHS() {
        return this.rhs;
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof Operation) {
            this.lhs = ((Operation)this.lhs).compile();
        }
        if (this.rhs instanceof Operation) {
            this.rhs = ((Operation)this.rhs).compile();
        }
        if (this.lhs instanceof Number && this.rhs instanceof Number || this.lhs instanceof Boolean && this.rhs instanceof Boolean || this.lhs instanceof String && this.rhs instanceof String) {
            return this.evaluate(this.lhs, this.rhs);
        }
        return this;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        Object lhsValue = ComparisonOperator.evaluate(this.lhs, resolver);
        Object rhsValue = ComparisonOperator.evaluate(this.rhs, resolver);
        return this.evaluate(lhsValue, rhsValue);
    }

    public Object evaluate(Object lhsValue, Object rhsValue) {
        Number rhsNumber;
        if (lhsValue instanceof String && rhsValue instanceof String) {
            return this.compute((String)lhsValue, (String)rhsValue);
        }
        if (lhsValue instanceof Boolean && rhsValue instanceof Boolean) {
            return this.compute((Boolean)lhsValue, (Boolean)rhsValue);
        }
        if (lhsValue instanceof Number && rhsValue instanceof Number) {
            return this.processNumber((Number)lhsValue, (Number)rhsValue);
        }
        if (lhsValue instanceof String && rhsValue != null) {
            Number lhsNumber = ComparisonOperator.parseStringToNumber((String)lhsValue);
            if (lhsNumber != null) {
                return this.evaluate(lhsNumber, rhsValue);
            }
        } else if (rhsValue instanceof String && lhsValue != null && (rhsNumber = ComparisonOperator.parseStringToNumber((String)rhsValue)) != null) {
            return this.evaluate(lhsValue, rhsNumber);
        }
        return false;
    }

    private Object processNumber(Number lhsNumber, Number rhsNumber) {
        if (lhsNumber instanceof Double) {
            return this.processDouble((Double)lhsNumber, rhsNumber);
        }
        if (lhsNumber instanceof Float) {
            return this.processFloat((Float)lhsNumber, rhsNumber);
        }
        return this.processInteger((Long)lhsNumber, rhsNumber);
    }

    protected Boolean compute(String lhs, String rhs) {
        return false;
    }

    protected Boolean compute(Boolean lhs, Boolean rhs) {
        return false;
    }
}

