/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;

public abstract class Operation {
    public abstract Object evaluate(IdentifierResolver var1) throws ParseException;

    public abstract Object compile();

    protected Object compile(Object test) {
        if (test instanceof Operation) {
            return ((Operation)test).compile();
        }
        return test;
    }

    protected static Object evaluate(Object parameter, IdentifierResolver resolver) throws ParseException {
        if (parameter instanceof Operation) {
            return ((Operation)parameter).evaluate(resolver);
        }
        return parameter;
    }

    protected static Number evaluateToNumber(Object parameter, IdentifierResolver resolver) throws ParseException {
        Object result = Operation.evaluate(parameter, resolver);
        if (result instanceof Number) {
            return (Number)result;
        }
        if (result instanceof String) {
            return Operation.parseStringToNumber((String)result);
        }
        if (result == null) {
            return null;
        }
        return Double.NaN;
    }

    protected static Number parseStringToNumber(String value) {
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

