/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.arithmetic;

import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.ArithmeticOperator;

public class DivideOperator
extends ArithmeticOperator {
    public DivideOperator(Object lhs, Object rhs) throws ParseException {
        super(lhs, rhs);
    }

    @Override
    protected Number compute(double lhs, double rhs) {
        if (rhs == 0.0) {
            return Double.NaN;
        }
        return lhs / rhs;
    }

    @Override
    protected Number compute(double lhs, long rhs) {
        if (rhs == 0L) {
            return Double.NaN;
        }
        return lhs / (double)rhs;
    }

    @Override
    protected Number compute(long lhs, double rhs) {
        if (rhs == 0.0) {
            return Double.NaN;
        }
        return (double)lhs / rhs;
    }

    @Override
    protected Number compute(long lhs, long rhs) {
        if (rhs == 0L) {
            return Double.NaN;
        }
        return lhs / rhs;
    }

    public String toString() {
        return "(" + this.lhs.toString() + ") / (" + this.rhs.toString() + ")";
    }

    public boolean equals(Object test) {
        if (test instanceof DivideOperator) {
            return this.lhs.equals(((DivideOperator)test).lhs) && this.rhs.equals(((DivideOperator)test).rhs);
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() << 2 ^ this.rhs.hashCode() >> 2;
    }
}

