/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.arithmetic;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.Operation;

public class NegateOperator
extends Operation {
    private Object lhs;

    public NegateOperator(Object lhs) throws ParseException {
        if (lhs == null) {
            throw new ParseException("Expected a non null value");
        }
        this.lhs = lhs;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        return this.compute(NegateOperator.evaluate(this.lhs, resolver));
    }

    private Object compute(Object result) {
        if (result instanceof Double) {
            return -1.0 * (Double)result;
        }
        if (result instanceof Float) {
            return -1.0 * (double)((Float)result).floatValue();
        }
        if (result instanceof Number) {
            return -1L * ((Number)result).longValue();
        }
        return result;
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof Operation) {
            this.lhs = ((Operation)this.lhs).compile();
        }
        if (this.lhs instanceof Number) {
            return this.compute(this.lhs);
        }
        return this;
    }

    public boolean equals(Object test) {
        if (test instanceof NegateOperator) {
            return this.lhs.equals(((NegateOperator)test).lhs);
        }
        return false;
    }

    public int hashCode() {
        return ~this.lhs.hashCode();
    }
}

