/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.comparison;

import io.mapsmessaging.selector.Constants;
import io.mapsmessaging.selector.operators.ComparisonOperator;

public class EqualOperator
extends ComparisonOperator {
    public EqualOperator(Object lhs, Object rhs) {
        super(lhs, rhs);
    }

    @Override
    protected Boolean compute(double lhs, double rhs) {
        return Math.abs(lhs - rhs) < Constants.getThreshold() || Double.isNaN(lhs) && Double.isNaN(rhs);
    }

    @Override
    protected Boolean compute(double lhs, long rhs) {
        return lhs == (double)rhs;
    }

    @Override
    protected Boolean compute(long lhs, double rhs) {
        return (double)lhs == rhs;
    }

    @Override
    protected Boolean compute(long lhs, long rhs) {
        return lhs == rhs;
    }

    @Override
    protected Boolean compute(String lhs, String rhs) {
        return lhs.equals(rhs);
    }

    @Override
    protected Boolean compute(Boolean lhs, Boolean rhs) {
        return lhs.equals(rhs);
    }

    public String toString() {
        return "(" + this.lhs.toString() + ") == (" + this.rhs.toString() + ")";
    }

    public boolean equals(Object test) {
        if (test instanceof EqualOperator) {
            return this.lhs.equals(((EqualOperator)test).lhs) && this.rhs.equals(((EqualOperator)test).rhs);
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.rhs.hashCode();
    }
}

