/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.extentions;

import io.mapsmessaging.selector.Identifier;
import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.FunctionOperator;
import io.mapsmessaging.selector.operators.extentions.ParserFactory;
import java.util.List;

public class IdentityLoadParser
extends FunctionOperator {
    private final Identifier parserIdentifier;
    private final List<String> arguments;

    public IdentityLoadParser(Identifier parser, List<String> arguments) {
        this.parserIdentifier = parser;
        this.arguments = arguments;
    }

    @Override
    public Object compile() {
        return this;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        FunctionOperator parser;
        Object parserName = IdentityLoadParser.evaluate(this.parserIdentifier, resolver);
        if (parserName != null && (parser = ParserFactory.getInstance().loadParser(parserName, this.arguments)) != null) {
            return this.convertResult(parser.evaluate(resolver));
        }
        return false;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("Parse (" + this.parserIdentifier + ", ");
        for (String check : this.arguments) {
            tmp.append(check).append(",");
        }
        tmp.append(")");
        return tmp.toString();
    }

    public boolean equals(Object test) {
        if (test instanceof IdentityLoadParser) {
            return this.parserIdentifier.equals(((IdentityLoadParser)test).parserIdentifier) && this.arguments.equals(((IdentityLoadParser)test).arguments);
        }
        return false;
    }

    public int hashCode() {
        return this.parserIdentifier.hashCode() | this.arguments.hashCode();
    }
}

