/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.extentions;

import io.mapsmessaging.selector.Identifier;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.extensions.ParserExtension;
import io.mapsmessaging.selector.operators.FunctionOperator;
import io.mapsmessaging.selector.operators.extentions.IdentityLoadParser;
import io.mapsmessaging.selector.operators.extentions.ParserProxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class ParserFactory {
    private static final ParserFactory instance = new ParserFactory();
    private final ServiceLoader<ParserExtension> knownParsers = ServiceLoader.load(ParserExtension.class);

    public static ParserFactory getInstance() {
        return instance;
    }

    private ParserFactory() {
    }

    public FunctionOperator loadParser(Object parserName, List<String> arguments) throws ParseException {
        for (ParserExtension parser : this.knownParsers) {
            if (parserName instanceof String) {
                if (!parser.getName().equalsIgnoreCase(parserName.toString())) continue;
                return new ParserProxy(parser.createInstance(arguments));
            }
            if (!(parserName instanceof Identifier)) continue;
            return new IdentityLoadParser((Identifier)parserName, arguments);
        }
        return null;
    }

    public Iterator<ParserExtension> getServices() {
        ArrayList<ParserExtension> service = new ArrayList<ParserExtension>();
        for (ParserExtension parser : this.knownParsers) {
            service.add(parser);
        }
        return service.listIterator();
    }
}

