/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.functions;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.ComparisonOperator;
import io.mapsmessaging.selector.operators.FunctionOperator;
import io.mapsmessaging.selector.operators.Operation;
import io.mapsmessaging.selector.operators.comparison.GreaterOrEqualOperator;
import io.mapsmessaging.selector.operators.comparison.LessOrEqualOperator;

public class BetweenOperator
extends FunctionOperator {
    private final Object lhs;
    private final ComparisonOperator bottomOperator;
    private final ComparisonOperator topOperator;

    public BetweenOperator(Object lhs, Object lowest, Object highest) {
        if (lowest instanceof Operation) {
            lowest = ((Operation)lowest).compile();
        }
        if (highest instanceof Operation) {
            highest = ((Operation)highest).compile();
        }
        this.lhs = lhs;
        this.bottomOperator = new GreaterOrEqualOperator(lhs, lowest);
        this.topOperator = new LessOrEqualOperator(lhs, highest);
    }

    @Override
    public Object compile() {
        this.bottomOperator.compile();
        if (this.lhs instanceof Number && this.bottomOperator.getRHS() instanceof Number && this.topOperator.getRHS() instanceof Number) {
            boolean bottom = (Boolean)this.bottomOperator.evaluate(this.lhs, this.bottomOperator.getRHS());
            boolean top = (Boolean)this.topOperator.evaluate(this.lhs, this.topOperator.getRHS());
            return top && bottom;
        }
        return this;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        boolean bottom = (Boolean)this.bottomOperator.evaluate(resolver);
        if (bottom) {
            return this.topOperator.evaluate(resolver);
        }
        return false;
    }

    public String toString() {
        return "(" + this.lhs.toString() + ") BETWEEN (" + this.bottomOperator.getRHS() + " AND " + this.topOperator.getRHS() + ")";
    }

    public boolean equals(Object test) {
        if (test instanceof BetweenOperator) {
            return this.lhs.equals(((BetweenOperator)test).lhs) && this.bottomOperator.equals(((BetweenOperator)test).bottomOperator) && this.topOperator.equals(((BetweenOperator)test).topOperator);
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() | this.bottomOperator.hashCode() ^ this.topOperator.hashCode();
    }
}

