/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.functions;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.FunctionOperator;
import java.util.Set;
import java.util.TreeSet;

public class InOperator
extends FunctionOperator {
    private final Object lhs;
    private final Set<String> set;

    public InOperator(Object lhs, Set<String> entries) {
        this.lhs = lhs;
        this.set = new TreeSet<String>(entries);
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof String) {
            return this.evaluate((String)this.lhs);
        }
        return this;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        Object lookup = InOperator.evaluate(this.lhs, resolver);
        if (lookup != null) {
            if (lookup instanceof String) {
                return this.evaluate((String)lookup);
            }
            return this.evaluate(lookup.toString());
        }
        return false;
    }

    private Object evaluate(String lookup) {
        if (lookup != null) {
            return this.set.contains(lookup);
        }
        return false;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("(" + this.lhs.toString() + ") IN (");
        for (String check : this.set) {
            tmp.append(check).append(",");
        }
        tmp.append(")");
        return tmp.toString();
    }

    public boolean equals(Object test) {
        if (test instanceof InOperator) {
            return this.lhs.equals(((InOperator)test).lhs) && this.set.equals(((InOperator)test).set);
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.set.hashCode();
    }
}

