/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.functions;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.FunctionOperator;

public class LikeOperator
extends FunctionOperator {
    private static final char MULTI_CHARACTER = '%';
    private static final char SINGLE_CHARACTER = '_';
    private static final String MULTI_STRING = String.valueOf('%');
    private final Object lhs;
    private final String searchPattern;
    private final char escape;
    private final boolean hasEscape;

    public LikeOperator(Object lhs, Object rhs) throws ParseException {
        this(lhs, rhs, null);
    }

    public LikeOperator(Object lhs, Object rhs, Object escape) throws ParseException {
        this.lhs = lhs;
        String workingPattern = rhs.toString();
        if (workingPattern.length() > 102400) {
            throw new ParseException("Wildcard pattern exceeds size limit");
        }
        if (escape != null) {
            this.escape = escape.toString().charAt(0);
            this.hasEscape = true;
            workingPattern = this.removeDuplicates(workingPattern, MULTI_STRING + "_");
            workingPattern = this.removeDuplicates(workingPattern, "_" + MULTI_STRING);
            workingPattern = this.removeDuplicates(workingPattern, MULTI_STRING + MULTI_STRING);
        } else {
            workingPattern = this.removeDuplicates(workingPattern, MULTI_STRING + "_");
            workingPattern = this.removeDuplicates(workingPattern, "_" + MULTI_STRING);
            workingPattern = this.removeDuplicates(workingPattern, MULTI_STRING + MULTI_STRING);
            this.escape = (char)92;
            this.hasEscape = false;
        }
        this.searchPattern = workingPattern;
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof String) {
            return this.compare((String)this.lhs, this.searchPattern);
        }
        return this;
    }

    private String removeDuplicates(String source, String pattern) {
        if (this.hasEscape) {
            return this.removeDuplicatesWithEscape(source);
        }
        while (source.contains(pattern)) {
            source = source.replaceAll(pattern, MULTI_STRING);
        }
        return source;
    }

    private String removeDuplicatesWithEscape(String source) {
        for (int position = 0; position < ((String)source).length() - 1; ++position) {
            String end;
            String start;
            if (((String)source).charAt(position) == this.escape) {
                ++position;
                continue;
            }
            if (((String)source).charAt(position) == '%' && (((String)source).charAt(position + 1) == '%' || ((String)source).charAt(position + 1) == '_')) {
                start = ((String)source).substring(0, position + 1);
                end = ((String)source).substring(position + 2);
                source = start + end;
                --position;
                continue;
            }
            if (((String)source).charAt(position) != '_' || ((String)source).charAt(position + 1) != '%') continue;
            start = ((String)source).substring(0, position);
            end = ((String)source).substring(position + 1);
            source = start + end;
            --position;
        }
        return source;
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        Object lookup = LikeOperator.evaluate(this.lhs, resolver);
        if (lookup != null) {
            String sourceString = lookup.toString();
            return this.compare(sourceString, this.searchPattern);
        }
        return false;
    }

    private boolean compare(String sourceString, String wildcard) {
        if (this.hasEscape && wildcard.length() > 0 && wildcard.charAt(0) == this.escape) {
            if ((wildcard = wildcard.substring(1)).charAt(0) != sourceString.charAt(0)) {
                return false;
            }
            return this.compare(sourceString.substring(1), wildcard.substring(1));
        }
        if (wildcard.length() == 0 && sourceString.length() == 0) {
            return true;
        }
        if (wildcard.length() > 1 && wildcard.charAt(0) == '%' && sourceString.length() == 0) {
            return false;
        }
        if (wildcard.length() > 0 && wildcard.charAt(0) == '_' || wildcard.length() > 0 && sourceString.length() > 0 && wildcard.charAt(0) == sourceString.charAt(0)) {
            return this.compare(sourceString.substring(1), wildcard.substring(1));
        }
        if (wildcard.length() > 0 && wildcard.charAt(0) == '%') {
            return this.compare(sourceString, wildcard.substring(1)) || this.compare(sourceString.substring(1), wildcard);
        }
        return false;
    }

    public String toString() {
        if (this.hasEscape) {
            return "(" + this.lhs.toString() + ") LIKE (" + this.searchPattern + ", ESCAPE " + this.escape + ")";
        }
        return "(" + this.lhs.toString() + ") LIKE (" + this.searchPattern + ")";
    }

    protected String getSearchPattern() {
        return this.searchPattern;
    }

    public boolean equals(Object test) {
        if (test instanceof LikeOperator) {
            return this.lhs.equals(((LikeOperator)test).lhs) && this.searchPattern.equals(((LikeOperator)test).searchPattern) && this.escape == ((LikeOperator)test).escape;
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.searchPattern.hashCode() + this.escape;
    }
}

