/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.logical;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.LogicalOperator;
import io.mapsmessaging.selector.operators.Operation;

public class AndOperator
extends LogicalOperator {
    public AndOperator(Object lhs, Object rhs) {
        super(lhs, rhs);
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        Boolean lhsResult = this.test(this.lhs, resolver);
        Boolean rhsResult = this.test(this.rhs, resolver);
        if (lhsResult == null || rhsResult == null) {
            return false;
        }
        return lhsResult != false && rhsResult != false;
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof Operation) {
            this.lhs = ((Operation)this.lhs).compile();
        }
        if (this.rhs instanceof Operation) {
            this.rhs = ((Operation)this.rhs).compile();
        }
        if (this.lhs instanceof Boolean && this.rhs instanceof Boolean) {
            return (Boolean)this.lhs != false && (Boolean)this.rhs != false;
        }
        if (this.rhs instanceof Boolean) {
            if (Boolean.TRUE.equals(this.rhs)) {
                return this.lhs;
            }
            return false;
        }
        return this;
    }

    public String toString() {
        return "(" + this.lhs.toString() + ") AND (" + this.rhs.toString() + ")";
    }

    public boolean equals(Object test) {
        if (test instanceof AndOperator) {
            return this.lhs.equals(((AndOperator)test).lhs) && this.rhs.equals(((AndOperator)test).rhs);
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.rhs.hashCode();
    }
}

