/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.operators.logical;

import io.mapsmessaging.selector.IdentifierResolver;
import io.mapsmessaging.selector.ParseException;
import io.mapsmessaging.selector.operators.LogicalOperator;
import io.mapsmessaging.selector.operators.Operation;

public class OrOperator
extends LogicalOperator {
    public OrOperator(Object lhs, Object rhs) {
        super(lhs, rhs);
    }

    @Override
    public Object evaluate(IdentifierResolver resolver) throws ParseException {
        Boolean lhsResult = this.test(this.lhs, resolver);
        Boolean rhsResult = this.test(this.rhs, resolver);
        if (lhsResult == null && rhsResult == null) {
            return false;
        }
        if (lhsResult == null) {
            return rhsResult;
        }
        if (rhsResult == null) {
            return lhsResult;
        }
        return lhsResult != false || rhsResult != false;
    }

    @Override
    public Object compile() {
        if (this.lhs instanceof Operation) {
            this.lhs = ((Operation)this.lhs).compile();
        }
        if (this.rhs instanceof Operation) {
            this.rhs = ((Operation)this.rhs).compile();
        }
        if (this.lhs instanceof Boolean && this.rhs instanceof Boolean) {
            boolean bLhs = (Boolean)this.lhs;
            boolean bRhs = (Boolean)this.rhs;
            return bLhs || bRhs;
        }
        if (this.lhs instanceof Boolean && Boolean.TRUE.equals(this.lhs)) {
            return this.lhs;
        }
        if (this.rhs instanceof Boolean && Boolean.TRUE.equals(this.rhs)) {
            return this.rhs;
        }
        return this;
    }

    public String toString() {
        return "(" + this.lhs.toString() + ") OR (" + this.rhs.toString() + ")";
    }

    public boolean equals(Object test) {
        if (test instanceof OrOperator) {
            return this.lhs.equals(((OrOperator)test).lhs) && this.rhs.equals(((OrOperator)test).rhs);
        }
        return false;
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.rhs.hashCode();
    }
}

