/*
 * Decompiled with CFR 0.152.
 */
package io.mapsmessaging.selector.resolvers;

import io.mapsmessaging.selector.IdentifierMutator;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class BeanEvaluator
implements IdentifierMutator {
    private static final Map<String, Map<String, Method>> LOADED_GET_MAPPINGS = new ConcurrentHashMap<String, Map<String, Method>>();
    private static final Map<String, Map<String, Method>> LOADED_SET_MAPPINGS = new ConcurrentHashMap<String, Map<String, Method>>();
    private final Object parent;

    public BeanEvaluator(Object bean) {
        this.parent = bean;
    }

    private static Map<String, Method> getMapping(Object bean) {
        if (LOADED_GET_MAPPINGS.containsKey(bean.getClass().getName())) {
            return LOADED_GET_MAPPINGS.get(bean.getClass().getName());
        }
        BeanEvaluator.loadMaps(bean);
        return LOADED_GET_MAPPINGS.get(bean.getClass().getName());
    }

    private static Map<String, Method> setMapping(Object bean) {
        if (LOADED_SET_MAPPINGS.containsKey(bean.getClass().getName())) {
            return LOADED_SET_MAPPINGS.get(bean.getClass().getName());
        }
        BeanEvaluator.loadMaps(bean);
        return LOADED_SET_MAPPINGS.get(bean.getClass().getName());
    }

    private static void loadMaps(Object bean) {
        LinkedHashMap<String, Method> get = new LinkedHashMap<String, Method>();
        LinkedHashMap<String, Method> set = new LinkedHashMap<String, Method>();
        try {
            PropertyDescriptor[] list;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            for (PropertyDescriptor propertyDescriptor : list = beanInfo.getPropertyDescriptors()) {
                Method writeMethod;
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod != null) {
                    get.put(propertyDescriptor.getName(), readMethod);
                }
                if ((writeMethod = propertyDescriptor.getWriteMethod()) == null) continue;
                set.put(propertyDescriptor.getName(), writeMethod);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        LOADED_GET_MAPPINGS.put(bean.getClass().getName(), get);
        LOADED_SET_MAPPINGS.put(bean.getClass().getName(), set);
    }

    @Override
    public Object get(String key) {
        if (key.contains("#")) {
            String[] keyDepth = key.split("#");
            Object bean = this.parent;
            for (String keyWalk : keyDepth) {
                if ((bean = this.lookup(keyWalk, bean)) != null) continue;
                return null;
            }
            return bean;
        }
        return this.lookup(key, this.parent);
    }

    @Override
    public Object remove(String key) {
        return null;
    }

    @Override
    public Object set(String key, Object value) {
        if (key.contains("#")) {
            String[] keyDepth = key.split("#");
            Object bean = this.parent;
            for (String keyWalk : keyDepth) {
                if ((bean = this.lookupAndSet(keyWalk, bean, value)) != null) continue;
                return null;
            }
            return bean;
        }
        return this.lookupAndSet(key, this.parent, value);
    }

    private Object lookup(String key, Object bean) {
        Method method = BeanEvaluator.getMapping(bean).get(key);
        try {
            if (method != null) {
                return method.invoke(bean, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private Object lookupAndSet(String key, Object bean, Object value) {
        Method method = BeanEvaluator.setMapping(bean).get(key);
        try {
            if (method != null) {
                return method.invoke(bean, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

