/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.serial;

import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface MatsTrace<Z> {
    public static final String NULLED = "-nulled-";

    public MatsTrace<Z> withDebugInfo(String var1, String var2, String var3, String var4, String var5);

    public MatsTrace<Z> withChildFlow(String var1, int var2);

    public String getTraceId();

    public String getFlowId();

    public long getInitializedTimestamp();

    public KeepMatsTrace getKeepTrace();

    public boolean isNonPersistent();

    public boolean isInteractive();

    public long getTimeToLive();

    public boolean isNoAudit();

    public String getInitializingAppName();

    public String getInitializingAppVersion();

    public String getInitializingHost();

    public String getInitiatorId();

    public String getDebugInfo();

    public int getCallNumber();

    public int getTotalCallNumber();

    public String getParentMatsMessageId();

    public void setTraceProperty(String var1, Z var2);

    public Z getTraceProperty(String var1);

    public Set<String> getTracePropertyKeys();

    public MatsTrace<Z> addRequestCall(String var1, String var2, Call.MessagingModel var3, String var4, Call.MessagingModel var5, Z var6, Z var7, Z var8);

    public MatsTrace<Z> addSendCall(String var1, String var2, Call.MessagingModel var3, Z var4, Z var5);

    public MatsTrace<Z> addNextCall(String var1, String var2, Z var3, Z var4);

    public MatsTrace<Z> addReplyCall(String var1, Z var2);

    public MatsTrace<Z> addGotoCall(String var1, String var2, Z var3, Z var4);

    public void setOutgoingTimestamp(long var1);

    public long getSameHeightOutgoingTimestamp();

    public void setStageEnteredTimestamp(long var1);

    public long getSameHeightEndpointEnteredTimestamp();

    public long getCurrentSpanId();

    public Call<Z> getCurrentCall();

    public Optional<StackState<Z>> getCurrentState();

    public List<StackState<Z>> getStateStack();

    public List<Call<Z>> getCallFlow();

    public List<StackState<Z>> getStateFlow();

    public static interface StackState<Z> {
        public int getHeight();

        public Z getState();

        public void setExtraState(String var1, Z var2);

        public Z getExtraState(String var1);
    }

    public static interface Call<Z> {
        public long getCalledTimestamp();

        public String getMatsMessageId();

        public Call<Z> setDebugInfo(String var1, String var2, String var3, String var4);

        public String getCallingAppName();

        public String getCallingAppVersion();

        public String getCallingHost();

        public String getDebugInfo();

        public CallType getCallType();

        public long getReplyFromSpanId();

        public String getFrom();

        public Channel getTo();

        public Z getData();

        public int getReplyStackHeight();

        public List<Channel> getReplyStack();

        public static enum MessagingModel {
            QUEUE,
            TOPIC;

        }

        public static interface Channel {
            public String getId();

            public MessagingModel getMessagingModel();
        }

        public static enum CallType {
            REQUEST,
            SEND,
            NEXT,
            REPLY,
            GOTO;

        }
    }

    public static enum KeepMatsTrace {
        FULL,
        COMPACT,
        MINIMAL;

    }
}

