/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.serial;

import io.mats3.serial.MatsTrace;

public interface MatsSerializer<Z> {
    public static final String META_KEY_POSTFIX = ":meta";

    default public boolean handlesMeta(String meta) {
        return false;
    }

    public MatsTrace<Z> createNewMatsTrace(String var1, String var2, MatsTrace.KeepMatsTrace var3, boolean var4, boolean var5, long var6, boolean var8);

    public SerializedMatsTrace serializeMatsTrace(MatsTrace<Z> var1);

    public DeserializedMatsTrace<Z> deserializeMatsTrace(byte[] var1, int var2, int var3, String var4);

    public DeserializedMatsTrace<Z> deserializeMatsTrace(byte[] var1, String var2);

    public Z serializeObject(Object var1);

    public int sizeOfSerialized(Z var1);

    public <T> T deserializeObject(Z var1, Class<T> var2);

    public <T> T newInstance(Class<T> var1);

    public static class SerializationException
    extends RuntimeException {
        public SerializationException(String message) {
            super(message);
        }

        public SerializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface DeserializedMatsTrace<Z> {
        public MatsTrace<Z> getMatsTrace();

        public int getSizeIncoming();

        public int getSizeDecompressed();

        public long getNanosDecompression();

        public long getNanosDeserialization();
    }

    public static interface SerializedMatsTrace {
        public byte[] getMatsTraceBytes();

        public String getMeta();

        public int getSizeUncompressed();

        public long getNanosSerialization();

        default public int getSizeCompressed() {
            return this.getMatsTraceBytes().length;
        }

        public long getNanosCompression();
    }
}

