/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.base32;

import io.matthewnelson.encoding.base32.Base32;
import io.matthewnelson.encoding.base32.Base32CrockfordConfigBuilder;
import io.matthewnelson.encoding.base32.Base32DefaultConfigBuilder;
import io.matthewnelson.encoding.base32.Base32HexConfigBuilder;
import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import io.matthewnelson.encoding.core.EncoderDecoder;
import io.matthewnelson.encoding.core.EncodingException;
import io.matthewnelson.encoding.core.util.DecoderInput;
import io.matthewnelson.encoding.core.util.FeedBuffer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005\u0006\u0007\b\t\nB\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lio/matthewnelson/encoding/base32/Base32;", "C", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "config", "(Lio/matthewnelson/encoding/core/EncoderDecoder$Config;)V", "Crockford", "DecodingBuffer", "Default", "EncodingBuffer", "Hex", "Lio/matthewnelson/encoding/base32/Base32$Crockford;", "Lio/matthewnelson/encoding/base32/Base32$Default;", "Lio/matthewnelson/encoding/base32/Base32$Hex;", "base32"})
public abstract class Base32<C extends EncoderDecoder.Config>
extends EncoderDecoder<C> {
    private Base32(C config) {
        super(config);
    }

    public /* synthetic */ Base32(EncoderDecoder.Config config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\f0\bR\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\f0\rR\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford;", "Lio/matthewnelson/encoding/base32/Base32;", "Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "config", "(Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;)V", "name", "", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "Companion", "Config", "base32"})
    public static final class Crockford
    extends Base32<Config> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CHARS_UPPER = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
        @NotNull
        public static final String CHARS_LOWER = "0123456789abcdefghjkmnpqrstvwxyz";
        @NotNull
        private static final Crockford DELEGATE = new Crockford((Config)Companion.getConfig());

        public Crockford(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, null);
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Decoder.Feed(this, out){
                @NotNull
                private final DecodingBuffer buffer;
                private boolean isCheckSymbolSet;
                {
                    this.buffer = $receiver.new DecodingBuffer($out);
                }

                protected void consumeProtected(char input) throws EncodingException {
                    int n;
                    if (this.isCheckSymbolSet) {
                        throw new EncodingException("Checksymbol[" + ((Config)this.getConfig()).checkSymbol + "] was set, but decoding is still being attempted.");
                    }
                    char c = input;
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        n = input - 48;
                    } else {
                        boolean bl2 = 'a' <= c ? c < 'i' : false;
                        if (bl2) {
                            n = Character.toUpperCase(input) - 55;
                        } else {
                            boolean bl3 = 'A' <= c ? c < 'I' : false;
                            if (bl3) {
                                n = input - 55;
                            } else if (((c == 'I' ? true : c == 'i') ? true : c == 'L') ? true : c == 'l') {
                                n = 1;
                            } else if (c == 'j' ? true : c == 'k') {
                                n = Character.toUpperCase(input) - 56;
                            } else if (c == 'J' ? true : c == 'K') {
                                n = input - 56;
                            } else if (c == 'm' ? true : c == 'n') {
                                n = Character.toUpperCase(input) - 57;
                            } else if (c == 'M' ? true : c == 'N') {
                                n = input - 57;
                            } else if (c == 'O' ? true : c == 'o') {
                                n = 0;
                            } else {
                                boolean bl4 = 'p' <= c ? c < 'u' : false;
                                if (bl4) {
                                    n = Character.toUpperCase(input) - 58;
                                } else {
                                    boolean bl5 = 'P' <= c ? c < 'U' : false;
                                    if (bl5) {
                                        n = input - 58;
                                    } else {
                                        boolean bl6 = 'v' <= c ? c < '{' : false;
                                        if (bl6) {
                                            n = Character.toUpperCase(input) - 59;
                                        } else {
                                            boolean bl7 = 'V' <= c ? c < '[' : false;
                                            if (bl7) {
                                                n = input - 59;
                                            } else {
                                                if (c == '-') {
                                                    return;
                                                }
                                                char $this$isCheckSymbol$iv = input;
                                                boolean $i$f$isCheckSymbol = false;
                                                char c2 = $this$isCheckSymbol$iv;
                                                boolean bl8 = ((((c2 == '*' ? true : c2 == '~') ? true : c2 == '$') ? true : c2 == '=') ? true : c2 == 'U') ? true : c2 == 'u';
                                                if (bl8) {
                                                    Character checkSymbol;
                                                    Character c3 = ((Config)this.getConfig()).checkSymbol;
                                                    Character c4 = checkSymbol = c3 != null ? Character.valueOf(Character.toUpperCase(c3.charValue())) : null;
                                                    char c5 = Character.toUpperCase(input);
                                                    if (c4 != null && c4.charValue() == c5) {
                                                        this.isCheckSymbolSet = true;
                                                        return;
                                                    }
                                                    throw new EncodingException("Char[" + input + "] IS a checkSymbol, but did not match config's Checksymbol[" + checkSymbol + ']');
                                                }
                                                throw new EncodingException("Char[" + input + "] is not a valid Base32 Crockford character");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    int bits = n;
                    this.buffer.update(bits);
                }

                protected void doFinalProtected() throws EncodingException {
                    this.buffer.finalize();
                    this.isCheckSymbolSet = false;
                }
            };
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Encoder.Feed(this, out){
                private byte outCount;
                private boolean outputHyphenOnNext;
                @NotNull
                private final EncodingBuffer buffer;
                final /* synthetic */ Encoder.OutFeed $out;
                {
                    this.$out = $out;
                    super((Encoder)$receiver);
                    this.buffer = $receiver.new EncodingBuffer(arg_0 -> newEncoderFeedProtected.1.buffer$lambda$0(this, $out, arg_0), ((Config)this.getConfig()).encodeToLowercase ? "0123456789abcdefghjkmnpqrstvwxyz" : "0123456789ABCDEFGHJKMNPQRSTVWXYZ", null);
                }

                protected void consumeProtected(byte input) {
                    this.buffer.update(input);
                }

                protected void doFinalProtected() {
                    this.buffer.finalize();
                    if (((Config)this.getConfig()).finalizeWhenFlushed || this.isClosed()) {
                        Character c = ((Config)this.getConfig()).checkSymbol;
                        if (c != null) {
                            Character c2 = c;
                            Encoder.OutFeed outFeed = this.$out;
                            char symbol = c2.charValue();
                            boolean bl = false;
                            if (this.outputHyphenOnNext) {
                                outFeed.output('-');
                            }
                            if (((Config)this.getConfig()).encodeToLowercase) {
                                outFeed.output(Character.toLowerCase(symbol));
                            } else {
                                outFeed.output(Character.toUpperCase(symbol));
                            }
                        }
                        this.outCount = 0;
                        this.outputHyphenOnNext = false;
                    }
                }

                /*
                 * Unable to fully structure code
                 */
                private static final void buffer$lambda$0(newEncoderFeedProtected.1 this$0, Encoder.OutFeed $out, char byte) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$out, (String)"$out");
                    if (this$0.outputHyphenOnNext) {
                        $out.output('-');
                        this$0.outCount = 0;
                        this$0.outputHyphenOnNext = false;
                    }
                    $out.output(byte);
                    if (((Config)this$0.getConfig()).hyphenInterval <= 0) ** GOTO lbl-1000
                    this$0.outCount = (byte)(this$0.outCount + 1);
                    if (this$0.outCount == ((Config)this$0.getConfig()).hyphenInterval) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    this$0.outputHyphenOnNext = v0;
                }
            };
        }

        @NotNull
        protected String name() {
            return "Base32.Crockford";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0014J\u001a\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\f0\u0010R\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "()V", "CHARS_LOWER", "", "CHARS_UPPER", "DELEGATE", "Lio/matthewnelson/encoding/base32/Base32$Crockford;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "base32"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Crockford$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,969:1\n1#2:970\n*E\n"})
        public static final class Companion
        extends EncoderDecoder<Config> {
            private Companion() {
                Base32CrockfordConfigBuilder base32CrockfordConfigBuilder;
                Base32CrockfordConfigBuilder base32CrockfordConfigBuilder2 = base32CrockfordConfigBuilder = new Base32CrockfordConfigBuilder();
                Companion companion = this;
                boolean bl = false;
                $this$_init__u24lambda_u240.hyphenInterval = (byte)4;
                super((EncoderDecoder.Config)base32CrockfordConfigBuilder.build());
            }

            @NotNull
            protected String name() {
                return DELEGATE.name();
            }

            @NotNull
            protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newDecoderFeedProtected(out);
            }

            @NotNull
            protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newEncoderFeedProtected(out);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\u0012\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0017R\u00020\u00010\u0016H\u0014R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "encodeToLowercase", "hyphenInterval", "", "checkSymbol", "", "finalizeWhenFlushed", "(ZZBLjava/lang/Character;Z)V", "Ljava/lang/Character;", "decodeOutMaxSizeOrFailProtected", "", "encodedSize", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "decodeOutMaxSizeProtected", "", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "Companion", "base32"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Crockford$Config\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n+ 3 -Helpers.kt\nio/matthewnelson/encoding/base32/internal/_HelpersKt\n*L\n1#1,969:1\n21#2:970\n21#2:977\n25#2,12:978\n22#3,3:971\n22#3,3:974\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Crockford$Config\n*L\n101#1:970\n144#1:977\n148#1:978,12\n119#1:971,3\n135#1:974,3\n*E\n"})
        public static final class Config
        extends EncoderDecoder.Config {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @JvmField
            public final boolean encodeToLowercase;
            @JvmField
            public final byte hyphenInterval;
            @JvmField
            @Nullable
            public final Character checkSymbol;
            @JvmField
            public final boolean finalizeWhenFlushed;

            private Config(boolean isLenient, boolean encodeToLowercase, byte hyphenInterval, Character checkSymbol, boolean finalizeWhenFlushed) {
                super(Boolean.valueOf(isLenient), (byte)0, null);
                this.encodeToLowercase = encodeToLowercase;
                this.hyphenInterval = hyphenInterval;
                this.checkSymbol = checkSymbol;
                this.finalizeWhenFlushed = finalizeWhenFlushed;
            }

            protected long decodeOutMaxSizeProtected(long encodedSize) {
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return $this$decodeOutMaxSize$iv * 5L / 8L;
            }

            protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) throws EncodingException {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                int outSize = encodedSize;
                char actual = input.get(encodedSize - 1);
                if (this.checkSymbol != null) {
                    char expectedUpper = Character.toUpperCase(this.checkSymbol.charValue());
                    char actualUpper = Character.toUpperCase(actual);
                    if (actualUpper != expectedUpper) {
                        char $this$isCheckSymbol$iv2 = actual;
                        boolean $i$f$isCheckSymbol = false;
                        char c = $this$isCheckSymbol$iv2;
                        boolean bl = ((((c == '*' ? true : c == '~') ? true : c == '$') ? true : c == '=') ? true : c == 'U') ? true : c == 'u';
                        if (bl) {
                            throw new EncodingException("Check symbol did not match. Expected[" + expectedUpper + "], Actual[" + actual + ']');
                        }
                        throw new EncodingException("Check symbol not found. Expected[" + expectedUpper + ']');
                    }
                    --outSize;
                } else {
                    char $this$isCheckSymbol$iv = actual;
                    boolean $i$f$isCheckSymbol = false;
                    char $this$isCheckSymbol$iv2 = $this$isCheckSymbol$iv;
                    boolean bl = (((($this$isCheckSymbol$iv2 == '*' ? true : $this$isCheckSymbol$iv2 == '~') ? true : $this$isCheckSymbol$iv2 == '$') ? true : $this$isCheckSymbol$iv2 == '=') ? true : $this$isCheckSymbol$iv2 == 'U') ? true : $this$isCheckSymbol$iv2 == 'u';
                    if (bl) {
                        throw new EncodingException("Decoder Misconfiguration.\nEncoded data had Checksymbol[" + actual + "], but the decoder is configured to reject.");
                    }
                }
                long $this$decodeOutMaxSize$iv = outSize;
                boolean $i$f$decodeOutMaxSize = false;
                return (int)($this$decodeOutMaxSize$iv * 5L / 8L);
            }

            /*
             * WARNING - void declaration
             */
            protected long encodeOutSizeProtected(long unEncodedSize) {
                float hyphenCount;
                void $this$encodeOutSize$iv;
                long l = unEncodedSize;
                boolean willBePadded$iv = false;
                boolean $i$f$encodeOutSize = false;
                void outSize$iv = ($this$encodeOutSize$iv + 4L) / 5L * 8L;
                void var11_7 = $this$encodeOutSize$iv - ($this$encodeOutSize$iv - $this$encodeOutSize$iv % (long)5);
                if (var11_7 != 0L) {
                    if (var11_7 == 1L) {
                        outSize$iv -= 6L;
                    } else if (var11_7 == 2L) {
                        outSize$iv -= 4L;
                    } else if (var11_7 == 3L) {
                        outSize$iv -= 3L;
                    } else if (var11_7 == 4L) {
                        --outSize$iv;
                    }
                }
                void outSize = outSize$iv;
                if (this.checkSymbol != null) {
                    $this$encodeOutSize$iv = outSize;
                    outSize = $this$encodeOutSize$iv + 1L;
                }
                if (this.hyphenInterval > 0 && (hyphenCount = (float)outSize / (float)this.hyphenInterval - 1.0f) > 0.0f) {
                    outSize += (long)hyphenCount;
                    if (hyphenCount % 1.0f > 0.0f) {
                        void var6_9 = outSize;
                        outSize = var6_9 + 1L;
                    }
                }
                return (long)outSize;
            }

            @NotNull
            protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
                Set set;
                Set $this$toStringAddSettings_u24lambda_u240 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "hyphenInterval", (Object)this.hyphenInterval));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "checkSymbol", (Object)this.checkSymbol));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "finalizeWhenFlushed", (Object)this.finalizeWhenFlushed));
                return SetsKt.build((Set)set);
            }

            public /* synthetic */ Config(boolean isLenient, boolean encodeToLowercase, byte hyphenInterval, Character checkSymbol, boolean finalizeWhenFlushed, DefaultConstructorMarker $constructor_marker) {
                this(isLenient, encodeToLowercase, hyphenInterval, checkSymbol, finalizeWhenFlushed);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford$Config$Companion;", "", "()V", "from", "Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "builder", "Lio/matthewnelson/encoding/base32/Base32CrockfordConfigBuilder;", "from$base32", "base32"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ Config from$base32(Base32CrockfordConfigBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    return new Config(builder.isLenient, builder.encodeToLowercase, builder.hyphenInterval > 0 ? builder.hyphenInterval : (byte)0, builder.checkSymbol(), builder.finalizeWhenFlushed, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/matthewnelson/encoding/base32/Base32$DecodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "(Lio/matthewnelson/encoding/base32/Base32;Lio/matthewnelson/encoding/core/Decoder$OutFeed;)V", "base32"})
    private final class DecodingBuffer
    extends FeedBuffer {
        public DecodingBuffer(Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super(8, arg_0 -> DecodingBuffer._init_$lambda$0(out, arg_0), (arg_0, arg_1) -> DecodingBuffer._init_$lambda$1(out, arg_0, arg_1));
        }

        private static final void _init_$lambda$0(Decoder.OutFeed $out, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)$out, (String)"$out");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long bitBuffer = 0L;
            for (int bits : buffer) {
                bitBuffer = bitBuffer << 5 | (long)bits;
            }
            $out.output((byte)(bitBuffer >> 32));
            $out.output((byte)(bitBuffer >> 24));
            $out.output((byte)(bitBuffer >> 16));
            $out.output((byte)(bitBuffer >> 8));
            $out.output((byte)bitBuffer);
        }

        private static final void _init_$lambda$1(Decoder.OutFeed $out, int modulus, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)$out, (String)"$out");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            switch (modulus) {
                case 1: 
                case 3: 
                case 6: {
                    throw FeedBuffer.Companion.truncatedInputEncodingException(modulus);
                }
            }
            long bitBuffer = 0L;
            for (int i = 0; i < modulus; ++i) {
                bitBuffer = bitBuffer << 5 | (long)buffer[i];
            }
            switch (modulus) {
                case 0: {
                    break;
                }
                case 2: {
                    $out.output((byte)(bitBuffer >>= 2));
                    break;
                }
                case 4: {
                    $out.output((byte)((bitBuffer >>= 4) >> 8));
                    $out.output((byte)bitBuffer);
                    break;
                }
                case 5: {
                    $out.output((byte)((bitBuffer >>= 1) >> 16));
                    $out.output((byte)(bitBuffer >> 8));
                    $out.output((byte)bitBuffer);
                    break;
                }
                case 7: {
                    $out.output((byte)((bitBuffer >>= 3) >> 24));
                    $out.output((byte)(bitBuffer >> 16));
                    $out.output((byte)(bitBuffer >> 8));
                    $out.output((byte)bitBuffer);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\f0\bR\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\f0\rR\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default;", "Lio/matthewnelson/encoding/base32/Base32;", "Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "config", "(Lio/matthewnelson/encoding/base32/Base32$Default$Config;)V", "name", "", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "Companion", "Config", "base32"})
    public static final class Default
    extends Base32<Config> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CHARS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
        @NotNull
        public static final String CHARS_LOWER = "abcdefghijklmnopqrstuvwxyz234567";
        @NotNull
        private static final Default DELEGATE = new Default((Config)Companion.getConfig());

        public Default(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, null);
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Decoder.Feed(this, out){
                @NotNull
                private final DecodingBuffer buffer;
                {
                    this.buffer = $receiver.new DecodingBuffer($out);
                }

                protected void consumeProtected(char input) throws EncodingException {
                    int n;
                    char c = input;
                    boolean bl = '2' <= c ? c < '8' : false;
                    if (bl) {
                        n = input - 24;
                    } else {
                        boolean bl2 = 'a' <= c ? c < '{' : false;
                        if (bl2) {
                            n = Character.toUpperCase(input) - 65;
                        } else {
                            boolean bl3 = 'A' <= c ? c < '[' : false;
                            if (bl3) {
                                n = input - 65;
                            } else {
                                throw new EncodingException("Char[" + input + "] is not a valid Base32 Default character");
                            }
                        }
                    }
                    int bits = n;
                    this.buffer.update(bits);
                }

                protected void doFinalProtected() throws EncodingException {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Encoder.Feed(this, out){
                @NotNull
                private final EncodingBuffer buffer;
                {
                    this.buffer = $receiver.new EncodingBuffer($out, ((Config)this.getConfig()).encodeToLowercase ? "abcdefghijklmnopqrstuvwxyz234567" : "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", ((Config)this.getConfig()).padEncoded ? ((Config)this.getConfig()).paddingChar : null);
                }

                protected void consumeProtected(byte input) {
                    this.buffer.update(input);
                }

                protected void doFinalProtected() {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected String name() {
            return "Base32.Default";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0014J\u001a\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\f0\u0010R\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "()V", "CHARS_LOWER", "", "CHARS_UPPER", "DELEGATE", "Lio/matthewnelson/encoding/base32/Base32$Default;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "base32"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Default$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,969:1\n1#2:970\n*E\n"})
        public static final class Companion
        extends EncoderDecoder<Config> {
            private Companion() {
                Base32DefaultConfigBuilder base32DefaultConfigBuilder;
                Base32DefaultConfigBuilder base32DefaultConfigBuilder2 = base32DefaultConfigBuilder = new Base32DefaultConfigBuilder();
                Companion companion = this;
                boolean bl = false;
                $this$_init__u24lambda_u240.lineBreakInterval = (byte)64;
                super((EncoderDecoder.Config)base32DefaultConfigBuilder.build());
            }

            @NotNull
            protected String name() {
                return DELEGATE.name();
            }

            @NotNull
            protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newDecoderFeedProtected(out);
            }

            @NotNull
            protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newEncoderFeedProtected(out);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00010\u0013H\u0014R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "lineBreakInterval", "", "encodeToLowercase", "padEncoded", "(ZBZZ)V", "decodeOutMaxSizeOrFailProtected", "", "encodedSize", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "decodeOutMaxSizeProtected", "", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "Companion", "base32"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Default$Config\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n*L\n1#1,969:1\n21#2:970\n21#2:971\n25#2,12:972\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Default$Config\n*L\n481#1:970\n485#1:971\n489#1:972,12\n*E\n"})
        public static final class Config
        extends EncoderDecoder.Config {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @JvmField
            public final boolean encodeToLowercase;
            @JvmField
            public final boolean padEncoded;

            private Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded) {
                super(Boolean.valueOf(isLenient), lineBreakInterval, Character.valueOf('='));
                this.encodeToLowercase = encodeToLowercase;
                this.padEncoded = padEncoded;
            }

            protected long decodeOutMaxSizeProtected(long encodedSize) {
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return $this$decodeOutMaxSize$iv * 5L / 8L;
            }

            protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return (int)($this$decodeOutMaxSize$iv * 5L / 8L);
            }

            /*
             * WARNING - void declaration
             */
            protected long encodeOutSizeProtected(long unEncodedSize) {
                void v0;
                void $this$encodeOutSize$iv;
                long l = unEncodedSize;
                boolean willBePadded$iv = this.padEncoded;
                boolean $i$f$encodeOutSize = false;
                void outSize$iv = ($this$encodeOutSize$iv + 4L) / 5L * 8L;
                if (willBePadded$iv) {
                    v0 = outSize$iv;
                } else {
                    void var9_6 = $this$encodeOutSize$iv - ($this$encodeOutSize$iv - $this$encodeOutSize$iv % (long)5);
                    if (var9_6 != 0L) {
                        if (var9_6 == 1L) {
                            outSize$iv -= 6L;
                        } else if (var9_6 == 2L) {
                            outSize$iv -= 4L;
                        } else if (var9_6 == 3L) {
                            outSize$iv -= 3L;
                        } else if (var9_6 == 4L) {
                            // empty if block
                        }
                    }
                    v0 = --outSize$iv;
                }
                return (long)v0;
            }

            @NotNull
            protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
                Set set;
                Set $this$toStringAddSettings_u24lambda_u240 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "padEncoded", (Object)this.padEncoded));
                return SetsKt.build((Set)set);
            }

            public /* synthetic */ Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded, DefaultConstructorMarker $constructor_marker) {
                this(isLenient, lineBreakInterval, encodeToLowercase, padEncoded);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default$Config$Companion;", "", "()V", "from", "Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "builder", "Lio/matthewnelson/encoding/base32/Base32DefaultConfigBuilder;", "from$base32", "base32"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ Config from$base32(Base32DefaultConfigBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    return new Config(builder.isLenient, builder.lineBreakInterval, builder.encodeToLowercase, builder.padEncoded, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lio/matthewnelson/encoding/base32/Base32$EncodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "table", "", "paddingChar", "", "(Lio/matthewnelson/encoding/base32/Base32;Lio/matthewnelson/encoding/core/Encoder$OutFeed;Ljava/lang/CharSequence;Ljava/lang/Character;)V", "base32"})
    @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$EncodingBuffer\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n*L\n1#1,969:1\n40#2:970\n40#2:971\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$EncodingBuffer\n*L\n828#1:970\n847#1:971\n*E\n"})
    private final class EncodingBuffer
    extends FeedBuffer {
        public EncodingBuffer(@NotNull Encoder.OutFeed out, @Nullable CharSequence table, Character paddingChar) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super(5, arg_0 -> EncodingBuffer._init_$lambda$0(out, table, arg_0), (arg_0, arg_1) -> EncodingBuffer._init_$lambda$2(out, table, paddingChar, arg_0, arg_1));
        }

        private static final void _init_$lambda$0(Encoder.OutFeed $out, CharSequence $table, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)$out, (String)"$out");
            Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long bitBuffer = 0L;
            for (int bits : buffer) {
                byte $this$toBits$iv = (byte)bits;
                boolean $i$f$toBits = false;
                bitBuffer = (bitBuffer << 8) + ($this$toBits$iv < 0 ? (long)$this$toBits$iv + 256L : (long)$this$toBits$iv);
            }
            $out.output($table.charAt((int)(bitBuffer >> 35 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer >> 30 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer >> 25 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer >> 20 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer >> 15 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer >> 10 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer >> 5 & 0x1FL)));
            $out.output($table.charAt((int)(bitBuffer & 0x1FL)));
        }

        private static final void _init_$lambda$2(Encoder.OutFeed $out, CharSequence $table, Character $paddingChar, int modulus, int[] buffer) {
            int padCount;
            Intrinsics.checkNotNullParameter((Object)$out, (String)"$out");
            Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long bitBuffer = 0L;
            for (int i = 0; i < modulus; ++i) {
                byte $this$toBits$iv = (byte)buffer[i];
                boolean $i$f$toBits = false;
                bitBuffer = (bitBuffer << 8) + ($this$toBits$iv < 0 ? (long)$this$toBits$iv + 256L : (long)$this$toBits$iv);
            }
            switch (modulus) {
                case 0: {
                    int n = 0;
                    break;
                }
                case 1: {
                    $out.output($table.charAt((int)(bitBuffer >> 3 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer << 2 & 0x1FL)));
                    int n = 6;
                    break;
                }
                case 2: {
                    $out.output($table.charAt((int)(bitBuffer >> 11 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 6 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 1 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer << 4 & 0x1FL)));
                    int n = 4;
                    break;
                }
                case 3: {
                    $out.output($table.charAt((int)(bitBuffer >> 19 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 14 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 9 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 4 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer << 1 & 0x1FL)));
                    int n = 3;
                    break;
                }
                default: {
                    $out.output($table.charAt((int)(bitBuffer >> 27 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 22 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 17 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 12 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 7 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer >> 2 & 0x1FL)));
                    $out.output($table.charAt((int)(bitBuffer << 3 & 0x1FL)));
                    int n = padCount = 1;
                }
            }
            if ($paddingChar != null) {
                int n = 0;
                while (n < padCount) {
                    int it = n++;
                    boolean bl = false;
                    $out.output($paddingChar.charValue());
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u001a\u0010\u0007\u001a\f0\bR\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\f0\rR\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex;", "Lio/matthewnelson/encoding/base32/Base32;", "Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "config", "(Lio/matthewnelson/encoding/base32/Base32$Hex$Config;)V", "name", "", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "Companion", "Config", "base32"})
    public static final class Hex
    extends Base32<Config> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CHARS_UPPER = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
        @NotNull
        public static final String CHARS_LOWER = "0123456789abcdefghijklmnopqrstuv";
        @NotNull
        private static final Hex DELEGATE = new Hex((Config)Companion.getConfig());

        public Hex(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, null);
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Decoder.Feed(this, out){
                @NotNull
                private final DecodingBuffer buffer;
                {
                    this.buffer = $receiver.new DecodingBuffer($out);
                }

                protected void consumeProtected(char input) throws EncodingException {
                    int n;
                    char c = input;
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        n = input - 48;
                    } else {
                        boolean bl2 = 'a' <= c ? c < 'w' : false;
                        if (bl2) {
                            n = Character.toUpperCase(input) - 55;
                        } else {
                            boolean bl3 = 'A' <= c ? c < 'W' : false;
                            if (bl3) {
                                n = input - 55;
                            } else {
                                throw new EncodingException("Char[" + input + "] is not a valid Base32 Hex character");
                            }
                        }
                    }
                    int bits = n;
                    this.buffer.update(bits);
                }

                protected void doFinalProtected() throws EncodingException {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Encoder.Feed(this, out){
                @NotNull
                private final EncodingBuffer buffer;
                {
                    this.buffer = $receiver.new EncodingBuffer($out, ((Config)this.getConfig()).encodeToLowercase ? "0123456789abcdefghijklmnopqrstuv" : "0123456789ABCDEFGHIJKLMNOPQRSTUV", ((Config)this.getConfig()).padEncoded ? ((Config)this.getConfig()).paddingChar : null);
                }

                protected void consumeProtected(byte input) {
                    this.buffer.update(input);
                }

                protected void doFinalProtected() {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected String name() {
            return "Base32.Hex";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0014J\u001a\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\f0\u0010R\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "()V", "CHARS_LOWER", "", "CHARS_UPPER", "DELEGATE", "Lio/matthewnelson/encoding/base32/Base32$Hex;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "base32"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Hex$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,969:1\n1#2:970\n*E\n"})
        public static final class Companion
        extends EncoderDecoder<Config> {
            private Companion() {
                Base32HexConfigBuilder base32HexConfigBuilder;
                Base32HexConfigBuilder base32HexConfigBuilder2 = base32HexConfigBuilder = new Base32HexConfigBuilder();
                Companion companion = this;
                boolean bl = false;
                $this$_init__u24lambda_u240.lineBreakInterval = (byte)64;
                super((EncoderDecoder.Config)base32HexConfigBuilder.build());
            }

            @NotNull
            protected String name() {
                return DELEGATE.name();
            }

            @NotNull
            protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newDecoderFeedProtected(out);
            }

            @NotNull
            protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newEncoderFeedProtected(out);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00010\u0013H\u0014R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "lineBreakInterval", "", "encodeToLowercase", "padEncoded", "(ZBZZ)V", "decodeOutMaxSizeOrFailProtected", "", "encodedSize", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "decodeOutMaxSizeProtected", "", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "Companion", "base32"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Hex$Config\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n*L\n1#1,969:1\n21#2:970\n21#2:971\n25#2,12:972\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Hex$Config\n*L\n677#1:970\n681#1:971\n685#1:972,12\n*E\n"})
        public static final class Config
        extends EncoderDecoder.Config {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @JvmField
            public final boolean encodeToLowercase;
            @JvmField
            public final boolean padEncoded;

            private Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded) {
                super(Boolean.valueOf(isLenient), lineBreakInterval, Character.valueOf('='));
                this.encodeToLowercase = encodeToLowercase;
                this.padEncoded = padEncoded;
            }

            protected long decodeOutMaxSizeProtected(long encodedSize) {
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return $this$decodeOutMaxSize$iv * 5L / 8L;
            }

            protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return (int)($this$decodeOutMaxSize$iv * 5L / 8L);
            }

            /*
             * WARNING - void declaration
             */
            protected long encodeOutSizeProtected(long unEncodedSize) {
                void v0;
                void $this$encodeOutSize$iv;
                long l = unEncodedSize;
                boolean willBePadded$iv = this.padEncoded;
                boolean $i$f$encodeOutSize = false;
                void outSize$iv = ($this$encodeOutSize$iv + 4L) / 5L * 8L;
                if (willBePadded$iv) {
                    v0 = outSize$iv;
                } else {
                    void var9_6 = $this$encodeOutSize$iv - ($this$encodeOutSize$iv - $this$encodeOutSize$iv % (long)5);
                    if (var9_6 != 0L) {
                        if (var9_6 == 1L) {
                            outSize$iv -= 6L;
                        } else if (var9_6 == 2L) {
                            outSize$iv -= 4L;
                        } else if (var9_6 == 3L) {
                            outSize$iv -= 3L;
                        } else if (var9_6 == 4L) {
                            // empty if block
                        }
                    }
                    v0 = --outSize$iv;
                }
                return (long)v0;
            }

            @NotNull
            protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
                Set set;
                Set $this$toStringAddSettings_u24lambda_u240 = set = SetsKt.createSetBuilder();
                boolean bl = false;
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "padEncoded", (Object)this.padEncoded));
                return SetsKt.build((Set)set);
            }

            public /* synthetic */ Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded, DefaultConstructorMarker $constructor_marker) {
                this(isLenient, lineBreakInterval, encodeToLowercase, padEncoded);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex$Config$Companion;", "", "()V", "from", "Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "builder", "Lio/matthewnelson/encoding/base32/Base32HexConfigBuilder;", "from$base32", "base32"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ Config from$base32(Base32HexConfigBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    return new Config(builder.isLenient, builder.lineBreakInterval, builder.encodeToLowercase, builder.padEncoded, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

