/*
 * Copyright (c) 2024 Matthew Nelson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
@file:Suppress("EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING")

package io.matthewnelson.kmp.process.internal.spawn

internal expect class GnuLibcVersion {

    internal fun isAtLeast(
        major: UByte,
        minor: UByte,
    ): Boolean

    internal companion object {

        // Throws if gnu_get_libc_version returned null on Linux.
        // Is a no-op if not Linux
        @Throws(NullPointerException::class)
        internal fun check(block: GnuLibcVersion.() -> Unit)
    }
}
