/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.common.core;

import io.matthewnelson.immutable.collections.Immutable;
import io.matthewnelson.kmp.file.Exceptions;
import io.matthewnelson.kmp.file.KmpFile;
import io.matthewnelson.kmp.tor.common.api.InternalKmpTorApi;
import io.matthewnelson.kmp.tor.common.api.KmpTorDsl;
import io.matthewnelson.kmp.tor.common.core.PlatformResource;
import io.matthewnelson.kmp.tor.common.core.internal._JvmPlatformKt;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/matthewnelson/kmp/tor/common/core/Resource;", "", "alias", "", "isExecutable", "", "platform", "Lio/matthewnelson/kmp/tor/common/core/PlatformResource;", "(Ljava/lang/String;ZLio/matthewnelson/kmp/tor/common/core/PlatformResource;)V", "equals", "other", "hashCode", "", "toString", "Builder", "Config", "io.matthewnelson.kmp-tor_common-core_jvm"})
@InternalKmpTorApi
@SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\nio/matthewnelson/kmp/tor/common/core/Resource\n+ 2 -CommonPlatform.kt\nio/matthewnelson/kmp/tor/common/core/internal/_CommonPlatformKt\n*L\n1#1,252:1\n25#2,4:253\n25#2,4:257\n25#2,4:261\n25#2,4:265\n25#2,4:269\n*S KotlinDebug\n*F\n+ 1 Resource.kt\nio/matthewnelson/kmp/tor/common/core/Resource\n*L\n233#1:253,4\n235#1:257,4\n237#1:261,4\n242#1:265,4\n245#1:269,4\n*E\n"})
public final class Resource {
    @JvmField
    @NotNull
    public final String alias;
    @JvmField
    public final boolean isExecutable;
    @JvmField
    @NotNull
    public final PlatformResource platform;

    private Resource(String alias, boolean isExecutable, PlatformResource platform) {
        this.alias = alias;
        this.isExecutable = isExecutable;
        this.platform = platform;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Resource && Intrinsics.areEqual((Object)((Resource)other).alias, (Object)this.alias);
    }

    public int hashCode() {
        return 527 + this.alias.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$appendIndent_u24default$iv;
        StringBuilder $this$appendIndent_u24default$iv2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u241.append("Resource: [");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$toString_u24lambda_u241;
        String value$iv = "alias: ";
        String indent$iv = "    ";
        boolean $i$f$appendIndent = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv2.append(indent$iv).append((Object)value$iv), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$toString_u24lambda_u241.append(this.alias);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        $this$appendIndent_u24default$iv2 = $this$toString_u24lambda_u241;
        value$iv = "isExecutable: ";
        indent$iv = "    ";
        $i$f$appendIndent = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv2.append(indent$iv).append((Object)value$iv), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$toString_u24lambda_u241.append(this.isExecutable);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        $this$appendIndent_u24default$iv2 = $this$toString_u24lambda_u241;
        value$iv = "platform: [";
        indent$iv = "    ";
        $i$f$appendIndent = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv2.append(indent$iv).append((Object)value$iv), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u241.append('\n'), (String)"append(...)");
        List lines = StringsKt.lines((CharSequence)this.platform.toString());
        boolean bl2 = false;
        int n = CollectionsKt.getLastIndex((List)lines);
        for (int i = 1; i < n; ++i) {
            void $this$appendIndent_u24default$iv3;
            StringBuilder stringBuilder6 = $this$toString_u24lambda_u241;
            Object value$iv2 = lines.get(i);
            String indent$iv2 = "    ";
            boolean $i$f$appendIndent2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv3.append(indent$iv2).append(value$iv2), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u241.append('\n'), (String)"append(...)");
        }
        StringBuilder i = $this$toString_u24lambda_u241;
        Character value$iv3 = Character.valueOf(']');
        String indent$iv3 = "    ";
        boolean $i$f$appendIndent3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv.append(indent$iv3).append(value$iv3), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u241.append('\n'), (String)"append(...)");
        $this$toString_u24lambda_u241.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ Resource(String alias, boolean isExecutable, PlatformResource platform, DefaultConstructorMarker $constructor_marker) {
        this(alias, isExecutable, platform);
    }

    @KmpTorDsl
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u000bJ!\u0010\u0007\u001a\u00020\u00002\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0007R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/matthewnelson/kmp/tor/common/core/Resource$Builder;", "", "alias", "", "(Ljava/lang/String;)V", "isExecutable", "", "platform", "Lio/matthewnelson/kmp/tor/common/core/PlatformResource;", "build", "Lio/matthewnelson/kmp/tor/common/core/Resource;", "build$io_matthewnelson_kmp_tor_common_core_jvm", "block", "Lkotlin/Function1;", "Lio/matthewnelson/kmp/tor/common/core/PlatformResource$Builder;", "", "Lkotlin/ExtensionFunctionType;", "io.matthewnelson.kmp-tor_common-core_jvm"})
    @InternalKmpTorApi
    public static final class Builder {
        @JvmField
        @NotNull
        public final String alias;
        @JvmField
        public boolean isExecutable;
        @Nullable
        private PlatformResource platform;

        public Builder(@NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            this.alias = alias;
        }

        @KmpTorDsl
        @NotNull
        public final Builder platform(@NotNull Function1<? super PlatformResource.Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            PlatformResource.Builder builder = new PlatformResource.Builder();
            block.invoke((Object)builder);
            this.platform = builder.build$io_matthewnelson_kmp_tor_common_core_jvm();
            return this;
        }

        public final /* synthetic */ Resource build$io_matthewnelson_kmp_tor_common_core_jvm() {
            PlatformResource platformResource = this.platform;
            if (platformResource == null) {
                return null;
            }
            PlatformResource p = platformResource;
            return new Resource(this.alias, this.isExecutable, p, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B#\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J*\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\rj\u0002`\u000e0\f2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0010\u001a\u00020\tJ\u0011\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/matthewnelson/kmp/tor/common/core/Resource$Config;", "", "errors", "", "", "resources", "Lio/matthewnelson/kmp/tor/common/core/Resource;", "(Ljava/util/Set;Ljava/util/Set;)V", "equals", "", "other", "extractTo", "", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "destinationDir", "onlyIfDoesNotExist", "get", "alias", "hashCode", "", "toString", "Builder", "Companion", "io.matthewnelson.kmp-tor_common-core_jvm"})
    @InternalKmpTorApi
    @SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\nio/matthewnelson/kmp/tor/common/core/Resource$Config\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 -CommonPlatform.kt\nio/matthewnelson/kmp/tor/common/core/internal/_CommonPlatformKt\n*L\n1#1,252:1\n223#2,2:253\n1855#2,2:255\n1855#2,2:257\n1855#2:265\n1855#2:266\n1856#2:268\n1856#2:269\n1855#2:278\n1856#2:283\n215#3,2:259\n25#4,4:261\n28#4:267\n25#4,4:270\n25#4,4:274\n25#4,4:279\n25#4,4:284\n*S KotlinDebug\n*F\n+ 1 Resource.kt\nio/matthewnelson/kmp/tor/common/core/Resource$Config\n*L\n51#1:253,2\n67#1:255,2\n82#1:257,2\n162#1:265\n163#1:266\n163#1:268\n162#1:269\n180#1:278\n180#1:283\n87#1:259,2\n155#1:261,4\n164#1:267\n168#1:270,4\n172#1:274,4\n183#1:279,4\n193#1:284,4\n*E\n"})
    public static final class Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final Set<String> errors;
        @JvmField
        @NotNull
        public final Set<Resource> resources;

        private Config(Set<String> errors, Set<Resource> resources) {
            this.errors = errors;
            this.resources = resources;
        }

        @NotNull
        public final Resource get(@NotNull String alias) throws NoSuchElementException {
            Object element$iv2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                Iterable $this$first$iv = this.resources;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Resource it = (Resource)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.alias, (Object)alias)) continue;
                    break block1;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            return (Resource)element$iv2;
        }

        @NotNull
        public final Map<String, File> extractTo(@NotNull File destinationDir, boolean onlyIfDoesNotExist) throws IllegalStateException, IOException {
            Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
            if (!this.errors.isEmpty()) {
                StringBuilder stringBuilder;
                boolean $i$a$-check-Resource$Config$extractTo$22 = false;
                StringBuilder $this$extractTo_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Iterable $this$forEach$iv = this.errors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String error = (String)element$iv;
                    boolean bl2 = false;
                    StringBuilder stringBuilder2 = $this$extractTo_u24lambda_u243_u24lambda_u242.append(error);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String $i$a$-check-Resource$Config$extractTo$22 = string;
                throw new IllegalStateException($i$a$-check-Resource$Config$extractTo$22.toString());
            }
            File dir = KmpFile.canonicalFileOf((File)destinationDir);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Failed to create destinationDir[" + dir + ']');
            }
            LinkedHashMap map = new LinkedHashMap(this.resources.size(), 1.0f);
            try {
                Iterable $this$forEach$iv = this.resources;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Resource resource = (Resource)element$iv;
                    boolean bl = false;
                    File file = _JvmPlatformKt.extractTo(resource, dir, onlyIfDoesNotExist);
                    ((Map)map).put(resource.alias, file);
                }
            }
            catch (Throwable t) {
                Map $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    try {
                        ((File)entry.getValue()).delete();
                    }
                    catch (IOException iOException) {
                    }
                }
                throw Exceptions.wrapIO((Throwable)t, (Function0)((Function0)new Function0<String>(dir){
                    final /* synthetic */ File $dir;
                    {
                        this.$dir = $dir;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Failed to extract resources to destinationDir[" + this.$dir + ']';
                    }
                }));
            }
            return Immutable.mapOf((Map)map);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Config && Intrinsics.areEqual(((Config)other).errors, this.errors) && Intrinsics.areEqual(((Config)other).resources, this.resources);
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + ((Object)this.errors).hashCode();
            result = result * 31 + ((Object)this.resources).hashCode();
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString() {
            boolean $i$f$appendIndent;
            String indent$iv;
            StringBuilder $this$appendIndent_u24default$iv;
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u2410 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$toString_u24lambda_u2410.append("Resource.Config: [");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u2410;
            Object value$iv = "errors: [";
            Object indent$iv2 = "    ";
            boolean $i$f$appendIndent2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv.append((String)indent$iv2).append(value$iv), (String)"append(...)");
            if (this.errors.isEmpty()) {
                StringBuilder stringBuilder4 = $this$toString_u24lambda_u2410.append(']');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
                Object $this$forEach$iv = this.errors;
                boolean $i$f$forEach = false;
                indent$iv2 = $this$forEach$iv.iterator();
                while (indent$iv2.hasNext()) {
                    Object element$iv = indent$iv2.next();
                    String error = (String)element$iv;
                    boolean bl2 = false;
                    Iterable $this$forEach$iv2 = StringsKt.lines((CharSequence)error);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        void $this$appendIndent$iv;
                        String line = (String)element$iv2;
                        boolean bl3 = false;
                        StringBuilder stringBuilder5 = $this$toString_u24lambda_u2410;
                        indent$iv = "        ";
                        $i$f$appendIndent = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent$iv.append(indent$iv).append((Object)line), (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
                    }
                }
                $this$forEach$iv = $this$toString_u24lambda_u2410;
                value$iv = Character.valueOf(']');
                indent$iv2 = "    ";
                $i$f$appendIndent2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv.append((String)indent$iv2).append(value$iv), (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
            }
            $this$appendIndent_u24default$iv = $this$toString_u24lambda_u2410;
            value$iv = "resources: [";
            indent$iv2 = "    ";
            $i$f$appendIndent2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv.append((String)indent$iv2).append(value$iv), (String)"append(...)");
            if (this.resources.isEmpty()) {
                StringBuilder stringBuilder6 = $this$toString_u24lambda_u2410.append(']');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            } else {
                void $this$appendIndent_u24default$iv2;
                Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
                int count = 0;
                Object $this$forEach$iv = this.resources;
                boolean $i$f$forEach = false;
                Iterator $i$f$appendIndent3 = $this$forEach$iv.iterator();
                while ($i$f$appendIndent3.hasNext()) {
                    Object element$iv = $i$f$appendIndent3.next();
                    Resource resource = (Resource)element$iv;
                    boolean bl4 = false;
                    List lines = StringsKt.lines((CharSequence)resource.toString());
                    boolean bl5 = false;
                    int n = CollectionsKt.getLastIndex((List)lines);
                    for (int i = 1; i < n; ++i) {
                        void $this$appendIndent_u24default$iv3;
                        StringBuilder bl3 = $this$toString_u24lambda_u2410;
                        Object value$iv2 = lines.get(i);
                        indent$iv = "    ";
                        $i$f$appendIndent = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv3.append(indent$iv).append(value$iv2), (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
                    }
                    if (++count >= this.resources.size()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
                }
                $this$forEach$iv = $this$toString_u24lambda_u2410;
                Character value$iv3 = Character.valueOf(']');
                String indent$iv3 = "    ";
                boolean $i$f$appendIndent4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndent_u24default$iv2.append(indent$iv3).append(value$iv3), (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u2410.append('\n'), (String)"append(...)");
            }
            $this$toString_u24lambda_u2410.append(']');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        @KmpTorDsl
        @NotNull
        public static final Config create(@NotNull Function1<? super Builder, Unit> block) {
            return Companion.create(block);
        }

        public /* synthetic */ Config(Set errors, Set resources, DefaultConstructorMarker $constructor_marker) {
            this(errors, resources);
        }

        @KmpTorDsl
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\r\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005H\u0007J3\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u0015H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/kmp/tor/common/core/Resource$Config$Builder;", "", "()V", "errors", "", "", "resources", "Lio/matthewnelson/kmp/tor/common/core/Resource;", "build", "Lio/matthewnelson/kmp/tor/common/core/Resource$Config;", "build$io_matthewnelson_kmp_tor_common_core_jvm", "error", "message", "resource", "alias", "require", "", "block", "Lkotlin/Function1;", "Lio/matthewnelson/kmp/tor/common/core/Resource$Builder;", "", "Lkotlin/ExtensionFunctionType;", "io.matthewnelson.kmp-tor_common-core_jvm"})
        @InternalKmpTorApi
        @SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\nio/matthewnelson/kmp/tor/common/core/Resource$Config$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
        public static final class Builder {
            @NotNull
            private final Set<String> errors = new LinkedHashSet();
            @NotNull
            private final Set<Resource> resources = new LinkedHashSet();

            @KmpTorDsl
            @NotNull
            public final Builder error(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (!StringsKt.isBlank((CharSequence)message)) {
                    this.errors.add(message);
                }
                return this;
            }

            @KmpTorDsl
            @NotNull
            public final Builder resource(@NotNull String alias, boolean require, @NotNull Function1<? super io.matthewnelson.kmp.tor.common.core.Resource$Builder, Unit> block) {
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                Intrinsics.checkNotNullParameter(block, (String)"block");
                if (!(!StringsKt.isBlank((CharSequence)alias))) {
                    boolean bl = false;
                    String string = "alias cannot be blank";
                    throw new IllegalArgumentException(string.toString());
                }
                io.matthewnelson.kmp.tor.common.core.Resource$Builder builder = new io.matthewnelson.kmp.tor.common.core.Resource$Builder(alias);
                block.invoke((Object)builder);
                Resource resource = builder.build$io_matthewnelson_kmp_tor_common_core_jvm();
                if (resource != null) {
                    this.resources.add(resource);
                } else if (require) {
                    this.error("Resource[" + alias + "] was misconfigured");
                }
                return this;
            }

            public static /* synthetic */ Builder resource$default(Builder builder, String string, boolean bl, Function1 function1, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                return builder.resource(string, bl, (Function1<? super io.matthewnelson.kmp.tor.common.core.Resource$Builder, Unit>)function1);
            }

            public final /* synthetic */ Config build$io_matthewnelson_kmp_tor_common_core_jvm() {
                return new Config(Immutable.setOf((Collection)this.errors), Immutable.setOf((Collection)this.resources), null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0007\u00a8\u0006\n"}, d2={"Lio/matthewnelson/kmp/tor/common/core/Resource$Config$Companion;", "", "()V", "create", "Lio/matthewnelson/kmp/tor/common/core/Resource$Config;", "block", "Lkotlin/Function1;", "Lio/matthewnelson/kmp/tor/common/core/Resource$Config$Builder;", "", "Lkotlin/ExtensionFunctionType;", "io.matthewnelson.kmp-tor_common-core_jvm"})
        @InternalKmpTorApi
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @KmpTorDsl
            @NotNull
            public final Config create(@NotNull Function1<? super Builder, Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                Builder builder = new Builder();
                block.invoke((Object)builder);
                return builder.build$io_matthewnelson_kmp_tor_common_core_jvm();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

