/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.binary.extract.internal;

import io.matthewnelson.kmp.tor.binary.extract.ExtractionException;
import io.matthewnelson.kmp.tor.binary.extract.TorResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\f\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012JL\u0010\u0014\u001a\u00060\nj\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000e2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00028\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001fJH\u0010\u0014\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000e2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00028\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010#\u001a\u00028\u00012\u0006\u0010$\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010'\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010(\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010)\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\fJ\u0015\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\fJ\u001d\u0010+\u001a\u00020,2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0010\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020 2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00101J\u001d\u00102\u001a\u00020 2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u00103\u001a\u00020\nH$\u00a2\u0006\u0002\u00104J\f\u00105\u001a\u00020\n*\u00020\nH$J\u0011\u00106\u001a\u00028\u0000*\u00020\nH$\u00a2\u0006\u0002\u00107J\u0019\u00108\u001a\u00020 *\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H$\u00a2\u0006\u0002\u00109R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006:"}, d2={"Lio/matthewnelson/kmp/tor/binary/extract/internal/ExtractorDelegate;", "F", "", "S", "()V", "fsSeparator", "", "getFsSeparator", "()C", "canonicalPath", "", "file", "(Ljava/lang/Object;)Ljava/lang/String;", "checkSha256SumFile", "", "sha256Sum", "(Ljava/lang/Object;Ljava/lang/String;)Z", "delete", "(Ljava/lang/Object;)Z", "exists", "extract", "Lio/matthewnelson/kmp/tor/binary/extract/TorFilePath;", "resource", "Lio/matthewnelson/kmp/tor/binary/extract/TorResource$Binaries;", "destinationDir", "cleanExtraction", "provideStream", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "resourcePath", "extract$kmp_tor_binary_extract", "", "Lio/matthewnelson/kmp/tor/binary/extract/TorResource$Geoips;", "destination", "gunzip", "stream", "(Ljava/lang/Object;)Ljava/lang/Object;", "isDirectory", "isFile", "mkdirs", "nameWithoutExtension", "readText", "resourceNotFound", "Lio/matthewnelson/kmp/tor/binary/extract/ExtractionException;", "t", "", "resourceNotFound$kmp_tor_binary_extract", "setExecutable", "(Ljava/lang/Object;)V", "writeText", "text", "(Ljava/lang/Object;Ljava/lang/String;)V", "normalize", "toFile", "(Ljava/lang/String;)Ljava/lang/Object;", "write", "(Ljava/lang/Object;Ljava/lang/Object;)V", "kmp-tor-binary-extract"})
public abstract class ExtractorDelegate<F, S> {
    @NotNull
    protected abstract F toFile(@NotNull String var1);

    @NotNull
    protected abstract String normalize(@NotNull String var1);

    protected char getFsSeparator() {
        return '/';
    }

    protected abstract boolean isFile(@NotNull F var1);

    protected abstract boolean isDirectory(@NotNull F var1);

    protected abstract boolean exists(@NotNull F var1);

    @NotNull
    protected abstract String nameWithoutExtension(@NotNull F var1);

    @Nullable
    protected abstract String canonicalPath(@Nullable F var1);

    protected abstract void setExecutable(@NotNull F var1);

    protected abstract boolean delete(@NotNull F var1);

    protected abstract boolean mkdirs(@NotNull F var1);

    @NotNull
    protected abstract S gunzip(@NotNull S var1);

    @NotNull
    protected abstract String readText(@NotNull F var1);

    protected abstract void writeText(@NotNull F var1, @NotNull String var2);

    protected abstract void write(@NotNull F var1, @NotNull S var2) throws ExtractionException;

    public final void extract$kmp_tor_binary_extract(@NotNull TorResource.Geoips resource, @NotNull String destination, boolean cleanExtraction, @NotNull Function1<? super String, ? extends S> provideStream) throws ExtractionException {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(provideStream, (String)"provideStream");
        try {
            Object object;
            String destinationNormalized = this.normalize(destination);
            F destinationFile = this.toFile(destinationNormalized);
            if (this.exists(destinationFile) && this.isDirectory(destinationFile)) {
                throw new ExtractionException("destination for " + resource.getResourcePath() + " extraction cannot be a directory");
            }
            String sha256SumValue = resource.getSha256sum();
            F sha256SumFile = this.toFile(destinationNormalized + "_sha256.txt");
            boolean isSha256SumValid = this.checkSha256SumFile(sha256SumFile, sha256SumValue);
            if (!cleanExtraction && this.exists(destinationFile) && isSha256SumValid) {
                return;
            }
            try {
                object = this.gunzip(provideStream.invoke((Object)resource.getResourcePath()));
            }
            catch (ExtractionException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ExtractionException("Failed to open stream for " + resource.getResourcePath(), t);
            }
            Object gunzipStream = object;
            try {
                this.write(destinationFile, gunzipStream);
            }
            catch (Throwable t) {
                try {
                    this.delete(destinationFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw t;
            }
            if (isSha256SumValid) {
                return;
            }
            try {
                this.writeText(sha256SumFile, sha256SumValue);
            }
            catch (Throwable t) {
                try {
                    this.delete(destinationFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.delete(sha256SumFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ExtractionException("Failed to write sha256sum to file " + sha256SumFile, t);
            }
        }
        catch (ExtractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ExtractionException("Failed to extract " + resource.getResourcePath() + " to " + destination, t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String extract$kmp_tor_binary_extract(@NotNull TorResource.Binaries resource, @NotNull String destinationDir, boolean cleanExtraction, @NotNull Function1<? super String, ? extends S> provideStream) throws ExtractionException {
        String string;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter(provideStream, (String)"provideStream");
        try {
            string = this.normalize(destinationDir);
        }
        catch (Throwable t) {
            throw new ExtractionException("Failed to normalize destinationDir: " + destinationDir);
        }
        String destinationDirNormalized = string;
        List<String> manifest = resource.getResourceManifest();
        ArrayList<Object> filesWritten = new ArrayList<Object>(manifest.size() + 1);
        F extractionToDir = this.toFile(destinationDirNormalized);
        try {
            void $this$mapTo$iv$iv$iv;
            if (this.exists(extractionToDir)) {
                if (!this.isDirectory(extractionToDir) && !this.delete(extractionToDir)) {
                    throw new ExtractionException("Directory specified (" + destinationDir + ") exists, is not a directory, and failed to delete prior to extracting resources.");
                }
            } else if (!this.mkdirs(extractionToDir)) {
                throw new ExtractionException("Failed to create destinationDir (" + destinationDir + ") to extract " + resource + " to.");
            }
            F sha256SumFile = this.toFile(this.normalize(destinationDirNormalized + this.getFsSeparator() + "tor_sha256.txt"));
            filesWritten.add(sha256SumFile);
            String sha256SumValue = resource.getSha256sum();
            boolean bl = this.checkSha256SumFile(sha256SumFile, sha256SumValue);
            String resourceDirPath = resource.getResourceDirPath();
            ArrayList<Pair> extractResourceTo = new ArrayList<Pair>(manifest.size());
            boolean shouldExtract = false;
            shouldExtract = !bl || cleanExtraction;
            F torFile = null;
            List<String> $this$mapManifestToDestination$iv = manifest;
            boolean $i$f$mapManifestToDestination = false;
            char separator$iv = StringsKt.first((CharSequence)destinationDirNormalized) == '/' ? (char)'/' : '\\';
            Iterable $this$map$iv$iv = $this$mapManifestToDestination$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void destination;
                void item$iv;
                String mapped$iv;
                String string2 = (String)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Object sep$iv = StringsKt.endsWith$default((CharSequence)destinationDirNormalized, (char)separator$iv, (boolean)false, (int)2, null) ? "" : Character.valueOf(separator$iv);
                String string3 = mapped$iv = destinationDirNormalized + sep$iv + StringsKt.substringBeforeLast$default((String)StringsKt.replace$default((String)item$iv, (char)'/', (char)separator$iv, (boolean)false, (int)4, null), (String)".gz", null, (int)2, null);
                void manifestItem = item$iv;
                boolean bl22 = false;
                F writeTo = this.toFile(this.normalize((String)destination));
                extractResourceTo.add(new Pair((Object)(resourceDirPath + "/" + (String)manifestItem), writeTo));
                String string4 = this.nameWithoutExtension(writeTo).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (Intrinsics.areEqual((Object)string4, (Object)"tor")) {
                    torFile = writeTo;
                }
                if (!this.exists(writeTo)) {
                    shouldExtract = true;
                }
                collection.add(mapped$iv);
            }
            List cfr_ignored_0 = (List)destination$iv$iv$iv;
            Iterable $this$forEach$iv = extractResourceTo;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair item = (Pair)element$iv;
                boolean bl3 = false;
                filesWritten.add(item.getSecond());
                if (shouldExtract) {
                    Object gunzipStream = this.gunzip(provideStream.invoke(item.getFirst()));
                    this.write(item.getSecond(), gunzipStream);
                }
                this.setExecutable(item.getSecond());
            }
            if (!bl) {
                this.writeText(sha256SumFile, sha256SumValue);
            }
            String string5 = this.canonicalPath(torFile);
            if (string5 == null) {
                throw new NullPointerException("Tor binary file was not found after extraction");
            }
            return string5;
        }
        catch (ExtractionException e) {
            for (Object e2 : filesWritten) {
                try {
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"file");
                    this.delete(e2);
                }
                catch (Exception exception) {}
            }
            throw e;
        }
        catch (Exception e) {
            for (Object e3 : filesWritten) {
                try {
                    Intrinsics.checkNotNullExpressionValue(e3, (String)"file");
                    this.delete(e3);
                }
                catch (Exception exception) {}
            }
            throw new ExtractionException("Failed to extract " + resource + " to " + destinationDir, e);
        }
    }

    @NotNull
    public ExtractionException resourceNotFound$kmp_tor_binary_extract(@NotNull String resource, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new ExtractionException("Resource not found: " + resource, t);
    }

    private final boolean checkSha256SumFile(F file, String sha256Sum) {
        boolean bl;
        try {
            bl = this.exists(file) ? (this.isFile(file) ? Intrinsics.areEqual((Object)this.readText(file), (Object)sha256Sum) : false) : false;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }
}

