/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.binary.extract.internal;

import io.matthewnelson.kmp.tor.binary.extract.ExtractionException;
import io.matthewnelson.kmp.tor.binary.extract.internal.ExtractorDelegate;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\nH\u0014J\f\u0010\u001a\u001a\u00020\n*\u00020\nH\u0014J\f\u0010\u001b\u001a\u00020\u0002*\u00020\nH\u0014J\u0014\u0010\u001c\u001a\u00020\u0017*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lio/matthewnelson/kmp/tor/binary/extract/internal/ExtractorDelegateJvmAndroid;", "Lio/matthewnelson/kmp/tor/binary/extract/internal/ExtractorDelegate;", "Ljava/io/File;", "Ljava/io/InputStream;", "()V", "fsSeparator", "", "getFsSeparator", "()C", "canonicalPath", "", "file", "delete", "", "exists", "gunzip", "stream", "isDirectory", "isFile", "mkdirs", "nameWithoutExtension", "readText", "setExecutable", "", "writeText", "text", "normalize", "toFile", "write", "kmp-tor-binary-extract"})
public final class ExtractorDelegateJvmAndroid
extends ExtractorDelegate<File, InputStream> {
    @Override
    @NotNull
    protected File toFile(@NotNull String $this$toFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toFile, (String)"<this>");
        return new File($this$toFile);
    }

    @Override
    @NotNull
    protected String normalize(@NotNull String $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        String string = FilesKt.normalize((File)new File($this$normalize)).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(this).normalize().path");
        return string;
    }

    @Override
    protected char getFsSeparator() {
        return File.separatorChar;
    }

    @Override
    protected boolean isFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.isFile();
    }

    @Override
    protected boolean isDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.isDirectory();
    }

    @Override
    protected boolean exists(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.exists();
    }

    @Override
    @NotNull
    protected String nameWithoutExtension(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FilesKt.getNameWithoutExtension((File)file);
    }

    @Override
    @Nullable
    protected String canonicalPath(@Nullable File file) {
        File file2 = file;
        return file2 != null ? file2.getCanonicalPath() : null;
    }

    @Override
    protected void setExecutable(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.setExecutable(true);
    }

    @Override
    protected boolean delete(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FilesKt.deleteRecursively((File)file);
    }

    @Override
    protected boolean mkdirs(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.mkdirs();
    }

    @Override
    @NotNull
    protected InputStream gunzip(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return new GZIPInputStream(stream);
    }

    @Override
    @NotNull
    protected String readText(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FilesKt.readText$default((File)file, null, (int)1, null);
    }

    @Override
    protected void writeText(@NotNull File file, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        FilesKt.writeText$default((File)file, (String)text, null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(@NotNull File $this$write, @NotNull InputStream stream) throws ExtractionException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream iStream = (InputStream)closeable;
            boolean bl = false;
            Object object = $this$write.getParentFile();
            File file = object;
            if (file != null) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parentFile");
                File pf = object;
                boolean bl2 = false;
                if (!pf.exists() && !pf.mkdirs()) {
                    throw new ExtractionException("Failed to create directory " + pf);
                }
            }
            if ($this$write.exists() && !$this$write.delete()) {
                throw new ExtractionException("Failed to delete file " + $this$write + " before overwriting it.");
            }
            if (!$this$write.createNewFile()) {
                throw new ExtractionException("Failed to create file " + $this$write);
            }
            try {
                object = new FileOutputStream($this$write);
                Throwable throwable2 = null;
                try {
                    int read;
                    FileOutputStream oStream = (FileOutputStream)object;
                    boolean bl3 = false;
                    byte[] buffer = new byte[4096];
                    while ((read = iStream.read(buffer)) != -1) {
                        oStream.write(buffer, 0, read);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
            catch (Throwable t) {
                throw new ExtractionException("Failed to write data to " + $this$write, t);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

