(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'component-parcelize-parcelize-js-legacy', 'component-encoding-encoding-base32-js-legacy', 'component-encoding-encoding-base64-js-legacy', 'component-encoding-encoding-base16-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('component-parcelize-parcelize-js-legacy'), require('component-encoding-encoding-base32-js-legacy'), require('component-encoding-encoding-base64-js-legacy'), require('component-encoding-encoding-base16-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-common-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kmp-tor-kmp-tor-common-js-legacy'.");
    }
    if (typeof this['component-parcelize-parcelize-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-common-js-legacy'. Its dependency 'component-parcelize-parcelize-js-legacy' was not found. Please, check whether 'component-parcelize-parcelize-js-legacy' is loaded prior to 'kmp-tor-kmp-tor-common-js-legacy'.");
    }
    if (typeof this['component-encoding-encoding-base32-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-common-js-legacy'. Its dependency 'component-encoding-encoding-base32-js-legacy' was not found. Please, check whether 'component-encoding-encoding-base32-js-legacy' is loaded prior to 'kmp-tor-kmp-tor-common-js-legacy'.");
    }
    if (typeof this['component-encoding-encoding-base64-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-common-js-legacy'. Its dependency 'component-encoding-encoding-base64-js-legacy' was not found. Please, check whether 'component-encoding-encoding-base64-js-legacy' is loaded prior to 'kmp-tor-kmp-tor-common-js-legacy'.");
    }
    if (typeof this['component-encoding-encoding-base16-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kmp-tor-kmp-tor-common-js-legacy'. Its dependency 'component-encoding-encoding-base16-js-legacy' was not found. Please, check whether 'component-encoding-encoding-base16-js-legacy' is loaded prior to 'kmp-tor-kmp-tor-common-js-legacy'.");
    }
    root['kmp-tor-kmp-tor-common-js-legacy'] = factory(typeof this['kmp-tor-kmp-tor-common-js-legacy'] === 'undefined' ? {} : this['kmp-tor-kmp-tor-common-js-legacy'], kotlin, this['component-parcelize-parcelize-js-legacy'], this['component-encoding-encoding-base32-js-legacy'], this['component-encoding-encoding-base64-js-legacy'], this['component-encoding-encoding-base16-js-legacy']);
  }
}(this, function (_, Kotlin, $module$component_parcelize_parcelize_js_legacy, $module$component_encoding_encoding_base32_js_legacy, $module$component_encoding_encoding_base64_js_legacy, $module$component_encoding_encoding_base16_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Parcelable = $module$component_parcelize_parcelize_js_legacy.io.matthewnelson.component.parcelize.Parcelable;
  var substringBefore = Kotlin.kotlin.text.substringBefore_8cymmc$;
  var Pair_init = Kotlin.kotlin.Pair;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var trimStart = Kotlin.kotlin.text.trimStart_gw00vp$;
  var Base32 = $module$component_encoding_encoding_base32_js_legacy.io.matthewnelson.component.encoding.base32.Base32;
  var ensureNotNull = Kotlin.ensureNotNull;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var toCharArray = Kotlin.kotlin.text.toCharArray_pdl1vz$;
  var decodeBase32ToArray = $module$component_encoding_encoding_base32_js_legacy.io.matthewnelson.component.encoding.base32.decodeBase32ToArray_6vdjpe$;
  var decodeBase64ToArray = $module$component_encoding_encoding_base64_js_legacy.io.matthewnelson.component.base64.decodeBase64ToArray_355ntz$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var first = Kotlin.kotlin.text.first_gw00vp$;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var startsWith = Kotlin.kotlin.text.startsWith_sgbm27$;
  var drop = Kotlin.kotlin.text.drop_6ic1pp$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var NumberFormatException = Kotlin.kotlin.NumberFormatException;
  var contains = Kotlin.kotlin.text.contains_sgbm27$;
  var substringAfter = Kotlin.kotlin.text.substringAfter_8cymmc$;
  var getOrNull = Kotlin.kotlin.collections.getOrNull_yzln2o$;
  var split_0 = Kotlin.kotlin.text.split_o64adg$;
  var Exception = Kotlin.kotlin.Exception;
  var startsWith_0 = Kotlin.kotlin.text.startsWith_7epoxm$;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var Annotation = Kotlin.kotlin.Annotation;
  var equals = Kotlin.equals;
  var hashCode = Kotlin.hashCode;
  var Base64 = $module$component_encoding_encoding_base64_js_legacy.io.matthewnelson.component.base64.Base64;
  var dropLast = Kotlin.kotlin.text.dropLast_6ic1pp$;
  var joinToString = Kotlin.kotlin.collections.joinToString_xqrb1d$;
  var encodeBase64ToByteArray = $module$component_encoding_encoding_base64_js_legacy.io.matthewnelson.component.base64.encodeBase64ToByteArray_9rg39$;
  var toChar = Kotlin.toChar;
  var StringBuilder_init_0 = Kotlin.kotlin.text.StringBuilder;
  var encodeBase32ToByteArray = $module$component_encoding_encoding_base32_js_legacy.io.matthewnelson.component.encoding.base32.encodeBase32ToByteArray_5et6us$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var toBoxedChar = Kotlin.toBoxedChar;
  var firstOrNull = Kotlin.kotlin.text.firstOrNull_gw00vp$;
  var unboxChar = Kotlin.unboxChar;
  var decodeBase16ToArray = $module$component_encoding_encoding_base16_js_legacy.io.matthewnelson.component.encoding.base16.decodeBase16ToArray_355ntz$;
  OnionAddress$PrivateKey$Type$ED25519_V3.prototype = Object.create(OnionAddress$PrivateKey$Type.prototype);
  OnionAddress$PrivateKey$Type$ED25519_V3.prototype.constructor = OnionAddress$PrivateKey$Type$ED25519_V3;
  Scheme.prototype = Object.create(Enum.prototype);
  Scheme.prototype.constructor = Scheme;
  OnionClientAuth$Key$Type.prototype = Object.create(Enum.prototype);
  OnionClientAuth$Key$Type.prototype.constructor = OnionClientAuth$Key$Type;
  function OnionAddress() {
    OnionAddress$Companion_getInstance();
  }
  function OnionAddress$Companion() {
    OnionAddress$Companion_instance = this;
  }
  OnionAddress$Companion.prototype.fromString_61zpoe$ = function (address) {
    var tmp$;
    var tmp$_0;
    var trimmed = trim(Kotlin.isCharSequence(tmp$_0 = address) ? tmp$_0 : throwCCE()).toString();
    var scheme = Scheme.Companion.fromString_ivxn3r$(trimmed, false);
    if (scheme != null) {
      var startIndex = scheme.toString().length;
      tmp$ = trimmed.substring(startIndex);
    } else {
      tmp$ = trimmed;
    }
    var stripped = substringBefore((new Pair_init(scheme, tmp$)).second, 46);
    try {
      return OnionAddressV3$Companion_getInstance().invoke_61zpoe$(stripped);
    } catch (_) {
      if (!Kotlin.isType(_, IllegalArgumentException))
        throw _;
    }
    throw IllegalArgumentException_init('String was not an OnionAddress');
  };
  OnionAddress$Companion.prototype.fromStringOrNull_61zpoe$ = function (address) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(address);
    } catch (e) {
      if (Kotlin.isType(e, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw e;
    }
    return tmp$;
  };
  OnionAddress$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionAddress$Companion_instance = null;
  function OnionAddress$Companion_getInstance() {
    if (OnionAddress$Companion_instance === null) {
      new OnionAddress$Companion();
    }
    return OnionAddress$Companion_instance;
  }
  function OnionAddress$PrivateKey() {
    OnionAddress$PrivateKey$Companion_getInstance();
  }
  function OnionAddress$PrivateKey$Companion() {
    OnionAddress$PrivateKey$Companion_instance = this;
  }
  OnionAddress$PrivateKey$Companion.prototype.fromString_61zpoe$ = function (key) {
    var limit = key.length;
    while (limit > 0) {
      var c = key.charCodeAt(limit - 1 | 0);
      if (c !== 61 && c !== 10 && c !== 13 && c !== 32 && c !== 9) {
        break;
      }
      limit = limit - 1 | 0;
    }
    var endIndex = limit;
    var $receiver = key.substring(0, endIndex);
    var tmp$;
    var stripped = trimStart(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : throwCCE()).toString();
    try {
      return OnionAddressV3PrivateKey_ED25519$Companion_getInstance().invoke_61zpoe$(stripped);
    } catch (_) {
      if (!Kotlin.isType(_, IllegalArgumentException))
        throw _;
    }
    throw IllegalArgumentException_init('String was not an OnionAddress.PrivateKey');
  };
  OnionAddress$PrivateKey$Companion.prototype.fromStringOrNull_61zpoe$ = function (key) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(key);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  OnionAddress$PrivateKey$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionAddress$PrivateKey$Companion_instance = null;
  function OnionAddress$PrivateKey$Companion_getInstance() {
    if (OnionAddress$PrivateKey$Companion_instance === null) {
      new OnionAddress$PrivateKey$Companion();
    }
    return OnionAddress$PrivateKey$Companion_instance;
  }
  function OnionAddress$PrivateKey$Type() {
    OnionAddress$PrivateKey$Type$Companion_getInstance();
  }
  OnionAddress$PrivateKey$Type.prototype.toString = function () {
    var tmp$;
    if (Kotlin.isType(this, OnionAddress$PrivateKey$Type$ED25519_V3))
      tmp$ = OnionAddress$PrivateKey$Type$Companion_getInstance().ED25519_V3_ACTUAL_0;
    else
      tmp$ = Kotlin.noWhenBranchMatched();
    return tmp$;
  };
  function OnionAddress$PrivateKey$Type$Companion() {
    OnionAddress$PrivateKey$Type$Companion_instance = this;
    this.ED25519_V3_ACTUAL_0 = 'ED25519-V3';
    this.ED25519_V3_CLASS_0 = 'ED25519_V3';
  }
  OnionAddress$PrivateKey$Type$Companion.prototype.valueOf_61zpoe$ = function (value) {
    var tmp$;
    switch (value) {
      case 'ED25519-V3':
      case 'ED25519_V3':
        tmp$ = OnionAddress$PrivateKey$Type$ED25519_V3_getInstance();
        break;
      default:
        throw IllegalArgumentException_init('Failed to determine OnionAddress.PrivateKey.Type from ' + value);
    }
    return tmp$;
  };
  OnionAddress$PrivateKey$Type$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionAddress$PrivateKey$Type$Companion_instance = null;
  function OnionAddress$PrivateKey$Type$Companion_getInstance() {
    if (OnionAddress$PrivateKey$Type$Companion_instance === null) {
      new OnionAddress$PrivateKey$Type$Companion();
    }
    return OnionAddress$PrivateKey$Type$Companion_instance;
  }
  function OnionAddress$PrivateKey$Type$ED25519_V3() {
    OnionAddress$PrivateKey$Type$ED25519_V3_instance = this;
    OnionAddress$PrivateKey$Type.call(this);
  }
  OnionAddress$PrivateKey$Type$ED25519_V3.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ED25519_V3',
    interfaces: [OnionAddress$PrivateKey$Type]
  };
  var OnionAddress$PrivateKey$Type$ED25519_V3_instance = null;
  function OnionAddress$PrivateKey$Type$ED25519_V3_getInstance() {
    if (OnionAddress$PrivateKey$Type$ED25519_V3_instance === null) {
      new OnionAddress$PrivateKey$Type$ED25519_V3();
    }
    return OnionAddress$PrivateKey$Type$ED25519_V3_instance;
  }
  OnionAddress$PrivateKey$Type.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Type',
    interfaces: []
  };
  OnionAddress$PrivateKey.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PrivateKey',
    interfaces: [Parcelable]
  };
  OnionAddress.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionAddress',
    interfaces: [Parcelable]
  };
  function OnionAddressV3() {
    OnionAddressV3$Companion_getInstance();
  }
  function OnionAddressV3$Companion() {
    OnionAddressV3$Companion_instance = this;
  }
  Object.defineProperty(OnionAddressV3$Companion.prototype, 'REGEX', {
    configurable: true,
    get: function () {
      return Regex_init('[a-z2-7]{56}');
    }
  });
  OnionAddressV3$Companion.prototype.invoke_61zpoe$ = function (address) {
    return new RealOnionAddressV3(address);
  };
  OnionAddressV3$Companion.prototype.fromString_61zpoe$ = function (address) {
    var tmp$;
    var tmp$_0;
    var trimmed = trim(Kotlin.isCharSequence(tmp$_0 = address) ? tmp$_0 : throwCCE()).toString();
    var scheme = Scheme.Companion.fromString_ivxn3r$(trimmed, false);
    if (scheme != null) {
      var startIndex = scheme.toString().length;
      tmp$ = trimmed.substring(startIndex);
    } else {
      tmp$ = trimmed;
    }
    return new RealOnionAddressV3(substringBefore((new Pair_init(scheme, tmp$)).second, 46));
  };
  OnionAddressV3$Companion.prototype.fromStringOrNull_61zpoe$ = function (address) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(address);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  OnionAddressV3$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionAddressV3$Companion_instance = null;
  function OnionAddressV3$Companion_getInstance() {
    if (OnionAddressV3$Companion_instance === null) {
      new OnionAddressV3$Companion();
    }
    return OnionAddressV3$Companion_instance;
  }
  OnionAddressV3.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionAddressV3',
    interfaces: [OnionAddress]
  };
  function RealOnionAddressV3(value) {
    this.value_vx9e82$_0 = value;
    var $receiver = this.value;
    if (!OnionAddressV3$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = this.value + ' is not a valid onion address';
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealOnionAddressV3.prototype, 'value', {
    get: function () {
      return this.value_vx9e82$_0;
    }
  });
  Object.defineProperty(RealOnionAddressV3.prototype, 'valueDotOnion', {
    configurable: true,
    get: function () {
      return this.value + '.onion';
    }
  });
  RealOnionAddressV3.prototype.decode = function () {
    var $receiver = this.value.toUpperCase();
    var base32 = Base32.Default;
    return ensureNotNull(decodeBase32ToArray(toCharArray($receiver), base32));
  };
  RealOnionAddressV3.prototype.toString = function () {
    return 'OnionAddressV3(value=' + this.value + ')';
  };
  RealOnionAddressV3.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealOnionAddressV3',
    interfaces: [OnionAddressV3]
  };
  RealOnionAddressV3.prototype.unbox = function () {
    return this.value;
  };
  RealOnionAddressV3.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealOnionAddressV3.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function OnionAddressV3PrivateKey_ED25519() {
    OnionAddressV3PrivateKey_ED25519$Companion_getInstance();
  }
  function OnionAddressV3PrivateKey_ED25519$Companion() {
    OnionAddressV3PrivateKey_ED25519$Companion_instance = this;
  }
  Object.defineProperty(OnionAddressV3PrivateKey_ED25519$Companion.prototype, 'REGEX', {
    configurable: true,
    get: function () {
      return Regex_init('[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/]{86}');
    }
  });
  OnionAddressV3PrivateKey_ED25519$Companion.prototype.invoke_61zpoe$ = function (key) {
    return new RealOnionAddressV3PrivateKey_ED25519(key);
  };
  OnionAddressV3PrivateKey_ED25519$Companion.prototype.fromString_61zpoe$ = function (key) {
    var limit = key.length;
    while (limit > 0) {
      var c = key.charCodeAt(limit - 1 | 0);
      if (c !== 61 && c !== 10 && c !== 13 && c !== 32 && c !== 9) {
        break;
      }
      limit = limit - 1 | 0;
    }
    var endIndex = limit;
    var $receiver = key.substring(0, endIndex);
    var tmp$;
    return new RealOnionAddressV3PrivateKey_ED25519(trimStart(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : throwCCE()).toString());
  };
  OnionAddressV3PrivateKey_ED25519$Companion.prototype.fromStringOrNull_61zpoe$ = function (key) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(key);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  OnionAddressV3PrivateKey_ED25519$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionAddressV3PrivateKey_ED25519$Companion_instance = null;
  function OnionAddressV3PrivateKey_ED25519$Companion_getInstance() {
    if (OnionAddressV3PrivateKey_ED25519$Companion_instance === null) {
      new OnionAddressV3PrivateKey_ED25519$Companion();
    }
    return OnionAddressV3PrivateKey_ED25519$Companion_instance;
  }
  OnionAddressV3PrivateKey_ED25519.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionAddressV3PrivateKey_ED25519',
    interfaces: [OnionAddress$PrivateKey]
  };
  function RealOnionAddressV3PrivateKey_ED25519(value) {
    this.value_odx092$_0 = value;
    var $receiver = this.value;
    if (!OnionAddressV3PrivateKey_ED25519$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = "value=[REDACTED] was not an 86 character base64 encoded (w/o padding '=') String";
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealOnionAddressV3PrivateKey_ED25519.prototype, 'value', {
    get: function () {
      return this.value_odx092$_0;
    }
  });
  RealOnionAddressV3PrivateKey_ED25519.prototype.decode = function () {
    return ensureNotNull(decodeBase64ToArray(toCharArray(this.value)));
  };
  Object.defineProperty(RealOnionAddressV3PrivateKey_ED25519.prototype, 'keyType', {
    configurable: true,
    get: function () {
      return OnionAddress$PrivateKey$Type$ED25519_V3_getInstance();
    }
  });
  RealOnionAddressV3PrivateKey_ED25519.prototype.toString = function () {
    return 'OnionAddressV3PrivateKey_ED25519(value=[REDACTED])';
  };
  RealOnionAddressV3PrivateKey_ED25519.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealOnionAddressV3PrivateKey_ED25519',
    interfaces: [OnionAddressV3PrivateKey_ED25519]
  };
  RealOnionAddressV3PrivateKey_ED25519.prototype.unbox = function () {
    return this.value;
  };
  RealOnionAddressV3PrivateKey_ED25519.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealOnionAddressV3PrivateKey_ED25519.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function OnionUrl(address, path, port, scheme) {
    OnionUrl$Companion_getInstance();
    if (path === void 0)
      path = '';
    if (port === void 0)
      port = null;
    if (scheme === void 0)
      scheme = Scheme$HTTP_getInstance();
    this.address = address;
    this.path = path;
    this.port = port;
    this.scheme = scheme;
  }
  OnionUrl.prototype.toString = function () {
    var sb = StringBuilder_init();
    sb.append_s8jyv4$(this.scheme);
    sb.append_pdl1vj$(this.address.valueDotOnion);
    if (this.port != null) {
      sb.append_s8itvh$(58).append_s8jyv4$(this.port.value);
    }
    if (this.path.length > 0 && first(this.path) !== 47) {
      sb.append_s8itvh$(47);
    }
    sb.append_pdl1vj$(this.path);
    return sb.toString();
  };
  function OnionUrl$Companion() {
    OnionUrl$Companion_instance = this;
  }
  OnionUrl$Companion.prototype.fromString_61zpoe$ = function (url) {
    var tmp$, tmp$_0, tmp$_1;
    var tmp$_2;
    var tmp$_3;
    var trimmed = trim(Kotlin.isCharSequence(tmp$_3 = url) ? tmp$_3 : throwCCE()).toString();
    var scheme = Scheme.Companion.fromString_ivxn3r$(trimmed, false);
    if (scheme != null) {
      var startIndex = scheme.toString().length;
      tmp$_2 = trimmed.substring(startIndex);
    } else {
      tmp$_2 = trimmed;
    }
    var tmp$_4 = new Pair_init(scheme, tmp$_2);
    var scheme_0 = tmp$_4.component1()
    , substring = tmp$_4.component2();
    var splits = split(substring, ['.onion']);
    if (splits.isEmpty()) {
      throw IllegalArgumentException_init('Failed to parse url');
    }
    var oAddress = OnionAddressV3$Companion_getInstance().invoke_61zpoe$(splits.get_za3lpa$(0));
    var tmp$_5;
    if ((tmp$ = getOrNull(splits, 1)) != null) {
      var block$result;
      if (startsWith(tmp$, 58)) {
        var portString = drop(substringBefore(tmp$, 47), 1);
        try {
          block$result = Port$Companion_getInstance().invoke_za3lpa$(toInt(portString));
        } catch (e) {
          if (Kotlin.isType(e, NumberFormatException)) {
            throw new IllegalArgumentException('Port expressed in url (' + portString + ') malformed', e);
          } else
            throw e;
        }
      } else {
        block$result = null;
      }
      tmp$_5 = block$result;
    } else
      tmp$_5 = null;
    var port = tmp$_5;
    var tmp$_6;
    if ((tmp$_0 = getOrNull(splits, 1)) != null) {
      var block$result_0;
      if (contains(tmp$_0, 47)) {
        var other = substringAfter(tmp$_0, 47);
        block$result_0 = String.fromCharCode(47) + other;
      } else {
        block$result_0 = '';
      }
      tmp$_6 = block$result_0;
    } else
      tmp$_6 = null;
    var path = (tmp$_1 = tmp$_6) != null ? tmp$_1 : '';
    return new OnionUrl(oAddress, path, port, scheme_0 != null ? scheme_0 : Scheme$HTTP_getInstance());
  };
  OnionUrl$Companion.prototype.fromStringOrNull_61zpoe$ = function (url) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(url);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  OnionUrl$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionUrl$Companion_instance = null;
  function OnionUrl$Companion_getInstance() {
    if (OnionUrl$Companion_instance === null) {
      new OnionUrl$Companion();
    }
    return OnionUrl$Companion_instance;
  }
  OnionUrl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OnionUrl',
    interfaces: [Parcelable]
  };
  OnionUrl.prototype.component1 = function () {
    return this.address;
  };
  OnionUrl.prototype.component2 = function () {
    return this.path;
  };
  OnionUrl.prototype.component3 = function () {
    return this.port;
  };
  OnionUrl.prototype.component4 = function () {
    return this.scheme;
  };
  OnionUrl.prototype.copy_77s2y3$ = function (address, path, port, scheme) {
    return new OnionUrl(address === void 0 ? this.address : address, path === void 0 ? this.path : path, port === void 0 ? this.port : port, scheme === void 0 ? this.scheme : scheme);
  };
  OnionUrl.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.address) | 0;
    result = result * 31 + Kotlin.hashCode(this.path) | 0;
    result = result * 31 + Kotlin.hashCode(this.port) | 0;
    result = result * 31 + Kotlin.hashCode(this.scheme) | 0;
    return result;
  };
  OnionUrl.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.address, other.address) && Kotlin.equals(this.path, other.path) && Kotlin.equals(this.port, other.port) && Kotlin.equals(this.scheme, other.scheme)))));
  };
  function Port() {
    Port$Companion_getInstance();
  }
  function Port$Companion() {
    Port$Companion_instance = this;
    this.MIN = 0;
    this.MAX = 65535;
  }
  Port$Companion.prototype.invoke_za3lpa$ = function (port) {
    return new RealPort(port);
  };
  Port$Companion.prototype.fromIntOrNull_s8ev37$ = function (port) {
    var tmp$;
    try {
      if (port == null) {
        return null;
      }
      tmp$ = new RealPort(port);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  Port$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Port$Companion_instance = null;
  function Port$Companion_getInstance() {
    if (Port$Companion_instance === null) {
      new Port$Companion();
    }
    return Port$Companion_instance;
  }
  Port.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Port',
    interfaces: [Parcelable]
  };
  function RealPort(value) {
    this.value_q17gkl$_0 = value;
    var tmp$;
    tmp$ = this.value;
    if (!(0 <= tmp$ && tmp$ <= 65535)) {
      var message = 'Invalid port range. Must be between 0 and 65535';
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealPort.prototype, 'value', {
    get: function () {
      return this.value_q17gkl$_0;
    }
  });
  RealPort.prototype.toString = function () {
    return 'Port(value=' + this.value + ')';
  };
  RealPort.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealPort',
    interfaces: [Port]
  };
  RealPort.prototype.unbox = function () {
    return this.value;
  };
  RealPort.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealPort.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function PortProxy() {
    PortProxy$Companion_getInstance();
  }
  function PortProxy$Companion() {
    PortProxy$Companion_instance = this;
    this.MIN = 1024;
    this.MAX = 65535;
  }
  PortProxy$Companion.prototype.invoke_za3lpa$ = function (port) {
    return new RealPortProxy(port);
  };
  PortProxy$Companion.prototype.fromIntOrNull_s8ev37$ = function (port) {
    var tmp$;
    try {
      if (port == null) {
        return null;
      }
      tmp$ = new RealPortProxy(port);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  PortProxy$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PortProxy$Companion_instance = null;
  function PortProxy$Companion_getInstance() {
    if (PortProxy$Companion_instance === null) {
      new PortProxy$Companion();
    }
    return PortProxy$Companion_instance;
  }
  PortProxy.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PortProxy',
    interfaces: [Port]
  };
  function RealPortProxy(value) {
    this.value_x56r0b$_0 = value;
    var tmp$;
    tmp$ = this.value;
    if (!(1024 <= tmp$ && tmp$ <= 65535)) {
      var message = 'Invalid port range. Must be between 1024 and 65535';
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealPortProxy.prototype, 'value', {
    get: function () {
      return this.value_x56r0b$_0;
    }
  });
  RealPortProxy.prototype.toString = function () {
    return 'PortProxy(value=' + this.value + ')';
  };
  RealPortProxy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealPortProxy',
    interfaces: [PortProxy]
  };
  RealPortProxy.prototype.unbox = function () {
    return this.value;
  };
  RealPortProxy.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealPortProxy.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function ProxyAddress(ipAddress, port) {
    ProxyAddress$Companion_getInstance();
    this.ipAddress = ipAddress;
    this.port = port;
  }
  ProxyAddress.prototype.toString = function () {
    return this.ipAddress + ':' + this.port.value;
  };
  function ProxyAddress$Companion() {
    ProxyAddress$Companion_instance = this;
  }
  ProxyAddress$Companion.prototype.fromString_61zpoe$ = function (address) {
    var tmp$;
    var splits = split_0(address, Kotlin.charArrayOf(58));
    try {
      var $receiver = splits.get_za3lpa$(0);
      var tmp$_0;
      var tmp$_1 = trim(Kotlin.isCharSequence(tmp$_0 = $receiver) ? tmp$_0 : throwCCE()).toString();
      var tmp$_2 = Port$Companion_getInstance();
      var $receiver_0 = splits.get_za3lpa$(1);
      var tmp$_3;
      tmp$ = new ProxyAddress(tmp$_1, tmp$_2.invoke_za3lpa$(toInt(trim(Kotlin.isCharSequence(tmp$_3 = $receiver_0) ? tmp$_3 : throwCCE()).toString())));
    } catch (e) {
      if (Kotlin.isType(e, IllegalArgumentException)) {
        throw e;
      } else if (Kotlin.isType(e, Exception)) {
        throw IllegalArgumentException_init('Failed parse ' + address + ' for an ipAddress and port');
      } else
        throw e;
    }
    return tmp$;
  };
  ProxyAddress$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProxyAddress$Companion_instance = null;
  function ProxyAddress$Companion_getInstance() {
    if (ProxyAddress$Companion_instance === null) {
      new ProxyAddress$Companion();
    }
    return ProxyAddress$Companion_instance;
  }
  ProxyAddress.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProxyAddress',
    interfaces: [Parcelable]
  };
  ProxyAddress.prototype.component1 = function () {
    return this.ipAddress;
  };
  ProxyAddress.prototype.component2 = function () {
    return this.port;
  };
  ProxyAddress.prototype.copy_1gb3ha$ = function (ipAddress, port) {
    return new ProxyAddress(ipAddress === void 0 ? this.ipAddress : ipAddress, port === void 0 ? this.port : port);
  };
  ProxyAddress.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.ipAddress) | 0;
    result = result * 31 + Kotlin.hashCode(this.port) | 0;
    return result;
  };
  ProxyAddress.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.ipAddress, other.ipAddress) && Kotlin.equals(this.port, other.port)))));
  };
  function Scheme(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Scheme_initFields() {
    Scheme_initFields = function () {
    };
    Scheme$HTTP_instance = new Scheme('HTTP', 0);
    Scheme$HTTPS_instance = new Scheme('HTTPS', 1);
    Scheme$WS_instance = new Scheme('WS', 2);
    Scheme$WSS_instance = new Scheme('WSS', 3);
    Scheme$Companion_getInstance();
  }
  var Scheme$HTTP_instance;
  function Scheme$HTTP_getInstance() {
    Scheme_initFields();
    return Scheme$HTTP_instance;
  }
  var Scheme$HTTPS_instance;
  function Scheme$HTTPS_getInstance() {
    Scheme_initFields();
    return Scheme$HTTPS_instance;
  }
  var Scheme$WS_instance;
  function Scheme$WS_getInstance() {
    Scheme_initFields();
    return Scheme$WS_instance;
  }
  var Scheme$WSS_instance;
  function Scheme$WSS_getInstance() {
    Scheme_initFields();
    return Scheme$WSS_instance;
  }
  Scheme.prototype.toString = function () {
    var tmp$;
    switch (this.name) {
      case 'HTTP':
        tmp$ = 'http://';
        break;
      case 'HTTPS':
        tmp$ = 'https://';
        break;
      case 'WS':
        tmp$ = 'ws://';
        break;
      case 'WSS':
        tmp$ = 'wss://';
        break;
      default:
        tmp$ = Kotlin.noWhenBranchMatched();
        break;
    }
    return tmp$;
  };
  function Scheme$Companion() {
    Scheme$Companion_instance = this;
    this.SCHEME_HTTP = 'http';
    this.SCHEME_HTTPS = 'https';
    this.SCHEME_WS = 'ws';
    this.SCHEME_WSS = 'wss';
  }
  Scheme$Companion.prototype.fromString_ivxn3r$ = function (string, trim_0) {
    if (trim_0 === void 0)
      trim_0 = true;
    var tmp$;
    var tmp$_0;
    if (trim_0) {
      var tmp$_1;
      tmp$_0 = trim(Kotlin.isCharSequence(tmp$_1 = string) ? tmp$_1 : throwCCE()).toString();
    } else
      tmp$_0 = string;
    var trimmed = tmp$_0;
    if (startsWith_0(trimmed, this.SCHEME_HTTPS))
      tmp$ = Scheme$HTTPS_getInstance();
    else if (startsWith_0(trimmed, this.SCHEME_HTTP))
      tmp$ = Scheme$HTTP_getInstance();
    else if (startsWith_0(trimmed, this.SCHEME_WSS))
      tmp$ = Scheme$WSS_getInstance();
    else if (startsWith_0(trimmed, this.SCHEME_WS))
      tmp$ = Scheme$WS_getInstance();
    else
      tmp$ = null;
    return tmp$;
  };
  Scheme$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Scheme$Companion_instance = null;
  function Scheme$Companion_getInstance() {
    Scheme_initFields();
    if (Scheme$Companion_instance === null) {
      new Scheme$Companion();
    }
    return Scheme$Companion_instance;
  }
  Scheme.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Scheme',
    interfaces: [Parcelable, Enum]
  };
  function Scheme$values() {
    return [Scheme$HTTP_getInstance(), Scheme$HTTPS_getInstance(), Scheme$WS_getInstance(), Scheme$WSS_getInstance()];
  }
  Scheme.values = Scheme$values;
  function Scheme$valueOf(name) {
    switch (name) {
      case 'HTTP':
        return Scheme$HTTP_getInstance();
      case 'HTTPS':
        return Scheme$HTTPS_getInstance();
      case 'WS':
        return Scheme$WS_getInstance();
      case 'WSS':
        return Scheme$WSS_getInstance();
      default:
        throwISE('No enum constant io.matthewnelson.kmp.tor.common.address.Scheme.' + name);
    }
  }
  Scheme.valueOf_61zpoe$ = Scheme$valueOf;
  function ExperimentalTorApi() {
  }
  ExperimentalTorApi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExperimentalTorApi',
    interfaces: [Annotation]
  };
  function InternalTorApi() {
  }
  InternalTorApi.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InternalTorApi',
    interfaces: [Annotation]
  };
  function SealedValueClass() {
  }
  SealedValueClass.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SealedValueClass',
    interfaces: [Annotation]
  };
  function ClientName() {
    ClientName$Companion_getInstance();
  }
  function ClientName$Companion() {
    ClientName$Companion_instance = this;
  }
  ClientName$Companion.prototype.invoke_61zpoe$ = function (name) {
    return new RealClientName(name);
  };
  ClientName$Companion.prototype.fromStringOrNull_61zpoe$ = function (name) {
    var tmp$;
    try {
      tmp$ = new RealClientName(name);
    } catch (e) {
      if (Kotlin.isType(e, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw e;
    }
    return tmp$;
  };
  ClientName$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ClientName$Companion_instance = null;
  function ClientName$Companion_getInstance() {
    if (ClientName$Companion_instance === null) {
      new ClientName$Companion();
    }
    return ClientName$Companion_instance;
  }
  ClientName.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ClientName',
    interfaces: [Parcelable]
  };
  function RealClientName(value) {
    this.value_52sxi9$_0 = value;
    var tmp$;
    tmp$ = this.value.length;
    if (!(1 <= tmp$ && tmp$ <= 16)) {
      var message = 'ClientName must be between 1 and 16 characters in length';
      throw IllegalArgumentException_init(message.toString());
    }
    if (!!contains(this.value, 32)) {
      var message_0 = 'ClientName cannot contain spaces';
      throw IllegalArgumentException_init(message_0.toString());
    }
    if (!!contains(this.value, 10)) {
      var message_1 = "ClientName cannot contain '\\n'";
      throw IllegalArgumentException_init(message_1.toString());
    }
    if (!!contains(this.value, 13)) {
      var message_2 = "ClientName cannot contain '\\r'";
      throw IllegalArgumentException_init(message_2.toString());
    }
    if (!!contains(this.value, 9)) {
      var message_3 = "ClientName cannot contain '\\t'";
      throw IllegalArgumentException_init(message_3.toString());
    }
  }
  Object.defineProperty(RealClientName.prototype, 'value', {
    get: function () {
      return this.value_52sxi9$_0;
    }
  });
  RealClientName.prototype.toString = function () {
    return 'ClientName(value=' + this.value + ')';
  };
  RealClientName.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealClientName',
    interfaces: [ClientName]
  };
  RealClientName.prototype.unbox = function () {
    return this.value;
  };
  RealClientName.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealClientName.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function OnionClientAuth() {
  }
  function OnionClientAuth$Key() {
  }
  OnionClientAuth$Key.prototype.base64_6taknv$ = function (padded, callback$default) {
    if (padded === void 0)
      padded = false;
    return callback$default ? callback$default(padded) : this.base64_6taknv$$default(padded);
  };
  OnionClientAuth$Key.prototype.base32_6taknv$ = function (padded, callback$default) {
    if (padded === void 0)
      padded = false;
    return callback$default ? callback$default(padded) : this.base32_6taknv$$default(padded);
  };
  function OnionClientAuth$Key$Type(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OnionClientAuth$Key$Type_initFields() {
    OnionClientAuth$Key$Type_initFields = function () {
    };
    OnionClientAuth$Key$Type$x25519_instance = new OnionClientAuth$Key$Type('x25519', 0);
  }
  var OnionClientAuth$Key$Type$x25519_instance;
  function OnionClientAuth$Key$Type$x25519_getInstance() {
    OnionClientAuth$Key$Type_initFields();
    return OnionClientAuth$Key$Type$x25519_instance;
  }
  OnionClientAuth$Key$Type.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Type',
    interfaces: [Enum]
  };
  function OnionClientAuth$Key$Type$values() {
    return [OnionClientAuth$Key$Type$x25519_getInstance()];
  }
  OnionClientAuth$Key$Type.values = OnionClientAuth$Key$Type$values;
  function OnionClientAuth$Key$Type$valueOf(name) {
    switch (name) {
      case 'x25519':
        return OnionClientAuth$Key$Type$x25519_getInstance();
      default:
        throwISE('No enum constant io.matthewnelson.kmp.tor.common.clientauth.OnionClientAuth.Key.Type.' + name);
    }
  }
  OnionClientAuth$Key$Type.valueOf_61zpoe$ = OnionClientAuth$Key$Type$valueOf;
  OnionClientAuth$Key.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Key',
    interfaces: [Parcelable]
  };
  function OnionClientAuth$PublicKey() {
    OnionClientAuth$PublicKey$Companion_getInstance();
  }
  function OnionClientAuth$PublicKey$Companion() {
    OnionClientAuth$PublicKey$Companion_instance = this;
    this.DESCRIPTOR = 'descriptor';
  }
  OnionClientAuth$PublicKey$Companion.prototype.fromString_61zpoe$ = function (key) {
    var limit = key.length;
    while (limit > 0) {
      var c = key.charCodeAt(limit - 1 | 0);
      if (c !== 61 && c !== 10 && c !== 13 && c !== 32 && c !== 9) {
        break;
      }
      limit = limit - 1 | 0;
    }
    var endIndex = limit;
    var $receiver = key.substring(0, endIndex);
    var tmp$;
    var stripped = trimStart(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : throwCCE()).toString();
    try {
      return OnionClientAuthPublicKey_B64_X25519$Companion_getInstance().invoke_61zpoe$(stripped);
    } catch (_) {
      if (!Kotlin.isType(_, IllegalArgumentException))
        throw _;
    }
    try {
      return OnionClientAuthPublicKey_B32_X25519$Companion_getInstance().invoke_61zpoe$(stripped);
    } catch (_) {
      if (!Kotlin.isType(_, IllegalArgumentException))
        throw _;
    }
    throw IllegalArgumentException_init('String was not a OnionClientAuth.PublicKey');
  };
  OnionClientAuth$PublicKey$Companion.prototype.fromStringOrNull_61zpoe$ = function (key) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(key);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  OnionClientAuth$PublicKey$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionClientAuth$PublicKey$Companion_instance = null;
  function OnionClientAuth$PublicKey$Companion_getInstance() {
    if (OnionClientAuth$PublicKey$Companion_instance === null) {
      new OnionClientAuth$PublicKey$Companion();
    }
    return OnionClientAuth$PublicKey$Companion_instance;
  }
  OnionClientAuth$PublicKey.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PublicKey',
    interfaces: [OnionClientAuth$Key]
  };
  function OnionClientAuth$PrivateKey() {
    OnionClientAuth$PrivateKey$Companion_getInstance();
  }
  function OnionClientAuth$PrivateKey$Companion() {
    OnionClientAuth$PrivateKey$Companion_instance = this;
  }
  OnionClientAuth$PrivateKey$Companion.prototype.fromString_61zpoe$ = function (key) {
    var limit = key.length;
    while (limit > 0) {
      var c = key.charCodeAt(limit - 1 | 0);
      if (c !== 61 && c !== 10 && c !== 13 && c !== 32 && c !== 9) {
        break;
      }
      limit = limit - 1 | 0;
    }
    var endIndex = limit;
    var $receiver = key.substring(0, endIndex);
    var tmp$;
    var stripped = trimStart(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : throwCCE()).toString();
    try {
      return OnionClientAuthPrivateKey_B64_X25519$Companion_getInstance().invoke_61zpoe$(stripped);
    } catch (_) {
      if (!Kotlin.isType(_, IllegalArgumentException))
        throw _;
    }
    try {
      return OnionClientAuthPrivateKey_B32_X25519$Companion_getInstance().invoke_61zpoe$(stripped);
    } catch (_) {
      if (!Kotlin.isType(_, IllegalArgumentException))
        throw _;
    }
    throw IllegalArgumentException_init('String was not a OnionClientAuth.PrivateKey');
  };
  OnionClientAuth$PrivateKey$Companion.prototype.fromStringOrNull_61zpoe$ = function (key) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(key);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  OnionClientAuth$PrivateKey$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionClientAuth$PrivateKey$Companion_instance = null;
  function OnionClientAuth$PrivateKey$Companion_getInstance() {
    if (OnionClientAuth$PrivateKey$Companion_instance === null) {
      new OnionClientAuth$PrivateKey$Companion();
    }
    return OnionClientAuth$PrivateKey$Companion_instance;
  }
  OnionClientAuth$PrivateKey.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PrivateKey',
    interfaces: [OnionClientAuth$Key]
  };
  function OnionClientAuth$KeyPair(publicKey, privateKey) {
    this.publicKey = publicKey;
    this.privateKey = privateKey;
  }
  OnionClientAuth$KeyPair.prototype.equals = function (other) {
    return other != null && Kotlin.isType(other, OnionClientAuth$KeyPair) && equals(other.publicKey, this.publicKey) && equals(other.privateKey, this.privateKey);
  };
  OnionClientAuth$KeyPair.prototype.hashCode = function () {
    var result = 17;
    result = (result * 31 | 0) + hashCode(this.publicKey) | 0;
    result = (result * 31 | 0) + hashCode(this.privateKey) | 0;
    return result;
  };
  OnionClientAuth$KeyPair.prototype.toString = function () {
    return 'KeyPair(publicKey=' + this.publicKey + ', privateKey=' + this.privateKey + ')';
  };
  OnionClientAuth$KeyPair.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KeyPair',
    interfaces: [Parcelable]
  };
  OnionClientAuth.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OnionClientAuth',
    interfaces: []
  };
  function OnionClientAuthPrivateKey_B32_X25519() {
    OnionClientAuthPrivateKey_B32_X25519$Companion_getInstance();
  }
  function OnionClientAuthPrivateKey_B32_X25519$Companion() {
    OnionClientAuthPrivateKey_B32_X25519$Companion_instance = this;
  }
  Object.defineProperty(OnionClientAuthPrivateKey_B32_X25519$Companion.prototype, 'REGEX', {
    configurable: true,
    get: function () {
      return Regex_init('[ABCDEFGHIJKLMNOPQRSTUVWXYZ234567]{52}');
    }
  });
  OnionClientAuthPrivateKey_B32_X25519$Companion.prototype.invoke_61zpoe$ = function (key) {
    return new RealOnionClientAuthPrivateKey_B32_X25519(key);
  };
  OnionClientAuthPrivateKey_B32_X25519$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionClientAuthPrivateKey_B32_X25519$Companion_instance = null;
  function OnionClientAuthPrivateKey_B32_X25519$Companion_getInstance() {
    if (OnionClientAuthPrivateKey_B32_X25519$Companion_instance === null) {
      new OnionClientAuthPrivateKey_B32_X25519$Companion();
    }
    return OnionClientAuthPrivateKey_B32_X25519$Companion_instance;
  }
  OnionClientAuthPrivateKey_B32_X25519.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionClientAuthPrivateKey_B32_X25519',
    interfaces: [OnionClientAuth$PrivateKey]
  };
  function RealOnionClientAuthPrivateKey_B32_X25519(value) {
    this.value_q6oeo$_0 = value;
    var $receiver = this.value;
    if (!OnionClientAuthPrivateKey_B32_X25519$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = "value=[REDACTED] was not a 52 character base32 encoded (w/o padding '=') String";
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealOnionClientAuthPrivateKey_B32_X25519.prototype, 'value', {
    get: function () {
      return this.value_q6oeo$_0;
    }
  });
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.base64_6taknv$$default = function (padded) {
    var tmp$;
    var bytes = encodeBase64ToByteArray(this.decode(), Base64.Default);
    var chars = Kotlin.charArray(bytes.length);
    for (var i = 0; i !== bytes.length; ++i) {
      var byte = bytes[i];
      chars[i] = toChar(byte);
    }
    var b64 = joinToString(chars, '');
    if (padded) {
      tmp$ = b64;
    } else {
      tmp$ = dropLast(b64, 1);
    }
    return tmp$;
  };
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.base32_6taknv$$default = function (padded) {
    var tmp$;
    if (padded) {
      tmp$ = this.value + '====';
    } else {
      tmp$ = this.value;
    }
    return tmp$;
  };
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.decode = function () {
    var $receiver = this.value;
    var base32 = Base32.Default;
    return ensureNotNull(decodeBase32ToArray(toCharArray($receiver), base32));
  };
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.descriptor_9vcohx$ = function (address) {
    return (new StringBuilder_init_0(address.value)).append_s8itvh$(58).append_s8jyv4$(this.keyType).append_s8itvh$(58).append_pdl1vj$(this.value).toString();
  };
  Object.defineProperty(RealOnionClientAuthPrivateKey_B32_X25519.prototype, 'keyType', {
    configurable: true,
    get: function () {
      return OnionClientAuth$Key$Type$x25519_getInstance();
    }
  });
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.toString = function () {
    return 'OnionClientAuthPrivateKey_B32_X25519(value=[REDACTED])';
  };
  RealOnionClientAuthPrivateKey_B32_X25519.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealOnionClientAuthPrivateKey_B32_X25519',
    interfaces: [OnionClientAuthPrivateKey_B32_X25519]
  };
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.unbox = function () {
    return this.value;
  };
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function OnionClientAuthPrivateKey_B64_X25519() {
    OnionClientAuthPrivateKey_B64_X25519$Companion_getInstance();
  }
  function OnionClientAuthPrivateKey_B64_X25519$Companion() {
    OnionClientAuthPrivateKey_B64_X25519$Companion_instance = this;
  }
  Object.defineProperty(OnionClientAuthPrivateKey_B64_X25519$Companion.prototype, 'REGEX', {
    configurable: true,
    get: function () {
      return Regex_init('[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/]{43}');
    }
  });
  OnionClientAuthPrivateKey_B64_X25519$Companion.prototype.invoke_61zpoe$ = function (key) {
    return new RealOnionClientAuthPrivateKey_B64_X25519(key);
  };
  OnionClientAuthPrivateKey_B64_X25519$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionClientAuthPrivateKey_B64_X25519$Companion_instance = null;
  function OnionClientAuthPrivateKey_B64_X25519$Companion_getInstance() {
    if (OnionClientAuthPrivateKey_B64_X25519$Companion_instance === null) {
      new OnionClientAuthPrivateKey_B64_X25519$Companion();
    }
    return OnionClientAuthPrivateKey_B64_X25519$Companion_instance;
  }
  OnionClientAuthPrivateKey_B64_X25519.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionClientAuthPrivateKey_B64_X25519',
    interfaces: [OnionClientAuth$PrivateKey]
  };
  function RealOnionClientAuthPrivateKey_B64_X25519(value) {
    this.value_p9f967$_0 = value;
    var $receiver = this.value;
    if (!OnionClientAuthPrivateKey_B64_X25519$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = "value=[REDACTED] was not a 43 character base64 encoded (w/o padding '=') String";
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealOnionClientAuthPrivateKey_B64_X25519.prototype, 'value', {
    get: function () {
      return this.value_p9f967$_0;
    }
  });
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.base64_6taknv$$default = function (padded) {
    var tmp$;
    if (padded) {
      tmp$ = this.value + '=';
    } else {
      tmp$ = this.value;
    }
    return tmp$;
  };
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.base32_6taknv$$default = function (padded) {
    var tmp$;
    var bytes = encodeBase32ToByteArray(this.decode(), Base32.Default);
    var chars = Kotlin.charArray(bytes.length);
    for (var i = 0; i !== bytes.length; ++i) {
      var byte = bytes[i];
      chars[i] = toChar(byte);
    }
    var b32 = joinToString(chars, '');
    if (padded) {
      tmp$ = b32;
    } else {
      tmp$ = dropLast(b32, 4);
    }
    return tmp$;
  };
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.decode = function () {
    return ensureNotNull(decodeBase64ToArray(toCharArray(this.value)));
  };
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.descriptor_9vcohx$ = function (address) {
    return (new StringBuilder_init_0(address.value)).append_s8itvh$(58).append_s8jyv4$(this.keyType).append_s8itvh$(58).append_pdl1vj$(this.value).toString();
  };
  Object.defineProperty(RealOnionClientAuthPrivateKey_B64_X25519.prototype, 'keyType', {
    configurable: true,
    get: function () {
      return OnionClientAuth$Key$Type$x25519_getInstance();
    }
  });
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.toString = function () {
    return 'OnionClientAuthPrivateKey_B64_X25519(value=[REDACTED])';
  };
  RealOnionClientAuthPrivateKey_B64_X25519.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealOnionClientAuthPrivateKey_B64_X25519',
    interfaces: [OnionClientAuthPrivateKey_B64_X25519]
  };
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.unbox = function () {
    return this.value;
  };
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function OnionClientAuthPublicKey_B32_X25519() {
    OnionClientAuthPublicKey_B32_X25519$Companion_getInstance();
  }
  function OnionClientAuthPublicKey_B32_X25519$Companion() {
    OnionClientAuthPublicKey_B32_X25519$Companion_instance = this;
  }
  OnionClientAuthPublicKey_B32_X25519$Companion.prototype.invoke_61zpoe$ = function (key) {
    return new RealOnionClientAuthPublicKey_B32_X25519(key);
  };
  OnionClientAuthPublicKey_B32_X25519$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionClientAuthPublicKey_B32_X25519$Companion_instance = null;
  function OnionClientAuthPublicKey_B32_X25519$Companion_getInstance() {
    if (OnionClientAuthPublicKey_B32_X25519$Companion_instance === null) {
      new OnionClientAuthPublicKey_B32_X25519$Companion();
    }
    return OnionClientAuthPublicKey_B32_X25519$Companion_instance;
  }
  OnionClientAuthPublicKey_B32_X25519.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionClientAuthPublicKey_B32_X25519',
    interfaces: [OnionClientAuth$PublicKey]
  };
  function RealOnionClientAuthPublicKey_B32_X25519(value) {
    this.value_k2yuk2$_0 = value;
    var $receiver = this.value;
    if (!OnionClientAuthPrivateKey_B32_X25519$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = this.value + " is not a 52 character base32 encoded (w/o padding '=') String";
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealOnionClientAuthPublicKey_B32_X25519.prototype, 'value', {
    get: function () {
      return this.value_k2yuk2$_0;
    }
  });
  RealOnionClientAuthPublicKey_B32_X25519.prototype.base64_6taknv$$default = function (padded) {
    var tmp$;
    var bytes = encodeBase64ToByteArray(this.decode(), Base64.Default);
    var chars = Kotlin.charArray(bytes.length);
    for (var i = 0; i !== bytes.length; ++i) {
      var byte = bytes[i];
      chars[i] = toChar(byte);
    }
    var b64 = joinToString(chars, '');
    if (padded) {
      tmp$ = b64;
    } else {
      tmp$ = dropLast(b64, 1);
    }
    return tmp$;
  };
  RealOnionClientAuthPublicKey_B32_X25519.prototype.base32_6taknv$$default = function (padded) {
    var tmp$;
    if (padded) {
      tmp$ = this.value + '====';
    } else {
      tmp$ = this.value;
    }
    return tmp$;
  };
  RealOnionClientAuthPublicKey_B32_X25519.prototype.decode = function () {
    var $receiver = this.value;
    var base32 = Base32.Default;
    return ensureNotNull(decodeBase32ToArray(toCharArray($receiver), base32));
  };
  RealOnionClientAuthPublicKey_B32_X25519.prototype.descriptor = function () {
    return (new StringBuilder_init_0(OnionClientAuth$PublicKey.Companion.DESCRIPTOR)).append_s8itvh$(58).append_s8jyv4$(this.keyType).append_s8itvh$(58).append_pdl1vj$(this.value).toString();
  };
  Object.defineProperty(RealOnionClientAuthPublicKey_B32_X25519.prototype, 'keyType', {
    configurable: true,
    get: function () {
      return OnionClientAuth$Key$Type$x25519_getInstance();
    }
  });
  RealOnionClientAuthPublicKey_B32_X25519.prototype.toString = function () {
    return 'OnionClientAuthPublicKey_B32_X25519(value=' + this.value + ')';
  };
  RealOnionClientAuthPublicKey_B32_X25519.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealOnionClientAuthPublicKey_B32_X25519',
    interfaces: [OnionClientAuthPublicKey_B32_X25519]
  };
  RealOnionClientAuthPublicKey_B32_X25519.prototype.unbox = function () {
    return this.value;
  };
  RealOnionClientAuthPublicKey_B32_X25519.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealOnionClientAuthPublicKey_B32_X25519.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function OnionClientAuthPublicKey_B64_X25519() {
    OnionClientAuthPublicKey_B64_X25519$Companion_getInstance();
  }
  function OnionClientAuthPublicKey_B64_X25519$Companion() {
    OnionClientAuthPublicKey_B64_X25519$Companion_instance = this;
  }
  OnionClientAuthPublicKey_B64_X25519$Companion.prototype.invoke_61zpoe$ = function (key) {
    return new RealOnionClientAuthPublicKey_B64_X25519(key);
  };
  OnionClientAuthPublicKey_B64_X25519$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OnionClientAuthPublicKey_B64_X25519$Companion_instance = null;
  function OnionClientAuthPublicKey_B64_X25519$Companion_getInstance() {
    if (OnionClientAuthPublicKey_B64_X25519$Companion_instance === null) {
      new OnionClientAuthPublicKey_B64_X25519$Companion();
    }
    return OnionClientAuthPublicKey_B64_X25519$Companion_instance;
  }
  OnionClientAuthPublicKey_B64_X25519.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'OnionClientAuthPublicKey_B64_X25519',
    interfaces: [OnionClientAuth$PublicKey]
  };
  function RealOnionClientAuthPublicKey_B64_X25519(value) {
    this.value_qewmnj$_0 = value;
    var $receiver = this.value;
    if (!OnionClientAuthPrivateKey_B64_X25519$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = this.value + " is not a 43 character base64 encoded (w/o padding '=') String";
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(RealOnionClientAuthPublicKey_B64_X25519.prototype, 'value', {
    get: function () {
      return this.value_qewmnj$_0;
    }
  });
  RealOnionClientAuthPublicKey_B64_X25519.prototype.base64_6taknv$$default = function (padded) {
    var tmp$;
    if (padded) {
      tmp$ = this.value + '=';
    } else {
      tmp$ = this.value;
    }
    return tmp$;
  };
  RealOnionClientAuthPublicKey_B64_X25519.prototype.base32_6taknv$$default = function (padded) {
    var tmp$;
    var bytes = encodeBase32ToByteArray(this.decode(), Base32.Default);
    var chars = Kotlin.charArray(bytes.length);
    for (var i = 0; i !== bytes.length; ++i) {
      var byte = bytes[i];
      chars[i] = toChar(byte);
    }
    var b32 = joinToString(chars, '');
    if (padded) {
      tmp$ = b32;
    } else {
      tmp$ = dropLast(b32, 4);
    }
    return tmp$;
  };
  RealOnionClientAuthPublicKey_B64_X25519.prototype.decode = function () {
    return ensureNotNull(decodeBase64ToArray(toCharArray(this.value)));
  };
  RealOnionClientAuthPublicKey_B64_X25519.prototype.descriptor = function () {
    return (new StringBuilder_init_0(OnionClientAuth$PublicKey.Companion.DESCRIPTOR)).append_s8itvh$(58).append_s8jyv4$(this.keyType).append_s8itvh$(58).append_pdl1vj$(this.value).toString();
  };
  Object.defineProperty(RealOnionClientAuthPublicKey_B64_X25519.prototype, 'keyType', {
    configurable: true,
    get: function () {
      return OnionClientAuth$Key$Type$x25519_getInstance();
    }
  });
  RealOnionClientAuthPublicKey_B64_X25519.prototype.toString = function () {
    return 'OnionClientAuthPublicKey_B64_X25519(value=' + this.value + ')';
  };
  RealOnionClientAuthPublicKey_B64_X25519.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealOnionClientAuthPublicKey_B64_X25519',
    interfaces: [OnionClientAuthPublicKey_B64_X25519]
  };
  RealOnionClientAuthPublicKey_B64_X25519.prototype.unbox = function () {
    return this.value;
  };
  RealOnionClientAuthPublicKey_B64_X25519.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  RealOnionClientAuthPublicKey_B64_X25519.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  var descriptorString = defineInlineFunction('kmp-tor-kmp-tor-common-js-legacy.io.matthewnelson.kmp.tor.common.internal.descriptorString_aqiq6v$', wrapFunction(function () {
    var StringBuilder_init = Kotlin.kotlin.text.StringBuilder;
    return function ($receiver, address) {
      return (new StringBuilder_init(address.value)).append_s8itvh$(58).append_s8jyv4$($receiver.keyType).append_s8itvh$(58).append_pdl1vj$($receiver.value).toString();
    };
  }));
  var descriptorString_0 = defineInlineFunction('kmp-tor-kmp-tor-common-js-legacy.io.matthewnelson.kmp.tor.common.internal.descriptorString_5m9pyo$', wrapFunction(function () {
    var OnionClientAuth$PublicKey = _.io.matthewnelson.kmp.tor.common.clientauth.OnionClientAuth.PublicKey;
    var StringBuilder_init = Kotlin.kotlin.text.StringBuilder;
    return function ($receiver) {
      return (new StringBuilder_init(OnionClientAuth$PublicKey.Companion.DESCRIPTOR)).append_s8itvh$(58).append_s8jyv4$($receiver.keyType).append_s8itvh$(58).append_pdl1vj$($receiver.value).toString();
    };
  }));
  var stripString = defineInlineFunction('kmp-tor-kmp-tor-common-js-legacy.io.matthewnelson.kmp.tor.common.internal.stripString_7efafi$', wrapFunction(function () {
    var throwCCE = Kotlin.throwCCE;
    var trimStart = Kotlin.kotlin.text.trimStart_gw00vp$;
    return function ($receiver) {
      var limit = $receiver.length;
      while (limit > 0) {
        var c = $receiver.charCodeAt(limit - 1 | 0);
        if (c !== 61 && c !== 10 && c !== 13 && c !== 32 && c !== 9) {
          break;
        }
        limit = limit - 1 | 0;
      }
      var endIndex = limit;
      var $receiver_0 = $receiver.substring(0, endIndex);
      var tmp$;
      return trimStart(Kotlin.isCharSequence(tmp$ = $receiver_0) ? tmp$ : throwCCE()).toString();
    };
  }));
  var separateSchemeFromAddress = defineInlineFunction('kmp-tor-kmp-tor-common-js-legacy.io.matthewnelson.kmp.tor.common.internal.separateSchemeFromAddress_7efafi$', wrapFunction(function () {
    var Scheme = _.io.matthewnelson.kmp.tor.common.address.Scheme;
    var Pair_init = Kotlin.kotlin.Pair;
    var throwCCE = Kotlin.throwCCE;
    var trim = Kotlin.kotlin.text.trim_gw00vp$;
    return function ($receiver) {
      var tmp$;
      var tmp$_0;
      var trimmed = trim(Kotlin.isCharSequence(tmp$_0 = $receiver) ? tmp$_0 : throwCCE()).toString();
      var scheme = Scheme.Companion.fromString_ivxn3r$(trimmed, false);
      if (scheme != null) {
        var startIndex = scheme.toString().length;
        tmp$ = trimmed.substring(startIndex);
      } else {
        tmp$ = trimmed;
      }
      return new Pair_init(scheme, tmp$);
    };
  }));
  var stripAddress = defineInlineFunction('kmp-tor-kmp-tor-common-js-legacy.io.matthewnelson.kmp.tor.common.internal.stripAddress_7efafi$', wrapFunction(function () {
    var substringBefore = Kotlin.kotlin.text.substringBefore_8cymmc$;
    var Scheme = _.io.matthewnelson.kmp.tor.common.address.Scheme;
    var Pair_init = Kotlin.kotlin.Pair;
    var throwCCE = Kotlin.throwCCE;
    var trim = Kotlin.kotlin.text.trim_gw00vp$;
    return function ($receiver) {
      var tmp$;
      var tmp$_0;
      var trimmed = trim(Kotlin.isCharSequence(tmp$_0 = $receiver) ? tmp$_0 : throwCCE()).toString();
      var scheme = Scheme.Companion.fromString_ivxn3r$(trimmed, false);
      if (scheme != null) {
        var startIndex = scheme.toString().length;
        tmp$ = trimmed.substring(startIndex);
      } else {
        tmp$ = trimmed;
      }
      return substringBefore((new Pair_init(scheme, tmp$)).second, 46);
    };
  }));
  function TorStrings() {
    TorStrings_instance = this;
    this.CLRF = '\r\n';
    this.MULTI_LINE_END = toBoxedChar(46);
    this.REDACTED = '[REDACTED]';
    this.SP = ' ';
  }
  TorStrings.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'TorStrings',
    interfaces: []
  };
  var TorStrings_instance = null;
  function TorStrings_getInstance() {
    if (TorStrings_instance === null) {
      new TorStrings();
    }
    return TorStrings_instance;
  }
  function Server() {
  }
  function Server$Fingerprint() {
    Server$Fingerprint$Companion_getInstance();
  }
  function Server$Fingerprint$Companion() {
    Server$Fingerprint$Companion_instance = this;
    this.PREFIX = toBoxedChar(36);
  }
  Object.defineProperty(Server$Fingerprint$Companion.prototype, 'REGEX', {
    configurable: true,
    get: function () {
      return Regex_init('[A-F0-9]{40}');
    }
  });
  Server$Fingerprint$Companion.prototype.invoke_61zpoe$ = function (value) {
    var tmp$;
    if (firstOrNull(value) === unboxChar(this.PREFIX)) {
      tmp$ = new Server$RealFingerprint(drop(value, 1));
    } else {
      tmp$ = new Server$RealFingerprint(value);
    }
    return tmp$;
  };
  Server$Fingerprint$Companion.prototype.fromStringOrNull_61zpoe$ = function (value) {
    var tmp$;
    try {
      tmp$ = this.invoke_61zpoe$(value);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  Server$Fingerprint$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Server$Fingerprint$Companion_instance = null;
  function Server$Fingerprint$Companion_getInstance() {
    if (Server$Fingerprint$Companion_instance === null) {
      new Server$Fingerprint$Companion();
    }
    return Server$Fingerprint$Companion_instance;
  }
  Server$Fingerprint.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Fingerprint',
    interfaces: [Parcelable]
  };
  function Server$RealFingerprint(value) {
    this.value_jh9puy$_0 = value;
    var $receiver = this.value;
    if (!Server$Fingerprint$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = this.value + ' is not a valid ServerSpec.Fingerprint';
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(Server$RealFingerprint.prototype, 'value', {
    get: function () {
      return this.value_jh9puy$_0;
    }
  });
  Object.defineProperty(Server$RealFingerprint.prototype, 'valueWithPrefix', {
    configurable: true,
    get: function () {
      return String.fromCharCode(unboxChar(Server$Fingerprint$Companion_getInstance().PREFIX)) + this.value;
    }
  });
  Server$RealFingerprint.prototype.decode = function () {
    return ensureNotNull(decodeBase16ToArray(toCharArray(this.value)));
  };
  Server$RealFingerprint.prototype.toString = function () {
    return 'Fingerprint(value=' + this.value + ')';
  };
  Server$RealFingerprint.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealFingerprint',
    interfaces: [Server$Fingerprint]
  };
  Server$RealFingerprint.prototype.unbox = function () {
    return this.value;
  };
  Server$RealFingerprint.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  Server$RealFingerprint.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function Server$Nickname() {
    Server$Nickname$Companion_getInstance();
  }
  function Server$Nickname$Companion() {
    Server$Nickname$Companion_instance = this;
  }
  Object.defineProperty(Server$Nickname$Companion.prototype, 'REGEX', {
    configurable: true,
    get: function () {
      return Regex_init('[' + dropLast(Base64.Default.CHARS, 2) + ']{1,19}');
    }
  });
  Server$Nickname$Companion.prototype.invoke_61zpoe$ = function (value) {
    return new Server$RealNickname(value);
  };
  Server$Nickname$Companion.prototype.fromStringOrNull_61zpoe$ = function (value) {
    var tmp$;
    try {
      tmp$ = new Server$RealNickname(value);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  Server$Nickname$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Server$Nickname$Companion_instance = null;
  function Server$Nickname$Companion_getInstance() {
    if (Server$Nickname$Companion_instance === null) {
      new Server$Nickname$Companion();
    }
    return Server$Nickname$Companion_instance;
  }
  Server$Nickname.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Nickname',
    interfaces: [Parcelable]
  };
  function Server$RealNickname(value) {
    this.value_aq999q$_0 = value;
    var $receiver = this.value;
    if (!Server$Nickname$Companion_getInstance().REGEX.matches_6bul2c$($receiver)) {
      var message = this.value + ' is not a valid Server.Nickname';
      throw IllegalArgumentException_init(message.toString());
    }
  }
  Object.defineProperty(Server$RealNickname.prototype, 'value', {
    get: function () {
      return this.value_aq999q$_0;
    }
  });
  Server$RealNickname.prototype.toString = function () {
    return 'Nickname(value=' + this.value + ')';
  };
  Server$RealNickname.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealNickname',
    interfaces: [Server$Nickname]
  };
  Server$RealNickname.prototype.unbox = function () {
    return this.value;
  };
  Server$RealNickname.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  Server$RealNickname.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function Server$LongName(fingerprint, nickname) {
    Server$LongName$Companion_getInstance();
    this.fingerprint = fingerprint;
    this.nickname = nickname;
  }
  Server$LongName.prototype.toString = function () {
    var tmp$;
    if (this.nickname != null) {
      tmp$ = this.fingerprint.valueWithPrefix + String.fromCharCode(unboxChar(Server$LongName$Companion_getInstance().DELIMITER)) + this.nickname.value;
    } else {
      tmp$ = this.fingerprint.valueWithPrefix;
    }
    return tmp$;
  };
  function Server$LongName$Companion() {
    Server$LongName$Companion_instance = this;
    this.DELIMITER = toBoxedChar(126);
  }
  Server$LongName$Companion.prototype.fromString_61zpoe$ = function (value) {
    var tmp$, tmp$_0;
    if (contains(value, unboxChar(this.DELIMITER))) {
      tmp$ = unboxChar(this.DELIMITER);
    } else if (contains(value, 61)) {
      tmp$ = 61;
    } else {
      tmp$ = null;
    }
    var delimiter = tmp$;
    if (delimiter == null) {
      tmp$_0 = new Server$LongName(Server$Fingerprint$Companion_getInstance().invoke_61zpoe$(value), null);
    } else {
      tmp$_0 = new Server$LongName(Server$Fingerprint$Companion_getInstance().invoke_61zpoe$(substringBefore(value, delimiter)), Server$Nickname$Companion_getInstance().invoke_61zpoe$(substringAfter(value, delimiter)));
    }
    return tmp$_0;
  };
  Server$LongName$Companion.prototype.fromStringOrNull_61zpoe$ = function (value) {
    var tmp$;
    try {
      tmp$ = this.fromString_61zpoe$(value);
    } catch (_) {
      if (Kotlin.isType(_, IllegalArgumentException)) {
        tmp$ = null;
      } else
        throw _;
    }
    return tmp$;
  };
  Server$LongName$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Server$LongName$Companion_instance = null;
  function Server$LongName$Companion_getInstance() {
    if (Server$LongName$Companion_instance === null) {
      new Server$LongName$Companion();
    }
    return Server$LongName$Companion_instance;
  }
  Server$LongName.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LongName',
    interfaces: [Parcelable]
  };
  Server$LongName.prototype.component1 = function () {
    return this.fingerprint;
  };
  Server$LongName.prototype.component2 = function () {
    return this.nickname;
  };
  Server$LongName.prototype.copy_jor593$ = function (fingerprint, nickname) {
    return new Server$LongName(fingerprint === void 0 ? this.fingerprint : fingerprint, nickname === void 0 ? this.nickname : nickname);
  };
  Server$LongName.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.fingerprint) | 0;
    result = result * 31 + Kotlin.hashCode(this.nickname) | 0;
    return result;
  };
  Server$LongName.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.fingerprint, other.fingerprint) && Kotlin.equals(this.nickname, other.nickname)))));
  };
  Server.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Server',
    interfaces: []
  };
  $$importsForInline$$['kmp-tor-kmp-tor-common-js-legacy'] = _;
  Object.defineProperty(OnionAddress, 'Companion', {
    get: OnionAddress$Companion_getInstance
  });
  Object.defineProperty(OnionAddress$PrivateKey, 'Companion', {
    get: OnionAddress$PrivateKey$Companion_getInstance
  });
  Object.defineProperty(OnionAddress$PrivateKey$Type, 'Companion', {
    get: OnionAddress$PrivateKey$Type$Companion_getInstance
  });
  Object.defineProperty(OnionAddress$PrivateKey$Type, 'ED25519_V3', {
    get: OnionAddress$PrivateKey$Type$ED25519_V3_getInstance
  });
  OnionAddress$PrivateKey.Type = OnionAddress$PrivateKey$Type;
  OnionAddress.PrivateKey = OnionAddress$PrivateKey;
  var package$io = _.io || (_.io = {});
  var package$matthewnelson = package$io.matthewnelson || (package$io.matthewnelson = {});
  var package$kmp = package$matthewnelson.kmp || (package$matthewnelson.kmp = {});
  var package$tor = package$kmp.tor || (package$kmp.tor = {});
  var package$common = package$tor.common || (package$tor.common = {});
  var package$address = package$common.address || (package$common.address = {});
  package$address.OnionAddress = OnionAddress;
  Object.defineProperty(OnionAddressV3, 'Companion', {
    get: OnionAddressV3$Companion_getInstance
  });
  package$address.OnionAddressV3 = OnionAddressV3;
  $$importsForInline$$['component-encoding-encoding-base32-js-legacy'] = $module$component_encoding_encoding_base32_js_legacy;
  Object.defineProperty(OnionAddressV3PrivateKey_ED25519, 'Companion', {
    get: OnionAddressV3PrivateKey_ED25519$Companion_getInstance
  });
  package$address.OnionAddressV3PrivateKey_ED25519 = OnionAddressV3PrivateKey_ED25519;
  $$importsForInline$$['component-encoding-encoding-base64-js-legacy'] = $module$component_encoding_encoding_base64_js_legacy;
  Object.defineProperty(OnionUrl, 'Companion', {
    get: OnionUrl$Companion_getInstance
  });
  package$address.OnionUrl = OnionUrl;
  Object.defineProperty(Port, 'Companion', {
    get: Port$Companion_getInstance
  });
  package$address.Port = Port;
  Object.defineProperty(PortProxy, 'Companion', {
    get: PortProxy$Companion_getInstance
  });
  package$address.PortProxy = PortProxy;
  Object.defineProperty(ProxyAddress, 'Companion', {
    get: ProxyAddress$Companion_getInstance
  });
  package$address.ProxyAddress = ProxyAddress;
  Object.defineProperty(Scheme, 'HTTP', {
    get: Scheme$HTTP_getInstance
  });
  Object.defineProperty(Scheme, 'HTTPS', {
    get: Scheme$HTTPS_getInstance
  });
  Object.defineProperty(Scheme, 'WS', {
    get: Scheme$WS_getInstance
  });
  Object.defineProperty(Scheme, 'WSS', {
    get: Scheme$WSS_getInstance
  });
  Object.defineProperty(Scheme, 'Companion', {
    get: Scheme$Companion_getInstance
  });
  package$address.Scheme = Scheme;
  var package$annotation = package$common.annotation || (package$common.annotation = {});
  package$annotation.ExperimentalTorApi = ExperimentalTorApi;
  package$annotation.InternalTorApi = InternalTorApi;
  package$annotation.SealedValueClass = SealedValueClass;
  Object.defineProperty(ClientName, 'Companion', {
    get: ClientName$Companion_getInstance
  });
  var package$clientauth = package$common.clientauth || (package$common.clientauth = {});
  package$clientauth.ClientName = ClientName;
  Object.defineProperty(OnionClientAuth$Key$Type, 'x25519', {
    get: OnionClientAuth$Key$Type$x25519_getInstance
  });
  OnionClientAuth$Key.Type = OnionClientAuth$Key$Type;
  OnionClientAuth.Key = OnionClientAuth$Key;
  Object.defineProperty(OnionClientAuth$PublicKey, 'Companion', {
    get: OnionClientAuth$PublicKey$Companion_getInstance
  });
  OnionClientAuth.PublicKey = OnionClientAuth$PublicKey;
  Object.defineProperty(OnionClientAuth$PrivateKey, 'Companion', {
    get: OnionClientAuth$PrivateKey$Companion_getInstance
  });
  OnionClientAuth.PrivateKey = OnionClientAuth$PrivateKey;
  OnionClientAuth.KeyPair = OnionClientAuth$KeyPair;
  package$clientauth.OnionClientAuth = OnionClientAuth;
  Object.defineProperty(OnionClientAuthPrivateKey_B32_X25519, 'Companion', {
    get: OnionClientAuthPrivateKey_B32_X25519$Companion_getInstance
  });
  package$clientauth.OnionClientAuthPrivateKey_B32_X25519 = OnionClientAuthPrivateKey_B32_X25519;
  Object.defineProperty(OnionClientAuthPrivateKey_B64_X25519, 'Companion', {
    get: OnionClientAuthPrivateKey_B64_X25519$Companion_getInstance
  });
  package$clientauth.OnionClientAuthPrivateKey_B64_X25519 = OnionClientAuthPrivateKey_B64_X25519;
  Object.defineProperty(OnionClientAuthPublicKey_B32_X25519, 'Companion', {
    get: OnionClientAuthPublicKey_B32_X25519$Companion_getInstance
  });
  package$clientauth.OnionClientAuthPublicKey_B32_X25519 = OnionClientAuthPublicKey_B32_X25519;
  Object.defineProperty(OnionClientAuthPublicKey_B64_X25519, 'Companion', {
    get: OnionClientAuthPublicKey_B64_X25519$Companion_getInstance
  });
  package$clientauth.OnionClientAuthPublicKey_B64_X25519 = OnionClientAuthPublicKey_B64_X25519;
  var package$internal = package$common.internal || (package$common.internal = {});
  package$internal.descriptorString_aqiq6v$ = descriptorString;
  package$internal.descriptorString_5m9pyo$ = descriptorString_0;
  package$internal.stripString_7efafi$ = stripString;
  package$internal.separateSchemeFromAddress_7efafi$ = separateSchemeFromAddress;
  package$internal.stripAddress_7efafi$ = stripAddress;
  Object.defineProperty(package$internal, 'TorStrings', {
    get: TorStrings_getInstance
  });
  Object.defineProperty(Server$Fingerprint, 'Companion', {
    get: Server$Fingerprint$Companion_getInstance
  });
  Server.Fingerprint = Server$Fingerprint;
  $$importsForInline$$['component-encoding-encoding-base16-js-legacy'] = $module$component_encoding_encoding_base16_js_legacy;
  Object.defineProperty(Server$Nickname, 'Companion', {
    get: Server$Nickname$Companion_getInstance
  });
  Server.Nickname = Server$Nickname;
  Object.defineProperty(Server$LongName, 'Companion', {
    get: Server$LongName$Companion_getInstance
  });
  Server.LongName = Server$LongName;
  var package$server = package$common.server || (package$common.server = {});
  package$server.Server = Server;
  OnionClientAuth$PublicKey.prototype.base64_6taknv$ = OnionClientAuth$Key.prototype.base64_6taknv$;
  OnionClientAuth$PublicKey.prototype.base32_6taknv$ = OnionClientAuth$Key.prototype.base32_6taknv$;
  OnionClientAuth$PrivateKey.prototype.base64_6taknv$ = OnionClientAuth$Key.prototype.base64_6taknv$;
  OnionClientAuth$PrivateKey.prototype.base32_6taknv$ = OnionClientAuth$Key.prototype.base32_6taknv$;
  OnionClientAuthPrivateKey_B32_X25519.prototype.base64_6taknv$ = OnionClientAuth$PrivateKey.prototype.base64_6taknv$;
  OnionClientAuthPrivateKey_B32_X25519.prototype.base32_6taknv$ = OnionClientAuth$PrivateKey.prototype.base32_6taknv$;
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.base64_6taknv$ = OnionClientAuthPrivateKey_B32_X25519.prototype.base64_6taknv$;
  RealOnionClientAuthPrivateKey_B32_X25519.prototype.base32_6taknv$ = OnionClientAuthPrivateKey_B32_X25519.prototype.base32_6taknv$;
  OnionClientAuthPrivateKey_B64_X25519.prototype.base64_6taknv$ = OnionClientAuth$PrivateKey.prototype.base64_6taknv$;
  OnionClientAuthPrivateKey_B64_X25519.prototype.base32_6taknv$ = OnionClientAuth$PrivateKey.prototype.base32_6taknv$;
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.base64_6taknv$ = OnionClientAuthPrivateKey_B64_X25519.prototype.base64_6taknv$;
  RealOnionClientAuthPrivateKey_B64_X25519.prototype.base32_6taknv$ = OnionClientAuthPrivateKey_B64_X25519.prototype.base32_6taknv$;
  OnionClientAuthPublicKey_B32_X25519.prototype.base64_6taknv$ = OnionClientAuth$PublicKey.prototype.base64_6taknv$;
  OnionClientAuthPublicKey_B32_X25519.prototype.base32_6taknv$ = OnionClientAuth$PublicKey.prototype.base32_6taknv$;
  RealOnionClientAuthPublicKey_B32_X25519.prototype.base64_6taknv$ = OnionClientAuthPublicKey_B32_X25519.prototype.base64_6taknv$;
  RealOnionClientAuthPublicKey_B32_X25519.prototype.base32_6taknv$ = OnionClientAuthPublicKey_B32_X25519.prototype.base32_6taknv$;
  OnionClientAuthPublicKey_B64_X25519.prototype.base64_6taknv$ = OnionClientAuth$PublicKey.prototype.base64_6taknv$;
  OnionClientAuthPublicKey_B64_X25519.prototype.base32_6taknv$ = OnionClientAuth$PublicKey.prototype.base32_6taknv$;
  RealOnionClientAuthPublicKey_B64_X25519.prototype.base64_6taknv$ = OnionClientAuthPublicKey_B64_X25519.prototype.base64_6taknv$;
  RealOnionClientAuthPublicKey_B64_X25519.prototype.base32_6taknv$ = OnionClientAuthPublicKey_B64_X25519.prototype.base32_6taknv$;
  Kotlin.defineModule('kmp-tor-kmp-tor-common-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kmp-tor-kmp-tor-common-js-legacy.js.map
