/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.controller.internal.controller;

import io.matthewnelson.kmp.tor.controller.common.events.TorEvent;
import io.matthewnelson.kmp.tor.controller.internal.DebugItem;
import io.matthewnelson.kmp.tor.controller.internal.controller.ListenersHandler;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\rJ4\u0010\u001c\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00182\u001d\u0010\u001b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0019\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\b\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR#\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lio/matthewnelson/kmp/tor/controller/internal/controller/RealListenersHandler;", "", "initialCapacity", "Lkotlin/Function1;", "Lio/matthewnelson/kmp/tor/controller/internal/DebugItem$ListenerError;", "", "debugger", "<init>", "(ILkotlin/jvm/functions/Function1;)V", "Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent$SealedListener;", "listener", "", "addListener", "(Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent$SealedListener;)Z", "Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent$Type$MultiLineEvent;", "event", "", "", "output", "notify", "(Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent$Type$MultiLineEvent;Ljava/util/List;)V", "Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent$Type$SingleLineEvent;", "(Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent$Type$SingleLineEvent;Ljava/lang/String;)V", "removeListener", "T", "", "Lkotlin/ExtensionFunctionType;", "action", "withLock", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/jvm/functions/Function1;", "getDebugger", "()Lkotlin/jvm/functions/Function1;", "isEmpty", "()Z", "set", "Ljava/util/Set;", "kmp-tor-controller", "Lio/matthewnelson/kmp/tor/controller/internal/controller/ListenersHandler;"})
final class RealListenersHandler
implements ListenersHandler {
    @NotNull
    private final Function1<DebugItem.ListenerError, Unit> debugger;
    @NotNull
    private final Set<TorEvent.SealedListener> set;

    public RealListenersHandler(int initialCapacity, @NotNull Function1<? super DebugItem.ListenerError, Unit> debugger) {
        Intrinsics.checkNotNullParameter(debugger, (String)"debugger");
        this.debugger = debugger;
        if (!(initialCapacity >= 0)) {
            boolean bl = false;
            String string = "ListenersHandler.initialCapacity must be greater than or equal to 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.set = new LinkedHashSet(initialCapacity);
    }

    @NotNull
    public final Function1<DebugItem.ListenerError, Unit> getDebugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withLock(@NotNull Function1<? super Set<TorEvent.SealedListener>, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        RealListenersHandler realListenersHandler = this;
        synchronized (realListenersHandler) {
            boolean bl = false;
            object = action.invoke(this.set);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean bl;
        RealListenersHandler realListenersHandler = this;
        synchronized (realListenersHandler) {
            boolean bl2 = false;
            bl = this.set.isEmpty();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(@NotNull TorEvent.SealedListener listener) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        RealListenersHandler realListenersHandler = this;
        synchronized (realListenersHandler) {
            boolean bl2 = false;
            bl = this.set.add(listener);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(@NotNull TorEvent.SealedListener listener) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        RealListenersHandler realListenersHandler = this;
        synchronized (realListenersHandler) {
            boolean bl2 = false;
            bl = this.set.remove(listener);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(@NotNull TorEvent.Type.SingleLineEvent event, @NotNull String output) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        RealListenersHandler realListenersHandler = this;
        synchronized (realListenersHandler) {
            boolean bl = false;
            for (TorEvent.SealedListener listener : this.set) {
                try {
                    listener.onEvent(event, output);
                }
                catch (Exception e) {
                    this.debugger.invoke((Object)new DebugItem.ListenerError(listener, DebugItem.Error.constructor-impl(e), null));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(@NotNull TorEvent.Type.MultiLineEvent event, @NotNull List<String> output) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(output, (String)"output");
        RealListenersHandler realListenersHandler = this;
        synchronized (realListenersHandler) {
            boolean bl = false;
            for (TorEvent.SealedListener listener : this.set) {
                try {
                    listener.onEvent(event, output);
                }
                catch (Exception e) {
                    this.debugger.invoke((Object)new DebugItem.ListenerError(listener, DebugItem.Error.constructor-impl(e), null));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

