/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.manager.instance;

import io.matthewnelson.kmp.tor.controller.common.events.TorEvent;
import io.matthewnelson.kmp.tor.manager.KmpTorLoader;
import io.matthewnelson.kmp.tor.manager.NetworkObserver;
import io.matthewnelson.kmp.tor.manager.TorManager;
import io.matthewnelson.kmp.tor.manager.TorManagerKt;
import io.matthewnelson.kmp.tor.manager.instance.InstanceId;
import io.matthewnelson.kmp.tor.manager.internal.util.SynchronizedMutableMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0007J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/matthewnelson/kmp/tor/manager/instance/TorMultiInstanceManager;", "", "()V", "instanceLockMap", "Lio/matthewnelson/kmp/tor/manager/internal/util/SynchronizedMutableMap;", "Lio/matthewnelson/kmp/tor/manager/instance/TorMultiInstanceManager$InstanceLockHolder;", "newTorManagerInstance", "Lio/matthewnelson/kmp/tor/manager/TorManager;", "instanceId", "Lio/matthewnelson/kmp/tor/manager/instance/InstanceId;", "loader", "Lio/matthewnelson/kmp/tor/manager/KmpTorLoader;", "networkObserver", "Lio/matthewnelson/kmp/tor/manager/NetworkObserver;", "requiredEvents", "", "Lio/matthewnelson/kmp/tor/controller/common/events/TorEvent;", "removeLockForInstanceId", "", "removeLockForInstanceId$kmp_tor_manager", "InstanceLockHolder", "kmp-tor-manager"})
public final class TorMultiInstanceManager {
    @NotNull
    public static final TorMultiInstanceManager INSTANCE = new TorMultiInstanceManager();
    @NotNull
    private static final SynchronizedMutableMap<InstanceLockHolder> instanceLockMap = new SynchronizedMutableMap();

    private TorMultiInstanceManager() {
    }

    @JvmStatic
    @NotNull
    public static final TorManager newTorManagerInstance(@NotNull InstanceId instanceId, @NotNull KmpTorLoader loader2, @Nullable NetworkObserver networkObserver, @Nullable Set<? extends TorEvent> requiredEvents) {
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Intrinsics.checkNotNullParameter((Object)loader2, (String)"loader");
        Mutex instanceLock2 = (Mutex)instanceLockMap.withLock((Function1)new Function1<Map<String, InstanceLockHolder>, Mutex>(instanceId){
            final /* synthetic */ InstanceId $instanceId;
            {
                this.$instanceId = $instanceId;
                super(1);
            }

            @NotNull
            public final Mutex invoke(@NotNull Map<String, InstanceLockHolder> $this$withLock) {
                Mutex mutex;
                Intrinsics.checkNotNullParameter($this$withLock, (String)"$this$withLock");
                InstanceLockHolder holder = $this$withLock.get(this.$instanceId.getValue());
                if (holder == null) {
                    InstanceLockHolder newHolder = new InstanceLockHolder(1, MutexKt.Mutex$default((boolean)false, (int)1, null));
                    $this$withLock.put(this.$instanceId.getValue(), newHolder);
                    mutex = newHolder.getLock();
                } else {
                    $this$withLock.put(this.$instanceId.getValue(), InstanceLockHolder.copy$default(holder, holder.getInstanceCount() + 1, null, 2, null));
                    mutex = holder.getLock();
                }
                return mutex;
            }
        });
        return TorManagerKt.realTorManager$default(loader2, instanceId.getValue(), instanceLock2, null, networkObserver, requiredEvents, 8, null);
    }

    public static /* synthetic */ TorManager newTorManagerInstance$default(InstanceId instanceId, KmpTorLoader kmpTorLoader, NetworkObserver networkObserver, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            networkObserver = null;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return TorMultiInstanceManager.newTorManagerInstance(instanceId, kmpTorLoader, networkObserver, set);
    }

    public final /* synthetic */ void removeLockForInstanceId$kmp_tor_manager(InstanceId instanceId) {
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        instanceLockMap.withLock((Function1)new Function1<Map<String, InstanceLockHolder>, Unit>(instanceId){
            final /* synthetic */ InstanceId $instanceId;
            {
                this.$instanceId = $instanceId;
                super(1);
            }

            public final void invoke(@NotNull Map<String, InstanceLockHolder> $this$withLock) {
                Intrinsics.checkNotNullParameter($this$withLock, (String)"$this$withLock");
                InstanceLockHolder instanceLockHolder = $this$withLock.remove(this.$instanceId.getValue());
                if (instanceLockHolder == null) {
                    return;
                }
                InstanceLockHolder holder = instanceLockHolder;
                if (holder.getInstanceCount() > 1) {
                    $this$withLock.put(this.$instanceId.getValue(), InstanceLockHolder.copy$default(holder, holder.getInstanceCount() - 1, null, 2, null));
                } else {
                    KmpTorLoader.Companion.removeInstanceRunLock$kmp_tor_manager(this.$instanceId.getValue());
                }
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/kmp/tor/manager/instance/TorMultiInstanceManager$InstanceLockHolder;", "", "instanceCount", "", "lock", "Lkotlinx/coroutines/sync/Mutex;", "(ILkotlinx/coroutines/sync/Mutex;)V", "getInstanceCount", "()I", "getLock", "()Lkotlinx/coroutines/sync/Mutex;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "kmp-tor-manager"})
    private static final class InstanceLockHolder {
        private final int instanceCount;
        @NotNull
        private final Mutex lock;

        public InstanceLockHolder(int instanceCount, @NotNull Mutex lock) {
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            this.instanceCount = instanceCount;
            this.lock = lock;
        }

        public final int getInstanceCount() {
            return this.instanceCount;
        }

        @NotNull
        public final Mutex getLock() {
            return this.lock;
        }

        public final int component1() {
            return this.instanceCount;
        }

        @NotNull
        public final Mutex component2() {
            return this.lock;
        }

        @NotNull
        public final InstanceLockHolder copy(int instanceCount, @NotNull Mutex lock) {
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            return new InstanceLockHolder(instanceCount, lock);
        }

        public static /* synthetic */ InstanceLockHolder copy$default(InstanceLockHolder instanceLockHolder, int n, Mutex mutex, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = instanceLockHolder.instanceCount;
            }
            if ((n2 & 2) != 0) {
                mutex = instanceLockHolder.lock;
            }
            return instanceLockHolder.copy(n, mutex);
        }

        @NotNull
        public String toString() {
            return "InstanceLockHolder(instanceCount=" + this.instanceCount + ", lock=" + this.lock + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.instanceCount);
            result2 = result2 * 31 + this.lock.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstanceLockHolder)) {
                return false;
            }
            InstanceLockHolder instanceLockHolder = (InstanceLockHolder)other;
            if (this.instanceCount != instanceLockHolder.instanceCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lock, (Object)instanceLockHolder.lock);
        }
    }
}

