/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.manager.internal.util;

import io.matthewnelson.kmp.tor.common.address.Port;
import io.matthewnelson.kmp.tor.controller.common.config.TorConfig;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/matthewnelson/kmp/tor/manager/internal/util/PortValidator;", "", "()V", "configPorts", "", "Lio/matthewnelson/kmp/tor/controller/common/config/TorConfig$Setting$Ports;", "<set-?>", "", "hasControlPort", "getHasControlPort", "()Z", "hasSocksPort", "getHasSocksPort", "add", "", "port", "validate", "", "isPortAvailable", "Lkotlin/Function1;", "Lio/matthewnelson/kmp/tor/common/address/Port;", "kmp-tor-manager"})
public final class PortValidator {
    @NotNull
    private final Set<TorConfig.Setting.Ports> configPorts = new LinkedHashSet();
    private boolean hasControlPort;
    private boolean hasSocksPort;

    public final boolean getHasControlPort() {
        return this.hasControlPort;
    }

    public final boolean getHasSocksPort() {
        return this.hasSocksPort;
    }

    public final void add(@NotNull TorConfig.Setting.Ports port) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        if (port instanceof TorConfig.Setting.Ports.Control) {
            this.hasControlPort = true;
        } else if (port instanceof TorConfig.Setting.Ports.Socks) {
            this.hasSocksPort = true;
        }
        this.configPorts.add(port);
    }

    @NotNull
    public final Set<TorConfig.Setting.Ports> validate(@NotNull Function1<? super Port, Boolean> isPortAvailable) {
        Intrinsics.checkNotNullParameter(isPortAvailable, (String)"isPortAvailable");
        if (!this.hasSocksPort) {
            TorConfig.Setting.Ports.Socks socks = new TorConfig.Setting.Ports.Socks();
            if (!this.configPorts.add((TorConfig.Setting.Ports)socks)) {
                socks.set((TorConfig.Option)TorConfig.Option.AorDorPort.Auto.INSTANCE);
                this.configPorts.add((TorConfig.Setting.Ports)socks);
            }
            this.hasSocksPort = true;
        }
        Set validatedPorts = new LinkedHashSet();
        for (TorConfig.Setting.Ports port : this.configPorts) {
            TorConfig.Option.AorDorPort option = (TorConfig.Option.AorDorPort)port.getValue();
            if (option instanceof TorConfig.Option.AorDorPort.Auto ? true : option instanceof TorConfig.Option.AorDorPort.Disable) {
                validatedPorts.add(port);
                continue;
            }
            if (!(option instanceof TorConfig.Option.AorDorPort.Value)) continue;
            if (((Boolean)isPortAvailable.invoke((Object)Port.Companion.invoke(((TorConfig.Option.AorDorPort.Value)option).getPort().getValue()))).booleanValue()) {
                validatedPorts.add(port);
                continue;
            }
            validatedPorts.add((TorConfig.Setting.Ports)port.clone().set((TorConfig.Option)TorConfig.Option.AorDorPort.Auto.INSTANCE));
        }
        if (!this.hasControlPort) {
            validatedPorts.add((TorConfig.Setting.Ports)new TorConfig.Setting.Ports.Control().set((TorConfig.Option)TorConfig.Option.AorDorPort.Auto.INSTANCE));
        }
        return validatedPorts;
    }
}

