/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.manager.util;

import io.matthewnelson.kmp.tor.common.address.Port;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lio/matthewnelson/kmp/tor/manager/util/PortUtil;", "", "()V", "findNextAvailableTcpPort", "Lio/matthewnelson/kmp/tor/common/address/Port;", "port", "limit", "", "isTcpPortAvailable", "", "realIsTcpPortAvailable", "", "kmp-tor-manager"})
public final class PortUtil {
    @NotNull
    public static final PortUtil INSTANCE = new PortUtil();

    private PortUtil() {
    }

    @JvmStatic
    public static final boolean isTcpPortAvailable(@NotNull Port port) throws RuntimeException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        try {
            INSTANCE.realIsTcpPortAvailable(port.getValue());
            bl = true;
        }
        catch (Exception e) {
            if (Intrinsics.areEqual((Object)e.toString(), (Object)"android.os.NetworkOnMainThreadException")) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Port findNextAvailableTcpPort(@NotNull Port port, int limit) throws RuntimeException {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        if (!(1 <= limit ? limit < 65536 : false)) {
            throw new RuntimeException("limit must be greater than or equal to 1");
        }
        int currentPort = port.getValue() == 0 ? 1 : port.getValue();
        for (int countDown = limit; countDown >= 0; --countDown) {
            try {
                INSTANCE.realIsTcpPortAvailable(currentPort);
                return Port.Companion.invoke(currentPort);
            }
            catch (Exception e) {
                if (Intrinsics.areEqual((Object)e.toString(), (Object)"android.os.NetworkOnMainThreadException")) {
                    throw e;
                }
                currentPort = currentPort == 65535 ? 1 : currentPort + 1;
                continue;
            }
        }
        throw new RuntimeException("Failed to find an available Port");
    }

    private final void realIsTcpPortAvailable(int port) throws Exception {
        ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
        serverSocket.close();
    }
}

