/*
 * Copyright (c) 2021 Matthew Nelson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
package io.matthewnelson.kmp.tor.manager.internal.actions

import io.matthewnelson.kmp.tor.manager.common.event.TorManagerEvent.Action
import kotlinx.coroutines.Job

internal class ActionHolder(val action: Action, val job: Job) {

    override fun equals(other: Any?): Boolean {
        return  other != null           &&
                other is ActionHolder   &&
                other.action == action  &&
                other.job == job
    }

    override fun hashCode(): Int {
        var result = 17
        result = result * 31 + action.hashCode()
        result = result * 31 + job.hashCode()
        return result
    }

    override fun toString(): String {
        return "ActionHolder(action=$action,job=$job)"
    }
}
