/*
 * Decompiled with CFR 0.152.
 */
package io.mcarle.konvert.converter;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeParameter;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.Variance;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import io.mcarle.konvert.converter.api.AbstractTypeConverter;
import io.mcarle.konvert.converter.api.ExtensionsKt;
import io.mcarle.konvert.converter.api.TypeConverter;
import io.mcarle.konvert.converter.api.TypeConverterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0003H&J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nH\u0016J\f\u0010#\u001a\u00020\u0006*\u00020\nH\u0002J\f\u0010$\u001a\u00020\u0006*\u00020\nH\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0017\u0010\f\u00a8\u0006&"}, d2={"Lio/mcarle/konvert/converter/IterableToXConverter;", "Lio/mcarle/konvert/converter/api/AbstractTypeConverter;", "targetFQN", "", "(Ljava/lang/String;)V", "enabledByDefault", "", "getEnabledByDefault", "()Z", "iterableType", "Lcom/google/devtools/ksp/symbol/KSType;", "getIterableType", "()Lcom/google/devtools/ksp/symbol/KSType;", "iterableType$delegate", "Lkotlin/Lazy;", "targetClassDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "getTargetClassDeclaration", "()Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "targetClassDeclaration$delegate", "getTargetFQN", "()Ljava/lang/String;", "targetType", "getTargetType", "targetType$delegate", "convert", "Lcom/squareup/kotlinpoet/CodeBlock;", "fieldName", "source", "target", "convertIterable", "nc", "matches", "matchesTarget", "listTypeChanged", "isExactlyTarget", "isInstanceOfTarget", "Companion", "converter"})
@SourceDebugExtension(value={"SMAP\nIterableToXConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IterableToXConverter.kt\nio/mcarle/konvert/converter/IterableToXConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,290:1\n1747#2,3:291\n223#2,2:294\n37#3,2:296\n*S KotlinDebug\n*F\n+ 1 IterableToXConverter.kt\nio/mcarle/konvert/converter/IterableToXConverter\n*L\n78#1:291,3\n96#1:294,2\n145#1:296,2\n*E\n"})
public abstract class IterableToXConverter
extends AbstractTypeConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String targetFQN;
    @NotNull
    private final Lazy iterableType$delegate;
    @NotNull
    private final Lazy targetClassDeclaration$delegate;
    @NotNull
    private final Lazy targetType$delegate;
    private final boolean enabledByDefault;

    public IterableToXConverter(@NotNull String targetFQN) {
        Intrinsics.checkNotNullParameter((Object)targetFQN, (String)"targetFQN");
        super(null, 1, null);
        this.targetFQN = targetFQN;
        this.iterableType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KSType>(this){
            final /* synthetic */ IterableToXConverter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KSType invoke() {
                return IterableToXConverter.access$getResolver(this.this$0).getBuiltIns().getIterableType();
            }
        }));
        this.targetClassDeclaration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KSClassDeclaration>(this){
            final /* synthetic */ IterableToXConverter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final KSClassDeclaration invoke() {
                return UtilsKt.getClassDeclarationByName((Resolver)IterableToXConverter.access$getResolver(this.this$0), (String)this.this$0.getTargetFQN());
            }
        }));
        this.targetType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KSType>(this){
            final /* synthetic */ IterableToXConverter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final KSType invoke() {
                KSClassDeclaration kSClassDeclaration = IterableToXConverter.access$getTargetClassDeclaration(this.this$0);
                return kSClassDeclaration != null ? kSClassDeclaration.asStarProjectedType() : null;
            }
        }));
        this.enabledByDefault = true;
    }

    @NotNull
    public final String getTargetFQN() {
        return this.targetFQN;
    }

    private final KSType getIterableType() {
        Lazy lazy = this.iterableType$delegate;
        return (KSType)lazy.getValue();
    }

    private final KSClassDeclaration getTargetClassDeclaration() {
        Lazy lazy = this.targetClassDeclaration$delegate;
        return (KSClassDeclaration)lazy.getValue();
    }

    private final KSType getTargetType() {
        Lazy lazy = this.targetType$delegate;
        return (KSType)lazy.getValue();
    }

    public boolean getEnabledByDefault() {
        return this.enabledByDefault;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(@NotNull KSType source, @NotNull KSType target) {
        KSTypeReference kSTypeReference;
        KSType kSType;
        TypeConverter it;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.getTargetType() == null) {
            return false;
        }
        if (!this.handleNullable(source, target, (Function2)new Function2<KSType, KSType, Boolean>(this){
            final /* synthetic */ IterableToXConverter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull KSType sourceNotNullable, @NotNull KSType targetNotNullable) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)sourceNotNullable, (String)"sourceNotNullable");
                Intrinsics.checkNotNullParameter((Object)targetNotNullable, (String)"targetNotNullable");
                if (IterableToXConverter.access$getIterableType(this.this$0).isAssignableFrom(sourceNotNullable)) {
                    KSType kSType = IterableToXConverter.access$getTargetType(this.this$0);
                    Intrinsics.checkNotNull((Object)kSType);
                    if (kSType.isAssignableFrom(targetNotNullable) && IterableToXConverter.access$isExactlyTarget(this.this$0, targetNotNullable)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        })) return false;
        Iterable $this$any$iv = (Iterable)TypeConverterRegistry.INSTANCE;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (TypeConverter)element$iv;
            boolean bl = false;
            KSTypeReference kSTypeReference2 = ((KSTypeArgument)source.getArguments().get(0)).getType();
            Intrinsics.checkNotNull((Object)kSTypeReference2);
            kSType = kSTypeReference2.resolve();
            kSTypeReference = ((KSTypeArgument)target.getArguments().get(0)).getType();
            Intrinsics.checkNotNull((Object)kSTypeReference);
        } while (!it.matches(kSType, kSTypeReference.resolve()));
        return true;
    }

    @NotNull
    public CodeBlock convert(@NotNull String fieldName, @NotNull KSType source, @NotNull KSType target) {
        String string;
        Object object;
        Object element$iv2;
        KSType genericTargetType;
        KSType genericSourceType;
        Variance genericTargetVariance;
        block10: {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Variance it = ((KSTypeArgument)target.getArguments().get(0)).getVariance();
            boolean bl = false;
            genericTargetVariance = it == Variance.INVARIANT ? ((KSTypeParameter)target.getDeclaration().getTypeParameters().get(0)).getVariance() : it;
            KSTypeReference kSTypeReference = ((KSTypeArgument)source.getArguments().get(0)).getType();
            Intrinsics.checkNotNull((Object)kSTypeReference);
            genericSourceType = kSTypeReference.resolve();
            KSTypeReference kSTypeReference2 = ((KSTypeArgument)target.getArguments().get(0)).getType();
            Intrinsics.checkNotNull((Object)kSTypeReference2);
            genericTargetType = kSTypeReference2.resolve();
            Iterable $this$first$iv = (Iterable)TypeConverterRegistry.INSTANCE;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TypeConverter it2 = (TypeConverter)element$iv2;
                boolean bl2 = false;
                if (!it2.matches(genericSourceType, genericTargetType)) continue;
                break block10;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        TypeConverter typeConverter = (TypeConverter)element$iv2;
        String nc = ExtensionsKt.isNullable((KSType)source) ? "?" : "";
        boolean listTypeChanged = false;
        boolean castNeeded = false;
        List args = new ArrayList();
        if (Intrinsics.areEqual((Object)genericSourceType, (Object)genericTargetType)) {
            object = fieldName;
        } else if (this.needsNotNullAssertionOperator(genericSourceType, genericTargetType)) {
            listTypeChanged = true;
            object = fieldName + nc + ".map\u00b7{\u00b7it!!\u00b7}";
        } else if (Intrinsics.areEqual((Object)genericSourceType, (Object)genericTargetType.makeNotNullable())) {
            if (genericTargetVariance == Variance.INVARIANT) {
                castNeeded = true;
            }
            object = fieldName;
        } else {
            listTypeChanged = true;
            ((Collection)args).add(typeConverter.convert("it", genericSourceType, genericTargetType));
            object = fieldName + nc + ".map\u00b7{ %L }";
        }
        String mapSourceContentCode = object;
        CodeBlock mapSourceContainerCode = this.matchesTarget(listTypeChanged, source) ? CodeBlock.Companion.of("", new Object[0]) : this.convertIterable(nc);
        ((Collection)args).add(mapSourceContainerCode);
        String code = mapSourceContentCode + "%L" + this.appendNotNullAssertionOperatorIfNeeded(source, target);
        if (castNeeded) {
            ((Collection)args).add(KsTypesKt.toTypeName$default((KSType)target, null, (int)1, null));
            string = "(" + code + "\u00b7as\u00b7%T)";
        } else {
            string = code;
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        return CodeBlock.Companion.of(string, Arrays.copyOf(objectArray, objectArray.length));
    }

    private final boolean isExactlyTarget(KSType $this$isExactlyTarget) {
        return Intrinsics.areEqual((Object)ExtensionsKt.classDeclaration((KSType)$this$isExactlyTarget), (Object)this.getTargetClassDeclaration());
    }

    protected final boolean isInstanceOfTarget(@NotNull KSType $this$isInstanceOfTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$isInstanceOfTarget, (String)"<this>");
        KSType kSType = this.getTargetType();
        Intrinsics.checkNotNull((Object)kSType);
        return kSType.isAssignableFrom($this$isInstanceOfTarget.starProjection().makeNotNullable());
    }

    @NotNull
    public abstract CodeBlock convertIterable(@NotNull String var1);

    public boolean matchesTarget(boolean listTypeChanged, @NotNull KSType source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !listTypeChanged && this.isInstanceOfTarget(source);
    }

    public static final /* synthetic */ KSType access$getIterableType(IterableToXConverter $this) {
        return $this.getIterableType();
    }

    public static final /* synthetic */ KSType access$getTargetType(IterableToXConverter $this) {
        return $this.getTargetType();
    }

    public static final /* synthetic */ boolean access$isExactlyTarget(IterableToXConverter $this, KSType $receiver) {
        return $this.isExactlyTarget($receiver);
    }

    public static final /* synthetic */ Resolver access$getResolver(IterableToXConverter $this) {
        return $this.getResolver();
    }

    public static final /* synthetic */ KSClassDeclaration access$getTargetClassDeclaration(IterableToXConverter $this) {
        return $this.getTargetClassDeclaration();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/mcarle/konvert/converter/IterableToXConverter$Companion;", "", "()V", "supported", "", "", "supported$converter", "converter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> supported$converter() {
            Object[] objectArray = new String[]{"kotlin.collections.Iterable", "kotlin.collections.MutableIterable", "kotlin.collections.Collection", "kotlin.collections.MutableCollection", "kotlin.collections.List", "kotlin.collections.MutableList", "java.util.ArrayList", "kotlin.collections.Set", "kotlin.collections.MutableSet", "java.util.HashSet", "java.util.LinkedHashSet", "kotlinx.collections.immutable.ImmutableCollection", "kotlinx.collections.immutable.ImmutableList", "kotlinx.collections.immutable.ImmutableSet", "kotlinx.collections.immutable.PersistentCollection", "kotlinx.collections.immutable.PersistentList", "kotlinx.collections.immutable.PersistentSet"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

