/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.configtypes;

import io.microconfig.core.configtypes.ConfigType;
import io.microconfig.core.configtypes.ConfigTypeFilter;
import io.microconfig.utils.CollectionUtils;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.StreamUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class ConfigTypeFilters {
    public static ConfigTypeFilter eachConfigType() {
        return types -> types;
    }

    public static ConfigTypeFilter configType(ConfigType ... types) {
        return __ -> {
            if (types.length == 0) {
                throw ConfigTypeFilters.noConfigTypesProvidedException();
            }
            return Arrays.asList(types);
        };
    }

    public static ConfigTypeFilter configTypeWithName(String ... name) {
        Set names = CollectionUtils.setOf((Object[])name);
        if (names.isEmpty()) {
            throw ConfigTypeFilters.noConfigTypesProvidedException();
        }
        return types -> {
            ConfigTypeFilters.validateNames(names, types);
            return StreamUtils.filter((Collection)types, type -> names.contains(type.getName()));
        };
    }

    public static ConfigTypeFilter configTypeWithExtensionOf(File file) {
        String ext = FileUtils.getExtension((File)file);
        if (ext.isEmpty()) {
            throw new IllegalArgumentException("File " + file + " doesn't have an extension. Unable to resolve component type.");
        }
        return types -> types.stream().filter(t -> t.getSourceExtensions().contains(ext)).findFirst().map(Collections::singletonList).orElseThrow(() -> new IllegalArgumentException("Unsupported config extension '" + ext + "'"));
    }

    private static void validateNames(Set<String> names, List<ConfigType> supportedTypes) {
        Set supportedNames = supportedTypes.stream().map(ConfigType::getName).collect(Collectors.toSet());
        List unsupportedNames = StreamUtils.filter(names, n -> !supportedNames.contains(n));
        if (!unsupportedNames.isEmpty()) {
            throw new IllegalArgumentException("Unsupported config types: " + unsupportedNames + " Configured types: " + supportedNames);
        }
    }

    private static IllegalArgumentException noConfigTypesProvidedException() {
        return new IllegalArgumentException("No config types provided");
    }

    @Generated
    private ConfigTypeFilters() {
    }
}

