/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments;

import io.microconfig.core.configtypes.ConfigTypeFilter;
import io.microconfig.core.configtypes.ConfigTypeRepository;
import io.microconfig.core.environments.Component;
import io.microconfig.core.properties.Properties;
import io.microconfig.core.properties.PropertiesFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public class ComponentImpl
implements Component {
    private final ConfigTypeRepository configTypeRepository;
    private final PropertiesFactory propertiesFactory;
    private final String name;
    private final String originalName;
    private final String environment;

    public Properties getPropertiesFor(ConfigTypeFilter filter) {
        List filteredTypes = filter.selectTypes(this.configTypeRepository.getConfigTypes());
        return this.propertiesFactory.getPropertiesOf(this.name, this.originalName, this.environment, filteredTypes);
    }

    public String toString() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentImpl)) {
            return false;
        }
        ComponentImpl other = (ComponentImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$originalName = this.getOriginalName();
        String other$originalName = other.getOriginalName();
        if (this$originalName == null ? other$originalName != null : !this$originalName.equals(other$originalName)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $originalName = this.getOriginalName();
        result = result * 59 + ($originalName == null ? 43 : $originalName.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    @ConstructorProperties(value={"configTypeRepository", "propertiesFactory", "name", "originalName", "environment"})
    @Generated
    public ComponentImpl(ConfigTypeRepository configTypeRepository, PropertiesFactory propertiesFactory, String name, String originalName, String environment) {
        this.configTypeRepository = configTypeRepository;
        this.propertiesFactory = propertiesFactory;
        this.name = name;
        this.originalName = originalName;
        this.environment = environment;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOriginalName() {
        return this.originalName;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }
}

