/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments.repository;

import io.microconfig.core.environments.repository.ComponentGroupDefinition;
import io.microconfig.core.environments.repository.EnvironmentDefinition;
import io.microconfig.utils.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import lombok.Generated;

class EnvInclude {
    private static final EnvInclude empty = new EnvInclude("", Collections.emptySet());
    private final String baseEnvironment;
    private final Set<String> excludedGroups;

    public static EnvInclude empty() {
        return empty;
    }

    public EnvironmentDefinition includeTo(EnvironmentDefinition destinationEnv, Function<String, EnvironmentDefinition> repository) {
        Map<String, ComponentGroupDefinition> baseGroupByName = this.findBaseGroupsUsing(repository, destinationEnv);
        StreamUtils.forEach(destinationEnv.getGroups(), this.overrideBaseGroupIn(baseGroupByName).andThen(this.putOverriddenGroupTo(baseGroupByName)));
        return this.assignGroupsTo(destinationEnv, baseGroupByName.values());
    }

    private Map<String, ComponentGroupDefinition> findBaseGroupsUsing(Function<String, EnvironmentDefinition> repository, EnvironmentDefinition destinationEnv) {
        EnvironmentDefinition baseEnv = repository.apply(this.baseEnvironment);
        return (Map)StreamUtils.forEach(this.notExcludedGroupsFrom(baseEnv), this.assignIpOf(destinationEnv), this.resultsToMap());
    }

    private List<ComponentGroupDefinition> notExcludedGroupsFrom(EnvironmentDefinition baseEnv) {
        return StreamUtils.filter(baseEnv.getGroups(), group -> !this.excludedGroups.contains(group.getName()));
    }

    private UnaryOperator<ComponentGroupDefinition> assignIpOf(EnvironmentDefinition destinationEnv) {
        return group -> destinationEnv.getIp() == null ? group : group.withIp(destinationEnv.getIp());
    }

    private UnaryOperator<ComponentGroupDefinition> overrideBaseGroupIn(Map<String, ComponentGroupDefinition> baseGroupByName) {
        return destinationGroup -> {
            ComponentGroupDefinition baseGroup = (ComponentGroupDefinition)baseGroupByName.get(destinationGroup.getName());
            return baseGroup == null ? destinationGroup : baseGroup.overrideBy((ComponentGroupDefinition)destinationGroup);
        };
    }

    private EnvironmentDefinition assignGroupsTo(EnvironmentDefinition destinationEnv, Collection<ComponentGroupDefinition> groups) {
        return destinationEnv.withGroups(new ArrayList<ComponentGroupDefinition>(groups)).withEnvInclude(EnvInclude.empty());
    }

    private Collector<ComponentGroupDefinition, ?, Map<String, ComponentGroupDefinition>> resultsToMap() {
        return StreamUtils.toLinkedMap(ComponentGroupDefinition::getName, Function.identity());
    }

    private Function<ComponentGroupDefinition, ComponentGroupDefinition> putOverriddenGroupTo(Map<String, ComponentGroupDefinition> baseGroupByName) {
        return overriddenGroup -> baseGroupByName.put(overriddenGroup.getName(), (ComponentGroupDefinition)overriddenGroup);
    }

    public boolean isEmpty() {
        return this.baseEnvironment.isEmpty();
    }

    @ConstructorProperties(value={"baseEnvironment", "excludedGroups"})
    @Generated
    public EnvInclude(String baseEnvironment, Set<String> excludedGroups) {
        this.baseEnvironment = baseEnvironment;
        this.excludedGroups = excludedGroups;
    }
}

