/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.environments.repository;

import io.microconfig.core.environments.ComponentFactory;
import io.microconfig.core.environments.Environment;
import io.microconfig.core.environments.EnvironmentImpl;
import io.microconfig.core.environments.EnvironmentRepository;
import io.microconfig.core.environments.repository.EnvironmentDefinition;
import io.microconfig.core.environments.repository.EnvironmentException;
import io.microconfig.core.environments.repository.EnvironmentFile;
import io.microconfig.core.properties.PropertiesFactory;
import io.microconfig.io.FsReader;
import io.microconfig.utils.FileUtils;
import io.microconfig.utils.StreamUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileEnvironmentRepository
implements EnvironmentRepository {
    public static final String ENV_DIR = "envs";
    private final File envDir;
    private final FsReader fsReader;
    private final ComponentFactory componentFactory;
    private final PropertiesFactory propertiesFactory;

    public FileEnvironmentRepository(File rootDir, FsReader fsReader, ComponentFactory componentFactory, PropertiesFactory propertiesFactory) {
        this.envDir = new File(rootDir, ENV_DIR);
        this.propertiesFactory = propertiesFactory;
        if (!this.envDir.exists()) {
            throw new IllegalArgumentException("'envs' directory doesn't exist: " + this.envDir);
        }
        this.fsReader = fsReader;
        this.componentFactory = componentFactory;
    }

    public List<Environment> environments() {
        return StreamUtils.forEach(this.environmentFiles(), this.parse());
    }

    public Set<String> environmentNames() {
        return (Set)StreamUtils.forEach(this.environmentFiles(), FileUtils::getName, Collectors.toCollection(TreeSet::new));
    }

    public Environment getByName(String name) {
        return this.findEnvWith(name).orElseThrow(this.notFoundException(name));
    }

    public Environment getOrCreateByName(String name) {
        return this.findEnvWith(name).orElseGet(this.fakeEnvWith(name));
    }

    private Optional<Environment> findEnvWith(String name) {
        return this.envFileWith(name).map(this.parse());
    }

    private Optional<File> envFileWith(String name) {
        List envFiles = StreamUtils.filter(this.environmentFiles(), this.withFileName(name));
        if (envFiles.size() > 1) {
            throw new EnvironmentException("Found several env files with name: " + name);
        }
        return envFiles.isEmpty() ? Optional.empty() : Optional.of(envFiles.get(0));
    }

    private List<File> environmentFiles() {
        try (Stream stream = FileUtils.walk((Path)this.envDir.toPath());){
            List<File> list = stream.map(Path::toFile).filter(this.hasSupportedExtension()).collect(Collectors.toList());
            return list;
        }
    }

    private Function<File, Environment> parse() {
        return this.parseDefinition().andThen(def -> def.toEnvironment(this.componentFactory, this.propertiesFactory));
    }

    private Function<File, EnvironmentDefinition> parseDefinition() {
        return f -> new EnvironmentFile((File)f).parseUsing(this.fsReader).processIncludeUsing(this.definitionRepository()).checkComponentNamesAreUnique();
    }

    private Function<String, EnvironmentDefinition> definitionRepository() {
        return name -> this.envFileWith((String)name).map(this.parseDefinition()).orElseThrow(this.notFoundException((String)name));
    }

    private Predicate<File> hasSupportedExtension() {
        return f -> {
            String name = f.getName();
            return name.endsWith(".yaml") || name.endsWith(".json");
        };
    }

    private Predicate<File> withFileName(String envName) {
        return f -> FileUtils.getName((File)f).equals(envName);
    }

    private Supplier<EnvironmentException> notFoundException(String name) {
        return () -> new EnvironmentException("Can't find env '" + name + "'. Available envs: " + this.environmentNames());
    }

    private Supplier<Environment> fakeEnvWith(String name) {
        return () -> new EnvironmentImpl(null, name, 0, Collections.emptyList(), this.componentFactory, this.propertiesFactory);
    }
}

